

<?php $__env->startSection('head_title', trans('words.dashboard_text').' | '.getcong('site_name') ); ?>

<?php $__env->startSection('head_url', Request::url()); ?>

<?php $__env->startSection('content'); ?>
  

<!--Breadcrumb section starts-->
<div class="breadcrumb-section bg-xs" style="background-image: url(<?php echo e(URL::asset('site_assets/images/breadcrumb-1.jpg')); ?>)">
    <div class="overlay op-2"></div>
    <div class="container">
      <div class="row">
        <div class="col-md-12 text-center">
          <div class="breadcrumb-menu">
            <h2><?php echo e(trans('words.dashboard_text')); ?></h2>
            <span><a href="<?php echo e(URL::to('/')); ?>"><?php echo e(trans('words.home')); ?></a></span> <span><?php echo e(trans('words.dashboard_text')); ?></span></div>
        </div>
      </div>
    </div>
  </div>
  <!--Breadcrumb section ends--> 
  
  <!--Dashboard section starts-->
  <div class="about-section pt-30 pb-20">
    <div class="container">
      <div class="row">
         <div class="col-lg-12 col-md-12">
			  <div class="vfx-statistic-wrap-area">
				<div class="row">
					<div class="col-xl-3 col-md-6 col-12">
						<a href="<?php echo e(URL::to('user/property')); ?>">
						<div class="vfx-statistic-item vfx-item-blue-violet">
							<div class="icon">
								<i class="fa fa-home"></i>
							</div>
							<h2 class="counter-value"><?php echo e($property_total); ?></h2>
							<span class="desc"><?php echo e(trans('words.total_properties')); ?></span>                                
						</div>
						</a>
					</div>
					<div class="col-xl-3 col-md-6 col-12">
						<a href="<?php echo e(URL::to('user/property')); ?>">
						<div class="vfx-statistic-item vfx-item-green">
							<div class="icon">
								<i class="fa fa-home"></i>
							</div>
							<h2 class="counter-value"><?php echo e($property_active); ?></h2>
							<span class="desc"><?php echo e(trans('words.active_properties')); ?></span>                                
						</div>
						</a>
					</div>
					<div class="col-xl-3 col-md-6 col-12">
						<a href="<?php echo e(URL::to('user/property')); ?>">
						<div class="vfx-statistic-item vfx-item-orange">
							<div class="icon">
								<i class="fa fa-home"></i>
							</div>
							<h2 class="counter-value"><?php echo e($property_pending); ?></h2>
							<span class="desc"><?php echo e(trans('words.pending_properties')); ?></span>                                
						</div>
						</a>
					</div>
					<div class="col-xl-3 col-md-6 col-12">
						<a href="<?php echo e(URL::to('user/favourites')); ?>">
						<div class="vfx-statistic-item vfx-item-blue">
							<div class="icon">
								<i class="fa fa-heart"></i>
							</div>
							<h2 class="counter-value"><?php echo e($favourite_total); ?></h2>
							<span class="desc"><?php echo e(trans('words.favourites')); ?></span>                                
						</div>
						</a>
					</div>
				</div>
			</div>
		
			<div class="vfx-dashboard-content-area">
				<div class="row">
					<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
					   <div class="profile-section">
						 <div class="row">
							<div class="col-lg-6 col-md-12 col-sm-12 col-xs-12">
							  <div class="member-ship-option">
							  <h5 class="color-up"><?php echo e(trans('words.my_subscription')); ?></h5>
							  <?php if($user->plan_id!=0): ?>
								<span class="premuim-memplan-bold-text"><strong><?php echo e(trans('words.current_plan')); ?>:</strong><span><?php echo e(\App\SubscriptionPlan::getSubscriptionPlanInfo($user->plan_id,'plan_name')); ?></span></span>

								<span class="premuim-memplan-bold-text"><strong><?php echo e(trans('words.property_limit')); ?>:</strong><span><?php echo e(\App\SubscriptionPlan::getSubscriptionPlanInfo($user->plan_id,'plan_property_limit')); ?></span></span>               

								<?php if($user->exp_date): ?>
								<span class="premuim-memplan-bold-text"><strong><?php echo e(trans('words.subscription_expires_on')); ?>:</strong><span><?php echo e(date('F,  d, Y',$user->exp_date)); ?></span></span>
								<?php endif; ?>
                                
                                <div class="mt-2" style="border:1px solid #24314d;border-radius:6px;padding:10px;">
                                  <div class="premuim-memplan-bold-text" style="margin-bottom:4px;">
                                    <strong>Usage:</strong>
                                    <span>
                                      <?php echo e($properties_used); ?> / <?php echo e($property_limit); ?> properties
                                      (left <?php echo e($properties_left); ?>)
                                    </span>
                                  </div>
                                  <?php if(!is_null($ads_limit)): ?>
                                  <div class="premuim-memplan-bold-text">
                                    <strong>Ads:</strong>
                                    <span>
                                      <?php echo e($ads_used ?? '-'); ?> / <?php echo e($ads_limit); ?>

                                      <?php if(!is_null($ads_left)): ?> (left <?php echo e($ads_left); ?>) <?php endif; ?>
                                    </span>
                                  </div>
                                  <?php endif; ?>
                                  <?php if(!empty($expiry_date)): ?>
                                  <div class="premuim-memplan-bold-text"><strong>Expiry:</strong> <span><?php echo e($expiry_date); ?></span></div>
                                  <?php endif; ?>
                                </div>

                                <?php if(!empty($latest_cpr)): ?>
                                <div class="mt-2" style="border:1px solid #24314d;border-radius:6px;padding:10px;">
                                  <div class="premuim-memplan-bold-text" style="margin-bottom:6px;">
                                    <strong>Custom Plan Request:</strong>
                                    <span class="badge badge-info"><?php echo e(strtoupper($latest_cpr->status)); ?></span>
                                  </div>
                                  <div class="text-muted" style="margin-bottom:6px;">
                                    Requested: <?php echo e($latest_cpr->property_posts_requested); ?> properties
                                    <?php if($latest_cpr->ads_posts_requested): ?> | <?php echo e($latest_cpr->ads_posts_requested); ?> ads <?php endif; ?>
                                  </div>
                                  <?php if($latest_cpr->status==='awaiting_payment' && $latest_cpr->payment_link): ?>
                                    <a href="<?php echo e($latest_cpr->payment_link); ?>" class="btn btn-sm btn-primary">Pay Now</a>
                                  <?php elseif($latest_cpr->status==='pending' || $latest_cpr->status==='approved'): ?>
                                    <a href="<?php echo e(url('custom-plan/requests')); ?>" class="btn btn-sm btn-secondary">View Details</a>
                                  <?php elseif($latest_cpr->status==='rejected'): ?>
                                    <a href="<?php echo e(url('custom-plan/request')); ?>" class="btn btn-sm btn-danger">Request Again</a>
                                  <?php elseif($latest_cpr->status==='activated'): ?>
                                    <span class="text-success">Activated on <?php echo e(optional($latest_cpr->activated_at)->format('Y-m-d H:i')); ?></span>
                                  <?php endif; ?>
                                </div>
                                <?php endif; ?>

                                <a href="<?php echo e(URL::to('pricing')); ?>" class="btn vfx7 mt-2 mb-0 upgrad_plan"><?php echo e(trans('words.upgrade_plan')); ?></a>

								<?php else: ?>
								<a href="<?php echo e(URL::to('pricing')); ?>" class="btn vfx7 mt-2 mb-0 upgrad_plan"><?php echo e(trans('words.select_plan')); ?></a>	
								 
								<?php endif; ?>

							  </div>
							</div>
							<div class="col-lg-6 col-md-12 col-sm-12 col-xs-12">
							   <div class="member-ship-option">
								                                  <h5 class="color-up"><?php echo e(trans('words.last_invoice')); ?></h5>
                                  <span class="premuim-memplan-bold-text"><strong><?php echo e(trans('words.date')); ?>:</strong>
                                  	<?php if($user->start_date): ?>
									<span><?php echo e(date('F,  d, Y',$user->start_date)); ?></span>
                                    <?php endif; ?>
                                  </span>
                                  <span class="premuim-memplan-bold-text"><strong><?php echo e(trans('words.plan')); ?>:</strong>
                                  	<?php if($user->plan_id): ?>
									<span><?php echo e(\App\SubscriptionPlan::getSubscriptionPlanInfo($user->plan_id,'plan_name')); ?></span>
									<?php endif; ?>
                                  </span>
                                  <span class="premuim-memplan-bold-text"><strong><?php echo e(trans('words.amount')); ?>:</strong>
                                  	<?php if($user->plan_amount): ?>
									<span><?php echo e(number_format($user->plan_amount,2,'.', '')); ?></span>
									<?php endif; ?>
                                  </span>
							   </div>
							</div>
						  </div>
					   </div>
					</div>

					<!-- Custom Plan Center & Quick Actions -->
					<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
					  <div class="row">
					    <div class="col-lg-8 col-md-12">
					      <div class="member-ship-option" style="border:1px solid #24314d;border-radius:8px;padding:15px;">
					        <h5 class="color-up">Custom Plan Center</h5>
					        <?php
					          $usagePercent = ($property_limit>0) ? min(100, round(($properties_used/$property_limit)*100)) : 0;
					        ?>
					        <div class="premuim-memplan-bold-text mb-2"><strong>Property Usage:</strong> <?php echo e($properties_used); ?> / <?php echo e($property_limit); ?> (left <?php echo e($properties_left); ?>)</div>
					        <div class="progress" style="height:10px;background:#1a2234;border-radius:6px;">
					          <div class="progress-bar" role="progressbar" style="width: <?php echo e($usagePercent); ?>%; background:#10c469;" aria-valuenow="<?php echo e($usagePercent); ?>" aria-valuemin="0" aria-valuemax="100"></div>
					        </div>
					        <?php if(!empty($expiry_date)): ?>
					        <div class="text-muted small mt-2">Expiry: <?php echo e($expiry_date); ?></div>
					        <?php endif; ?>

					        <?php if(!empty($latest_cpr)): ?>
					          <div class="mt-3" style="border:1px dashed #2b3a5f;border-radius:6px;padding:10px;">
					            <div class="d-flex align-items-center justify-content-between">
					              <div>
					                <div class="premuim-memplan-bold-text"><strong>Latest Request:</strong> <span class="badge badge-info"><?php echo e(strtoupper($latest_cpr->status)); ?></span></div>
					                <div class="text-muted small">Requested: <?php echo e($latest_cpr->property_posts_requested); ?> properties <?php if($latest_cpr->ads_posts_requested): ?> | <?php echo e($latest_cpr->ads_posts_requested); ?> ads <?php endif; ?></div>
					              </div>
					              <div>
					                <?php if($latest_cpr->status==='awaiting_payment' && $latest_cpr->payment_link): ?>
					                  <a href="<?php echo e($latest_cpr->payment_link); ?>" class="btn btn-sm btn-primary">Pay Now</a>
					                <?php elseif($latest_cpr->status==='pending' || $latest_cpr->status==='approved'): ?>
					                  <a href="<?php echo e(url('custom-plan/requests')); ?>" class="btn btn-sm btn-secondary">View Details</a>
					                <?php elseif($latest_cpr->status==='rejected'): ?>
					                  <a href="<?php echo e(url('custom-plan/request')); ?>" class="btn btn-sm btn-danger">Request Again</a>
					                <?php elseif($latest_cpr->status==='activated'): ?>
					                  <span class="text-success small">Activated on <?php echo e(optional($latest_cpr->activated_at)->format('Y-m-d H:i')); ?></span>
					                <?php endif; ?>
					              </div>
					            </div>
					          </div>
					        <?php endif; ?>

					        <div class="mt-3">
					          <a href="<?php echo e(url('custom-plan/request')); ?>" class="btn vfx7">Request Custom Plan</a>
					          <a href="<?php echo e(url('custom-plan/requests')); ?>" class="btn btn-outline-secondary">My Requests</a>
					          <a href="<?php echo e(url('pricing')); ?>" class="btn btn-outline-primary">Browse Plans</a>
					        </div>
					      </div>
					    </div>
					    <div class="col-lg-4 col-md-12">
					      <div class="member-ship-option" style="border:1px solid #24314d;border-radius:8px;padding:15px;">
					        <h5 class="color-up">Quick Actions</h5>
					        <div class="d-flex flex-column">
					          <a class="btn btn-sm btn-primary mb-2" href="<?php echo e(url('user/property/add')); ?>">Add Property</a>
					          <a class="btn btn-sm btn-secondary mb-2" href="<?php echo e(url('user/property')); ?>">Manage Properties</a>
					          <a class="btn btn-sm btn-outline-info" href="<?php echo e(url('user/favourites')); ?>">My Favourites</a>
					        </div>
					      </div>
					    </div>
					  </div>
					</div>
					<div class="col-lg-12 col-md-12 col-sm-12 col-xs-12">
						<div class="vfx-popular-listing">
							<div class="vfx-act-title mb-15">
								<h5><?php echo e(trans('words.user_plan_history')); ?></h5>
							</div>
							<div class="table-wrapper">
							  <table class="fl-table">
								<thead>
								  <tr>            
									<th><?php echo e(trans('words.plan')); ?></th>
									<th><?php echo e(trans('words.amount')); ?></th>
									<th><?php echo e(trans('words.payment_gateway')); ?></th>
									<th><?php echo e(trans('words.payment_id')); ?></th>
									<th>Type</th>
									<th>Reference</th>
									<th><?php echo e(trans('words.payment_date')); ?></th>
								  </tr>
								</thead> 
								<tbody>
									<?php $__currentLoopData = $transactions_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction_data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
									<tr>                      
										<td><span class="current-plan-item"><?php echo e(\App\SubscriptionPlan::getSubscriptionPlanInfo($transaction_data->plan_id,'plan_name')); ?></span></td>
										<td><?php echo e(html_entity_decode(getCurrencySymbols(getcong('currency_code')))); ?> <?php echo e(number_format($transaction_data->payment_amount,2)); ?></td>
										<td><?php echo e($transaction_data->gateway); ?></td>
										<td><?php echo e($transaction_data->payment_id); ?></td>    
										<td>
										  <?php if(!empty($transaction_data->reference_id) && strpos($transaction_data->reference_id, 'CPR_') === 0): ?>
										    <span class="badge badge-info">Custom Plan</span>
										  <?php else: ?>
										    <span class="badge badge-secondary">Standard</span>
										  <?php endif; ?>
										</td>
										<td><?php echo e($transaction_data->reference_id ?: '-'); ?></td>
										<td><span class="expires-plan-item"><?php echo e(date('M d Y h:i A',$transaction_data->date)); ?></span></td>            
								  	</tr>
									<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
						 
								</tbody>
							  </table>

							  <!--pagination starts-->
							<div class="post-nav nav-res pt-20">
								<div class="row">
								
								<?php echo $__env->make('_particles.pagination', ['paginator' => $transactions_list], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>	 

								</div>
							</div>
							<!--pagination ends-->

							  						

							</div>
						</div>
					</div>
				</div>
			</div>
        </div>
      </div>
    </div>
  </div>
  <!--Dashboard section ends--> 

  <script type="text/javascript">

	'use strict';
    
    <?php if(Session::has('flash_message')): ?>     
 
      const Toast = Swal.mixin({
        toast: true,
        position: 'top-end',
        showConfirmButton: false,
        timer: 3000,
        timerProgressBar: false,        
      })

      Toast.fire({
        icon: 'success',
        title: '<?php echo e(Session::get('flash_message')); ?>'
      })     
     
  <?php endif; ?>

  <?php if(Session::has('success')): ?>     
 
      const Toast = Swal.mixin({
        toast: true,
        position: 'top-end',
        showConfirmButton: false,
        timer: 3000,
        timerProgressBar: false,       
      })

      Toast.fire({
        icon: 'success',
        title: '<?php echo e(Session::get('success')); ?>'
      })     
     
  <?php endif; ?>

  <?php if(Session::has('error_flash_message')): ?>     
 
      const Toast = Swal.mixin({
        toast: true,
        position: 'top-end',
        showConfirmButton: false,
        timer: 3000,
        timerProgressBar: false,        
      })

      Toast.fire({
        icon: 'error',
        title: '<?php echo e(Session::get('error_flash_message')); ?>'
      })     
     
  <?php endif; ?>
 
  </script>  
 
<?php $__env->stopSection(); ?>
<?php echo $__env->make('site_app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/dextragr/public_html/realestate.dextragroups.com/resources/views/pages/user/dashboard.blade.php ENDPATH**/ ?>