

<?php $__env->startSection('content'); ?>

  <div class="content-page">
      <div class="content">
        <div class="container-fluid">
          <div class="row">
            <div class="col-12">
              <div class="card-box table-responsive">

                <h4 class="mt-0 mb-3">Leads <?php if(isset($total)): ?> <small>(<?php echo e($total); ?>)</small> <?php endif; ?></h4>

                <?php if(isset($total) && $total == 0): ?>
                    <div class="alert alert-info">No leads yet. Once users request phone numbers or brochures, leads will appear here.</div>
                <?php endif; ?>

                <div class="table-responsive">
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Name</th>
                            <th>Phone</th>
                            <th>Email</th>
                            <th>Action</th>
                            <th>Property</th>
                            <th>IP</th>
                            <th>Created</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $leads; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $lead): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr id="lead_<?php echo e($lead->id); ?>">
                                <td><?php echo e($lead->id); ?></td>
                                <td><?php echo e($lead->name); ?></td>
                                <td><?php echo e($lead->phone); ?></td>
                                <td><?php echo e($lead->email); ?></td>
                                <td><?php echo e($lead->action); ?></td>
                <td>
                  <?php
                    $prop = $lead->property ?? null;
                    if(!$prop && isset($lead->property_id)) {
                      $prop = \App\Property::find($lead->property_id);
                    }
                  ?>
                  <?php if($prop): ?>
                    <a href="<?php echo e(url('properties/'.$prop->slug.'/'.$prop->id)); ?>">
                      <?php if(isset($prop->title) && $prop->title != ''): ?>
                        <?php echo e(Str::limit(stripslashes($prop->title), 40)); ?>

                      <?php else: ?>
                        <?php echo e($prop->reference_number); ?>

                      <?php endif; ?>
                    </a>
                  <?php else: ?>
                    N/A
                  <?php endif; ?>
                </td>
                                <td><?php echo e($lead->ip); ?></td>
                                <td><?php echo e($lead->created_at); ?></td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td colspan="8">No leads to display.</td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
                </div>

                <nav class="paging_simple_numbers">
                  <?php echo $__env->make('admin.pagination', ['paginator' => $leads], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                </nav>

              </div>
            </div>
          </div>
        </div>
      </div>
      <?php echo $__env->make('admin.copyright', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  </div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.admin_app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/dextragr/public_html/floorlocator/resources/views/admin/pages/leads/index.blade.php ENDPATH**/ ?>