

<?php $__env->startSection("content"); ?>

  <div class="content-page">
    <div class="content" style="max-height: calc(100vh - 120px); overflow:auto;">
      <div class="container-fluid">
        <div class="row">
          <div class="col-lg-12">
            <div class="card-box">
              <h5 class="mb-4" style="color:#f9f9f9"><i class="fa fa-buysellads pr-2"></i> <b><?php echo e($page_title); ?></b></h5>

              <div class="d-flex justify-content-between align-items-center mb-3">
                <div></div>
                <a href="<?php echo e(url('admin/banner-ads/' . $position . '/create')); ?>" class="btn btn-success">Add Banner</a>
              </div>

              <div class="table-responsive">
                <table class="table table-bordered mb-0">
                  <thead>
                    <tr>
                      <th>S.No</th>
                      <th>Name</th>
                      <th>Page</th>
                      <th>Position</th>
                      <th>Image</th>
                      <th>Redirect URL</th>
                      <th>Status</th>
                      <th>Start</th>
                      <th>End</th>
                      <th>Actions</th>
                    </tr>
                  </thead>
                  <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $ads; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $ad): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                      <tr data-id="<?php echo e($ad->id); ?>">
                        <td><?php echo e($loop->iteration); ?></td>
                        <td><?php echo e($ad->name); ?></td>
                        <td><?php echo e($ad->page); ?></td>
                        <td><?php echo e($ad->position); ?></td>
                        <td>
                          <?php if(!empty($ad->image_path)): ?>
                            <img src="<?php echo e(asset($ad->image_path)); ?>" alt="<?php echo e($ad->name); ?>" style="height:40px;">
                          <?php endif; ?>
                        </td>
                        <td>
                          <?php if(!empty($ad->redirect_url)): ?>
                            <a href="<?php echo e($ad->redirect_url); ?>" target="_blank">Link</a>
                          <?php endif; ?>
                        </td>
                        <td>
                          <?php if($ad->status): ?>
                            <span class="badge badge-success">Active</span>
                          <?php else: ?>
                            <span class="badge badge-secondary">Inactive</span>
                          <?php endif; ?>
                        </td>
                        <td><?php echo e($ad->starts_at); ?></td>
                        <td><?php echo e($ad->ends_at); ?></td>
                        <td>
                          <a href="<?php echo e(url('admin/banner-ads/' . $position . '/' . $ad->id . '/edit')); ?>"
                            class="btn btn-icon waves-effect waves-light btn-success m-b-5 m-r-5" data-toggle="tooltip"
                            title="<?php echo e(trans('words.edit')); ?>"> <i class="fa fa-edit"></i> </a>
                          <?php echo e(html()->form('POST', url('admin/banner-ads/' . $position . '/' . $ad->id . '/delete'))->attributes(['style' => 'display:inline'])->open()); ?>

                          <button type="submit" class="btn btn-sm btn-danger"
                            onclick="return confirm('Delete this advertisement ?')"><i class="fa fa-remove"></i></button>
                          <?php echo e(html()->form()->close()); ?>

                        </td>
                      </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                      <tr>
                        <td colspan="10" class="text-center">No records found.</td>
                      </tr>
                    <?php endif; ?>
                  </tbody>
                </table>
              </div>

              <nav class="paging_simple_numbers">
                <?php echo $__env->make('admin.pagination', ['paginator' => $banners], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
              </nav>

            </div>
          </div>
        </div>
      </div>
    </div>
    <?php echo $__env->make("admin.copyright", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
  </div>

<?php $__env->stopSection(); ?>

<script type="text/javascript">
'use strict';

  <?php if(Session::has('flash_message')): ?>
    const Toast = Swal.mixin({
      toast: true,
      position: 'top-end',
      showConfirmButton: false,
      timer: 3000,
      timerProgressBar: false,
    })
    Toast.fire({
      icon: 'success',
      title: '<?php echo e(Session::get('flash_message')); ?>'
    })
  <?php endif; ?>

  <?php if(session()->has('errors')): ?>
    Swal.fire({
      icon: 'error',
      title: 'Oops...',
      html: '<p><?php $__currentLoopData = session('errors')->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?> <?php echo e($error); ?><br/> <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?></p>',
      showConfirmButton: true,
      confirmButtonColor: '#10c469',
      background:'#1a2234',
      color:'#fff'
    })
  <?php endif; ?>
</script>
<?php echo $__env->make("admin.admin_app", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/dextragr/public_html/floorlocator/resources/views/admin/pages/banner_ads/index.blade.php ENDPATH**/ ?>