<?php if(Auth::check() and getcong('recaptcha_on_contact_us')): ?>
    <script src='https://www.google.com/recaptcha/api.js'></script>
    <script>
        function submitForm() {
            var response = grecaptcha.getResponse();
            if (response.length == 0) {
                document.getElementById('g-recaptcha-error').innerHTML =
                    '<span style="color:red;">This field is required.</span>';
                return false;
            }

            return true;
        }

        function verifyCaptcha() {
            document.getElementById('g-recaptcha-error').innerHTML = '';
        }
    </script>
<?php endif; ?>

<div class="col-xl-4 order-xl-12 order-xl-1 order-1">
    <div id="list-sidebar" class="sidebar-right mt-30">
        <?php if(isset($owner_id) || isset($user_id)): ?>
            <?php $ownerToUse = isset($owner_id) ? $owner_id : (isset($user_id) ? $user_id : null); ?>
            <?php if($ownerToUse): ?>
                <?php
                    $ownerName = get_user_info($ownerToUse, 'name');
                    $ownerEmail = get_user_info($ownerToUse, 'email');
                    $ownerPhone = get_user_info($ownerToUse, 'phone');
                    $ownerImage = get_user_info($ownerToUse, 'user_image');
                    $memberSince = get_user_info($ownerToUse, 'created_at');
                    $listingsCount = \App\Property::where('user_id', $ownerToUse)->count();
                ?>
                
                
                <?php echo $__env->make('partials.phone-popup', ['uid' => 'owner_' . $ownerToUse, 'context' => 'owner', 'owner_id' => $ownerToUse], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                
               
                <div class="widget">
                    <div class="card border-0 shadow-sm">
                        <div class="card-body">
                            <div class="d-flex align-items-center">
                                <div class="mr-3">
                                    <?php if(!empty($ownerImage) && file_exists(public_path('upload/' . $ownerImage))): ?>
                                        <img src="<?php echo e(URL::to('upload/' . $ownerImage)); ?>" alt="user" class="rounded-circle" style="width:64px;height:64px;object-fit:cover;">
                                    <?php else: ?>
                                        <img src="<?php echo e(URL::to('site_assets/images/user-default.jpg')); ?>" alt="user" class="rounded-circle" style="width:64px;height:64px;object-fit:cover;">
                                    <?php endif; ?>
                                </div>
                                <div>
                                    <h5 class="mb-1"><?php echo e($ownerName); ?></h5>
                                    <div class="text-muted small">Member since <?php echo e($memberSince ? \Carbon\Carbon::parse($memberSince)->format('M Y') : 'N/A'); ?></div>
                                    <div class="text-muted small">Listings: <?php echo e($listingsCount); ?></div>
                                </div>
                            </div>
                            <hr>
                            <div class="d-flex flex-column">
                                <?php if(!empty($ownerPhone)): ?>
                                    <div class="mb-2" style="min-height: 42px;">
                                        <button type="button" 
                                                class="btn btn-danger" 
                                                id="btn-view-number-<?php echo e($ownerToUse); ?>" 
                                                data-toggle="modal" 
                                                data-target="#phonePopupModal_owner_<?php echo e($ownerToUse); ?>"
                                                onclick="document.getElementById('phonePopup_action_owner_<?php echo e($ownerToUse); ?>').value = 'view_number';"
                                                style="width: 100%; padding: 10px 15px; font-weight: 500; display: flex; align-items: center; justify-content: center; border-radius: 8px; background-color: #dc3545; border-color: #dc3545; transition: all 0.3s ease;">
                                            <i class="fa fa-phone mr-2"></i> <?php echo e(__('View Phone Number')); ?>

                                        </button>
                                    </div>

                                    <script>
                                        document.addEventListener('DOMContentLoaded', function() {
                                            const viewBtn = document.getElementById('btn-view-number-<?php echo e($ownerToUse); ?>');
                                            const uid = 'owner_<?php echo e($ownerToUse); ?>';
                                            
                                            // Initialize Bootstrap modal if not already initialized
                                            if (typeof bootstrap === 'undefined' && typeof $ !== 'undefined') {
                                                // Fallback to jQuery if Bootstrap JS not loaded directly
                                                window.bootstrap = { Modal: { getInstance: function(el) { return $(el).data('bs.modal'); } } };
                                            }
                                            
                                            // Handle phone number reveal event
                                            window.addEventListener('phonePopupRevealed', function(e) {
                                                if (e.detail && e.detail.uid === uid) {
                                                    console.log('Phone number revealed for:', uid);
                                                    const phoneNumber = e.detail.reveal.phone || '<?php echo e($ownerPhone); ?>';
                                                    
                                                    // Create or update the contact popup content
                                                    const contactHtml = `
                                                        <div class="modal fade" id="contactPopup_${uid}" tabindex="-1" role="dialog" aria-hidden="true">
                                                            <div class="modal-dialog modal-dialog-centered" role="document">
                                                                <div class="modal-content">
                                                                    <div class="modal-header">
                                                                        <h5 class="modal-title">Contact Seller</h5>
                                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                            <span aria-hidden="true">&times;</span>
                                                                        </button>
                                                                    </div>
                                                                    <div class="modal-body text-center">
                                                                        <div class="btn-group btn-group-lg mb-3" role="group" aria-label="Contact options">
                                                                            <a href="tel:${phoneNumber.replace(/[^0-9+]/g, '')}" class="btn btn-success" title="Call Now">
                                                                                <i class="fa fa-phone mr-2"></i> Call
                                                                            </a>
                                                                            <a href="https://wa.me/${phoneNumber.replace(/[^0-9]/g, '')}" class="btn btn-success" target="_blank" title="Chat on WhatsApp">
                                                                                <i class="fa fa-whatsapp mr-2"></i> WhatsApp
                                                                            </a>
                                                                            <button class="btn btn-primary btn-copy-number" data-number="${phoneNumber}" title="Copy Number">
                                                                                <i class="fa fa-copy mr-2"></i> Copy
                                                                            </button>
                                                                        </div>
                                                                        <div class="text-muted">
                                                                            <i class="fa fa-phone mr-1"></i> ${phoneNumber}
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    `;
                                                    
                                                    // Remove existing modal if it exists
                                                    const existingModal = document.getElementById('contactPopup_' + uid);
                                                    if (existingModal) {
                                                        $(existingModal).modal('hide').remove();
                                                    }
                                                    
                                                    // Add the new modal to the DOM
                                                    document.body.insertAdjacentHTML('beforeend', contactHtml);
                                                    
                                                    // Show the modal
                                                    $('#contactPopup_' + uid).modal('show');
                                                    
                                                    // Handle copy button click
                                                    document.querySelectorAll('.btn-copy-number').forEach(btn => {
                                                        btn.addEventListener('click', function() {
                                                            const phoneNumber = this.getAttribute('data-number');
                                                            navigator.clipboard.writeText(phoneNumber).then(() => {
                                                                const originalText = this.innerHTML;
                                                                this.innerHTML = '<i class="fa fa-check mr-2"></i> Copied!';
                                                                this.classList.add('btn-success');
                                                                this.classList.remove('btn-primary');
                                                                
                                                                setTimeout(() => {
                                                                    this.innerHTML = originalText;
                                                                    this.classList.remove('btn-success');
                                                                    this.classList.add('btn-primary');
                                                                }, 2000);
                                                            });
                                                        });
                                                    });
                                                }
                                            });
                                            
                                            // Handle view number button click
                                            if (viewBtn) {
                                                viewBtn.addEventListener('click', function(e) {
                                                    e.preventDefault();
                                                    console.log('View number button clicked');
                                                    
                                                    // Open the verification popup
                                                    const modalEl = document.getElementById('phonePopupModal_' + uid);
                                                    if (modalEl) {
                                                        // Set the action value
                                                        const actionInput = modalEl.querySelector('input[name="requested_action"]');
                                                        if (actionInput) actionInput.value = 'view_number';
                                                        
                                                        // Show the modal
                                                        if (typeof bootstrap !== 'undefined' && bootstrap.Modal) {
                                                            const modal = new bootstrap.Modal(modalEl);
                                                            modal.show();
                                                        } else if (typeof $ !== 'undefined') {
                                                            $(modalEl).modal('show');
                                                        } else {
                                                            modalEl.style.display = 'block';
                                                            modalEl.classList.add('show');
                                                        }
                                                    } else {
                                                        console.error('Phone popup modal not found');
                                                    }
                                                });
                                                
                                                // Make sure the button is visible
                                                viewBtn.style.display = 'inline-flex';
                                                viewBtn.style.alignItems = 'center';
                                                viewBtn.style.justifyContent = 'center';
                                            }
                                        });
                                    </script>
                                <?php endif; ?>
                                <!--<a href="<?php echo e(URL::to('properties/owner/' . $ownerToUse)); ?>" class="btn vfx7"><i class="fa fa-user"></i> View Profile & Listings</a>-->
                            </div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>
        <?php endif; ?>

        <div class="widget">
            <h3 class="widget-title"><?php echo e(trans('words.latest_property')); ?></h3>

            <?php $__currentLoopData = $latest_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $latest): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="row recent-list">
                    <div class="col-lg-5 col-4">
                        <div class="entry-img">
                            <a href="<?php echo e(URL::to('properties/' . $latest->slug . '/' . $latest->id)); ?>"
                                title="stripslashes($latest->title)">
                                <img src="<?php echo e(\URL::to('/' . $latest->image)); ?>" alt="latest"
                                    title="<?php echo e(stripslashes($latest->title)); ?>">
                            </a>

                            <?php if($latest->purpose == 'Rent'): ?>
                                <span><?php echo e(trans('words.rent')); ?></span>
                            <?php else: ?>
                                <span><?php echo e(trans('words.sale')); ?></span>
                            <?php endif; ?>

                        </div>
                    </div>
                    <div class="col-lg-7 col-8 no-pad-left">
                        <div class="entry-text">
                            <p class="text-tlt"><?php echo e($latest->types->type_name); ?></p>
                            <h4 class="entry-title"><a
                                    href="<?php echo e(URL::to('properties/' . $latest->slug . '/' . $latest->id)); ?>"
                                    title="<?php echo e(stripslashes($latest->title)); ?>"><?php echo e(Str::limit(stripslashes($latest->title), 20)); ?></a>
                            </h4>
                            <div class="vfx-property-location"> <i class="fa fa-map-marker"></i>
                                <p>
                                    <?php if(isset($latest->locations->name) and $latest->locations->name != ''): ?>
                                        <?php echo e($latest->locations->name); ?>

                                    <?php else: ?>
                                        <?php echo e(Str::limit(stripslashes($latest->address), 20)); ?>

                                    <?php endif; ?>
                                </p>
                            </div>
                            <div class="vfx-trend-open-price">
                                <?php echo e(html_entity_decode(getCurrencySymbols(getcong('currency_code')))); ?><?php echo e(number_format($latest->price)); ?>

                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>

        <?php if(get_web_banner('sidebar') != ''): ?>
            <div class="sidebar">
                <div class="add_banner_section">
                    <div class="col-md-12">

                        <?php echo stripslashes(get_web_banner('sidebar')); ?>


                    </div>
                </div>
            </div>
        <?php endif; ?>


    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
$(document).ready(function() {
    let phoneNumber = '';
    const ownerId = $('#viewPhoneBtn').data('owner-id');
    
    // Initialize tooltips
    $('[data-toggle="tooltip"]').tooltip();
    
    // Show phone verification modal
    $('#viewPhoneBtn').on('click', function() {
        // Check if already verified in session storage
        if (sessionStorage.getItem('phoneVerified_' + ownerId) === 'true') {
            const savedPhone = sessionStorage.getItem('verifiedPhone_' + ownerId);
            if (savedPhone) {
                showPhoneNumber(savedPhone);
                return;
            }
        }
        // Show verification modal if not verified
        $('#phoneVerificationModal').modal('show');
    });
    
    // Send OTP
    $('#sendOtpBtn').on('click', function() {
        phoneNumber = $('#phoneNumber').val().trim();
        
        if (!phoneNumber) {
            showAlert('Please enter a valid phone number', 'danger', '#phoneError');
            return;
        }
        
        // Show loading
        const $btn = $(this);
        const btnText = $btn.html();
        $btn.prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Sending...');
        
        // Send OTP request using existing /leads endpoint (action=verify_phone)
        $.ajax({
            url: '<?php echo e(url("leads")); ?>',
            type: 'POST',
            data: {
                _token: '<?php echo e(csrf_token()); ?>',
                action: 'verify_phone',
                phone: phoneNumber,
                // include owner id so backend can attach it to pending lead data
                owner_id: ownerId,
                requested_action: 'view_owner'
            },
            success: function(response) {
                if (response.status && response.status === 'ok') {
                    // Show OTP input
                    $('#phoneInputSection').hide();
                    $('#otpSection').show();
                    $('#phoneNumberDisplay').text(formatPhoneNumber(phoneNumber));
                    $('#sendOtpBtn').hide();
                    $('#verifyOtpBtn').show();
                    showAlert('Verification code sent successfully!', 'success', '#phoneError');
                } else {
                    showAlert(response.message || 'Failed to send OTP', 'danger', '#phoneError');
                }
            },
            error: function(xhr) {
                const error = xhr.responseJSON || {};
                showAlert(error.message || 'An error occurred. Please try again.', 'danger', '#phoneError');
            },
            complete: function() {
                $btn.prop('disabled', false).html(btnText);
            }
        });
    });
    
    // Verify OTP
    $('#verifyOtpBtn').on('click', function() {
        const code = $('#verificationCode').val().trim();
        
        if (!code || code.length !== 6) {
            showAlert('Please enter a valid 6-digit code', 'danger', '#otpError');
            return;
        }
        
        // Show loading
        const $btn = $(this);
        const btnText = $btn.html();
        $btn.prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Verifying...');
        
        // Verify OTP using existing /leads endpoint (action=verify_otp)
        $.ajax({
            url: '<?php echo e(url("leads")); ?>',
            type: 'POST',
            data: {
                _token: '<?php echo e(csrf_token()); ?>',
                action: 'verify_otp',
                phone: phoneNumber,
                otp: code,
                owner_id: ownerId,
                requested_action: 'view_owner'
            },
            success: function(response) {
                if (response.status && response.status === 'ok') {
                    var reveal = response.reveal || {};

                    // Close modal and show phone number if provided
                    if (reveal.phone) {
                        $('#phoneVerificationModal').modal('hide');
                        showPhoneNumber(reveal.phone);

                        // Store in session storage to remember verification
                        sessionStorage.setItem('phoneVerified_' + ownerId, 'true');
                        sessionStorage.setItem('verifiedPhone_' + ownerId, reveal.phone);

                        showAlert('Phone number verified successfully!', 'success', '#otpError');
                    } else {
                        showAlert(response.message || 'Phone number not available', 'danger', '#otpError');
                    }
                } else {
                    showAlert(response.message || 'Invalid verification code', 'danger', '#otpError');
                }
            },
            error: function(xhr) {
                const error = xhr.responseJSON || {};
                showAlert(error.message || 'An error occurred. Please try again.', 'danger', '#otpError');
            },
            complete: function() {
                $btn.prop('disabled', false).html(btnText);
            }
        });
    });
    
    // Resend OTP
    $('#resendOtp').on('click', function(e) {
        e.preventDefault();
        $('#sendOtpBtn').click();
    });
    
    // Hide phone number
    $('#hidePhoneNumber').on('click', function() {
        $('#phoneNumberContainer').slideUp();
        $('#viewPhoneBtn').show();
    });
    
    // Copy phone number to clipboard
    $('#copyPhoneBtn').on('click', function() {
        const phone = $('#displayPhoneNumber').text().trim();
        navigator.clipboard.writeText(phone).then(function() {
            const $btn = $(this);
            const originalTitle = $btn.attr('data-original-title');
            $btn.attr('data-original-title', 'Copied!').tooltip('show');
            $btn.attr('data-original-title', originalTitle);
            
            // Change icon to checkmark temporarily
            const $icon = $btn.find('i');
            const originalIcon = $icon.attr('class');
            $icon.removeClass().addClass('fa fa-check');
            
            setTimeout(function() {
                $btn.tooltip('hide');
                $icon.removeClass().addClass(originalIcon);
            }, 2000);
        }.bind(this)).catch(function() {
            showAlert('Failed to copy phone number', 'danger', '#phoneNumberContainer');
        });
    });
    
    // Format phone number for display
    function formatPhoneNumber(phone) {
        // Simple formatting - you can enhance this based on your needs
        return phone.replace(/(\d{3})(\d{3})(\d{4})/, '($1) $2-$3');
    }
    
    // Show alert message
    function showAlert(message, type, container) {
        const $alert = $('<div>', {
            class: `alert alert-${type} alert-dismissible fade show`,
            role: 'alert',
            html: `${message}<button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>`
        });
        
        $(container).html($alert);
        
        // Auto-dismiss after 5 seconds
        setTimeout(function() {
            $alert.alert('close');
        }, 5000);
    }
    
    // Show phone number function
    function showPhoneNumber(phone) {
        const formattedPhone = formatPhoneNumber(phone);
        
        // Update phone number display
        $('#displayPhoneNumber').text(formattedPhone);
        
        // Show verification badge
        $('#verificationBadge').show();
        
        // Update WhatsApp button
        const whatsappUrl = `https://wa.me/${phone.replace(/[^0-9]/g, '')}`;
        $('#whatsappBtn').attr('href', whatsappUrl).show();
        
        // Show the container with animation
        $('#phoneNumberContainer').slideDown();
        $('#viewPhoneBtn').hide();
        
        // Update call link
        $('#phoneNumberContainer').find('a[href^="tel:"]').attr('href', 'tel:' + phone);
    }
    
    // Check if already verified in session storage
    if (sessionStorage.getItem('phoneVerified_' + ownerId) === 'true') {
        const savedPhone = sessionStorage.getItem('verifiedPhone_' + ownerId);
        if (savedPhone) {
            showPhoneNumber(savedPhone);
        }
    }
    
    // Open compact popup when trigger clicked
    $(document).on('click', '.phone-popup-trigger', function(e){
        e.preventDefault();
        const uid = $(this).data('uid');
        const owner = $(this).data('owner-id');
        // set hidden owner id and requested action
        const actionInput = document.getElementById('phonePopup_action_' + uid);
        const ownerInput = document.getElementById('phonePopup_owner_' + uid);
        if (actionInput) actionInput.value = 'view_owner';
        if (ownerInput) ownerInput.value = owner;
        $('#phonePopupModal_' + uid).modal({backdrop:'static', keyboard:false}).modal('show');
    });

    // Listen for reveal
    window.addEventListener('phonePopupRevealed', function(ev){
        const d = ev.detail || {};
        // only accept owner events for this sidebar instance
        if (!d || !d.uid || !d.phone) return;
        // populate display and persist
        showPhoneNumber(d.phone);
        sessionStorage.setItem('phoneVerified_' + ownerId, 'true');
        sessionStorage.setItem('verifiedPhone_' + ownerId, d.phone);
    });
});
</script>
<?php $__env->stopPush(); ?>
<?php /**PATH /home/dextragr/public_html/floorlocator/resources/views/pages/sidebar_right.blade.php ENDPATH**/ ?>