<!-- Modern Filter Panel - Complete Integration -->
<?php echo e(html()->form('GET', url('/properties/map-data'))
  ->attributes(['class' => 'modern-filter-panel', 'id' => 'map-filter-form', 'name' => 'map-filter-form'])->open()); ?>


  <!-- Top Row: Location Search with Radius -->
  <div class="filter-top-row">
    <div class="location-search-group">
      <div class="radius-control">
        <label class="radius-label">Radius: <span id="radius-value">10 km</span></label>
        <input type="range" id="search-radius" name="radius" class="radius-slider" min="1" max="50" value="10">
      </div>
    </div>
    
    <div class="view-controls">
      <button type="button" id="prev-page" class="nav-btn" title="Previous">
        <i class="fa fa-chevron-left"></i> Prev
      </button>
      <button type="button" id="next-page" class="nav-btn" title="Next">
        Next <i class="fa fa-chevron-right"></i>
      </button>
    </div>
  </div>

  <!-- Purpose Tabs Row -->
  <div class="purpose-tabs-row">
  
    <div class="purpose-tabs">
      <div class="location-input-container">
        <i class="fa fa-map-marker location-icon"></i>
        <input type="text" name="search_text" id="location-search" class="location-input" 
               placeholder="<?php echo e(trans('words.search_by_title')); ?>" 
               value="<?php if(isset($_GET['search_text'])): ?><?php echo e($_GET['search_text']); ?><?php endif; ?>" autocomplete="off">
        <button type="button" id="use-gps" class="gps-button" title="My Location">
          <i class="fa fa-crosshairs"></i>
        </button>
      </div>
    </div>
      <button type="button" class="purpose-tab <?php if(!isset($_GET['purpose']) || $_GET['purpose'] == 'Sale'): ?> active <?php endif; ?>" data-purpose="Sale">
        <span class="tab-text"><?php echo e(trans('words.sale')); ?></span>
      </button>
      <button type="button" class="purpose-tab <?php if(isset($_GET['purpose']) && $_GET['purpose'] == 'Rent'): ?> active <?php endif; ?>" data-purpose="Rent">
        <span class="tab-text"><?php echo e(trans('words.rent')); ?></span>
      </button>
    
    
    <input type="hidden" name="purpose" id="purpose-input" value="<?php if(isset($_GET['purpose'])): ?><?php echo e($_GET['purpose']); ?><?php else: ?> Sale <?php endif; ?>">
  </div>

  <!-- Filter Dropdowns Row -->
  <div class="filter-dropdowns-row">
    <div class="filter-grid">
      <select name="type_id" id="map-property-type" class="filter-select">
        <option value=""><?php echo e(trans('words.type')); ?></option>
        <?php $__currentLoopData = \App\Type::where('status', 1)->orderby('type_name')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type_data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <option value="<?php echo e($type_data->id); ?>" <?php if(isset($_GET['type_id']) && $_GET['type_id'] == $type_data->id): ?> selected <?php endif; ?>>
            <?php echo e($type_data->type_name); ?>

          </option>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      </select>
      
      <select name="location_id" id="filter-location" class="filter-select">
        <option value=""><?php echo e(trans('words.location')); ?></option>
        <?php $__currentLoopData = \App\Location::where('status', 1)->orderby('name')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $location_data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <option value="<?php echo e($location_data->id); ?>" <?php if(isset($_GET['location_id']) && $_GET['location_id'] == $location_data->id): ?> selected <?php endif; ?>>
            <?php echo e($location_data->name); ?>

          </option>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      </select>
      
      <select name="furnishing" id="filter-furnishing" class="filter-select">
        <option value=""><?php echo e(trans('words.furnishing')); ?> : Any</option>
        <option value="Unfurnished" <?php if(isset($_GET['furnishing']) && $_GET['furnishing'] == "Unfurnished"): ?> selected <?php endif; ?>>Unfurnished</option>
        <option value="Semi-Furnished" <?php if(isset($_GET['furnishing']) && $_GET['furnishing'] == "Semi-Furnished"): ?> selected <?php endif; ?>>Semi-Furnished</option>
        <option value="Furnished" <?php if(isset($_GET['furnishing']) && $_GET['furnishing'] == "Furnished"): ?> selected <?php endif; ?>>Furnished</option>
      </select>
      
      <select name="verified" id="filter-verified" class="filter-select">
        <option value=""><?php echo e(trans('words.verified_status')); ?></option>
        <option value="NO" <?php if(isset($_GET['verified']) && $_GET['verified'] == "NO"): ?> selected <?php endif; ?>><?php echo e(trans('words.non_verified_properties')); ?></option>
        <option value="YES" <?php if(isset($_GET['verified']) && $_GET['verified'] == "YES"): ?> selected <?php endif; ?>><?php echo e(trans('words.verified_properties')); ?></option>
      </select>
      
      <button type="button" id="more-search-options" class="more-options-btn">
        <span class="btn-text">More Options</span>
        <i class="fa fa-chevron-down"></i>
      </button>
    </div>
  </div>

  <!-- Hidden Advanced Filters -->
  <div id="advanced-filters" class="advanced-filters" style="display: none;">
    <div class="advanced-grid">
      <div class="filter-actions">
        <button type="submit" class="apply-filters-btn">
          <i class="fa fa-search"></i> <?php echo e(trans('words.search_property')); ?>

        </button>
        <button type="button" id="reset-filters" class="reset-btn">
          <i class="fa fa-refresh"></i> Reset All
        </button>
      </div>
    </div>
  </div>

<?php echo e(html()->form()->close()); ?>

<?php /**PATH /home/dextragr/public_html/realestate.dextragroups.com/resources/views/pages/property/partials/map-filters.blade.php ENDPATH**/ ?>