

<?php $__env->startSection("content"); ?>

 
  <div class="content-page">
      <div class="content">
        <div class="container-fluid">
          <div class="row">
            <div class="col-lg-12">
              <div class="card-box">
                 <div class="row">
                 <div class="col-sm-6">
                      <a href="<?php echo e(URL::to('admin/property')); ?>"><h4 class="header-title m-t-0 m-b-30 text-primary pull-left" style="font-size: 20px;"><i class="fa fa-arrow-left"></i> <?php echo e(trans('words.back')); ?></h4></a>
                 </div>                  
               </div>  
               
               <?php echo e(html()->form('POST', url('/admin/property/add_edit'))
                     ->attributes(['class' => 'form-horizontal', 'id' => 'post_form', 'name' => 'post_form', 'role' => 'form', 'enctype' => 'multipart/form-data'])->open()); ?>

 
                  
                 <input type="hidden" name="id" value="<?php echo e(isset($info->id) ? $info->id : null); ?>">

                  <div class="form-group row">
                    <label class="col-sm-3 col-form-label"><?php echo e(trans('words.type')); ?>*</label>
                      <div class="col-sm-3">
                            <select class="form-control select2" name="type" id="type">   
                               <option value=""><?php echo e(trans('words.select_type')); ?></option>                            
                              <?php $__currentLoopData = $type_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type_data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>  
                                <option value="<?php echo e($type_data->id); ?>" <?php if(isset($info->id) AND $type_data->id==$info->type_id): ?> selected <?php endif; ?>><?php echo e($type_data->type_name); ?></option>
                              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>   
                            </select>
                      </div>

                      <label class="col-sm-2 col-form-label"><?php echo e(trans('words.purpose')); ?></label>
                      <div class="col-sm-3">
                            <select class="form-control" name="purpose" id="purpose">                               
                                <option value="Sale" <?php if(isset($info->purpose) AND $info->purpose=="Sale"): ?> selected <?php endif; ?>>Sale</option>
                                <option value="Rent" <?php if(isset($info->purpose) AND $info->purpose=="Rent"): ?> selected <?php endif; ?>>Rent</option>
                                                   
                            </select>
                      </div>
                  </div>

                  <div class="form-group row">
                    <label class="col-sm-3 col-form-label">User*</label>
                    <div class="col-sm-8">
                        <select class="form-control select2" name="user_id" id="user_id">
                            <option value="">Select user</option>
                            <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($user->id); ?>" <?php if(isset($info->user_id) AND $user->id==$info->user_id): ?> selected <?php endif; ?>><?php echo e($user->name); ?> (<?php echo e($user->email); ?>)</option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                  </div>
 
                  <div class="form-group row">
                    <label class="col-sm-3 col-form-label"><?php echo e(trans('words.property_title')); ?>*  </label>
                    <div class="col-sm-8">
                      <input type="text" name="title" value="<?php echo e(isset($info->title) ? stripslashes($info->title) : old('title')); ?>" class="form-control">
                    </div>
                  </div>

                  <div class="form-group row">
                    <label class="col-sm-3 col-form-label"><?php echo e(trans('words.description')); ?></label>
                    <div class="col-sm-8">
                    <textarea id="elm1" name="description" class="form-control"><?php echo e(isset($info->description) ? stripslashes($info->description) : null); ?></textarea>
                    </div>
                  </div><br/>
                   

                  <div class="form-group row">
                    <label class="col-sm-3 col-form-label"><?php echo e(trans('words.phone')); ?></label>
                    <div class="col-sm-3">
                      <input type="text" name="phone" value="<?php echo e(isset($info->phone) ? $info->phone : null); ?>" class="form-control">
                    </div>

                    <label class="col-sm-2 col-form-label"><?php echo e(trans('words.location_text')); ?> *</label>
                      <div class="col-sm-3">
                            <select class="form-control select2" name="location" id="location">   
                               <option value=""><?php echo e(trans('words.select_location')); ?></option>                            
                              <?php $__currentLoopData = $location_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $location_data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>  
                                <option value="<?php echo e($location_data->id); ?>" <?php if(isset($info->id) AND $location_data->id==$info->location_id): ?> selected <?php endif; ?>><?php echo e($location_data->name); ?></option>
                              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>   
                            </select>
                      </div>
                  </div>

                  <div class="form-group row">
                    <label class="col-sm-3 col-form-label">City *</label>
                    <div class="col-sm-3">
                      <select class="form-control select2" name="city_id" id="city_id">
                        <option value="">Select city</option>
                      </select>
                    </div>
                  </div>

                  <div class="form-group row">
                    <label class="col-sm-3 col-form-label"><?php echo e(trans('words.address')); ?> </label>
                    <div class="col-sm-8">
                      <input type="text" name="address" value="<?php echo e(isset($info->address) ? stripslashes($info->address) : null); ?>" class="form-control">
                    </div>
                  </div>

                  <div class="form-group row">
                    <label class="col-sm-3 col-form-label"><?php echo e(trans('words.lat_long')); ?>

                    <small class="form-text text-muted">Click on the map to select location or use current location</small> 
                    </label>
                    <div class="col-sm-9">
                      <div class="row">
                        <div class="col-sm-5">
                          <input type="text" name="latitude" id="latitude" value="<?php echo e(isset($info->latitude) ? stripslashes($info->latitude) : null); ?>" class="form-control" placeholder="Latitude" readonly>
                        </div>
                        <div class="col-sm-5">
                          <input type="text" name="longitude" id="longitude" value="<?php echo e(isset($info->longitude) ? stripslashes($info->longitude) : null); ?>" class="form-control" placeholder="Longitude" readonly>    
                        </div>
                        <div class="col-sm-2">
                          <button type="button" id="getCurrentLocation" class="btn btn-info btn-block">
                            <i class="fa fa-location-arrow"></i> Current Location
                          </button>
                        </div>
                      </div>
                      <div id="map" style="height: 400px; width: 100%; margin-top: 10px; border: 1px solid #ddd;"></div>
                    </div>
                  </div>

                    <hr/>
                    <h4 class="m-t-0 m-b-30 header-title" style="font-size: 20px;">Overview</h4>

                    <div class="form-group row">
                    <label class="col-sm-3 col-form-label"><?php echo e(trans('words.bedrooms')); ?></label>
                    <div class="col-sm-3">
                      <input type="text" name="bedrooms" value="<?php echo e(isset($info->bedrooms) ? stripslashes($info->bedrooms) : null); ?>" class="form-control">
                    </div>
                    <label class="col-sm-2 col-form-label"><?php echo e(trans('words.bathrooms')); ?></label>
                    <div class="col-sm-3">
                      <input type="text" name="bathrooms" value="<?php echo e(isset($info->bathrooms) ? stripslashes($info->bathrooms) : null); ?>" class="form-control">
                    </div>
                    </div>

                    <div class="form-group row">
                    <label class="col-sm-3 col-form-label"><?php echo e(trans('words.area')); ?></label>
                    <div class="col-sm-3">
                      <input type="text" name="area" value="<?php echo e(isset($info->area) ? stripslashes($info->area) : null); ?>" class="form-control">
                    </div>
                    <label class="col-sm-2 col-form-label">Property Expired On</label>
                    <div class="col-sm-3">
                      <input type="date" name="property_expired_on" value="<?php echo e(isset($info->property_expired_on) ? date('Y-m-d', strtotime($info->property_expired_on)) : null); ?>" class="form-control">
                    </div>
                    </div>

                    <div class="form-group row">
                    <label class="col-sm-3 col-form-label"><?php echo e(trans('words.furnishing')); ?></label>
                    <div class="col-sm-3">
                      <select class="form-control" name="furnishing" id="furnishing">
                      <option value="Unfurnished" <?php if(isset($info->furnishing) AND $info->furnishing=="Unfurnished"): ?> selected <?php endif; ?>>Unfurnished</option>
                      <option value="Semi-Furnished" <?php if(isset($info->furnishing) AND $info->furnishing=="Semi-Furnished"): ?> selected <?php endif; ?>>Semi-Furnished</option>
                      <option value="Furnished" <?php if(isset($info->furnishing) AND $info->furnishing=="Furnished"): ?> selected <?php endif; ?>>Furnished</option>
                      </select>
                    </div>
                    <label class="col-sm-2 col-form-label">Number Of Units</label>
                    <div class="col-sm-3">
                      <input type="number" name="units" value="<?php echo e(isset($info->units) ? $info->units : null); ?>" class="form-control" min="1">
                    </div>
                    </div>

                    <div class="form-group row">
                    <label class="col-sm-3 col-form-label"><?php echo e(trans('words.price')); ?></label>
                    <div class="col-sm-3">
                      <input type="number" name="price" value="<?php echo e(isset($info->price) ? $info->price : null); ?>" class="form-control" min="1" step="1">
                    </div>
                    <label class="col-sm-2 col-form-label"><?php echo e(trans('words.verified')); ?></label>
                    <div class="col-sm-3">
                      <select class="form-control" name="verified">
                      <option value="NO" <?php if(isset($info->verified) AND $info->verified=="NO"): ?> selected <?php endif; ?>><?php echo e(trans('words.no')); ?></option>
                      <option value="YES" <?php if(isset($info->verified) AND $info->verified=="YES"): ?> selected <?php endif; ?>><?php echo e(trans('words.yes')); ?></option>
                      </select>
                    </div>
                    </div>

                    <div class="form-group row">
                    <label class="col-sm-3 col-form-label"><?php echo e(trans('words.amenities')); ?></label>
                    <div class="col-sm-8">
                      <!-- Hidden input to store selected amenities -->
                      <input type="hidden" name="amenities" id="amenities_input" value="<?php echo e(isset($info->amenities) ? stripslashes($info->amenities) : null); ?>">

                      <!-- Search and filter -->
                      <div class="amenities-search mb-3">
                      <input type="text" id="amenities_search" class="form-control" placeholder="Search amenities..." style="margin-bottom: 10px;">
                      <div class="amenities-filter mb-2">
                        <button type="button" class="btn btn-sm btn-outline-primary filter-btn active" data-category="all">All</button>
                        <button type="button" class="btn btn-sm btn-outline-primary filter-btn" data-category="basic">Basic</button>
                        <button type="button" class="btn btn-sm btn-outline-primary filter-btn" data-category="security">Security</button>
                        <button type="button" class="btn btn-sm btn-outline-primary filter-btn" data-category="entertainment">Entertainment</button>
                        <button type="button" class="btn btn-sm btn-outline-primary filter-btn" data-category="outdoor">Outdoor</button>
                        <button type="button" class="btn btn-sm btn-outline-primary filter-btn" data-category="utilities">Utilities</button>
                      </div>
                      </div>

                      <!-- Selected amenities display -->
                      <div class="selected-amenities mb-3">
                      <label class="form-label">Selected Amenities:</label>
                      <div id="selected_amenities_display" class="selected-amenities-container" style="min-height: 50px; border: 1px solid #ddd; padding: 10px; border-radius: 4px; background-color: #f8f9fa;">
                        <span class="text-muted">No amenities selected</span>
                      </div>
                      </div>

                      <!-- Amenities grid -->
                      <div class="amenities-grid" style="max-height: 300px; overflow-y: auto; border: 1px solid #ddd; padding: 15px; border-radius: 4px; background-color: #fff;">
                      <div class="row" id="amenities_container">
                        <!-- Amenities will be populated by JavaScript -->
                      </div>
                      </div>

                      <!-- Custom amenity input -->
                      <div class="custom-amenity mt-3">
                      <div class="input-group">
                        <input type="text" id="custom_amenity" class="form-control" placeholder="Add custom amenity...">
                        <div class="input-group-append">
                        <button type="button" class="btn btn-success" id="add_custom_amenity" onclick="return false;">Add</button>
                        </div>
                      </div>
                      </div>
                    </div>
                    </div>

                    <div class="form-group row">
                    <label class="col-sm-3 col-form-label">Youtube Video Link</label>
                    <div class="col-sm-8">
                      <input type="text" name="youtube_link" value="<?php echo e(isset($info->youtube_link) ? $info->youtube_link : old('youtube_link')); ?>" class="form-control" placeholder="https://www.youtube.com/watch?v=...">
                      <small class="form-text text-muted">Paste the YouTube video URL to embed on the property details page.</small>
                    </div>
                    </div>

                    <div class="form-group row">
                    <label class="col-sm-3 col-form-label"><?php echo e(trans('words.featured_image')); ?>*</label>
                    <div class="col-sm-8">
                      <div class="input-group">
                      <input type="text" name="image" id="image" value="<?php echo e(isset($info->image) ? stripslashes($info->image) : null); ?>" class="form-control" readonly>
                      <div class="input-group-append">
                        <button type="button" class="btn btn-dark waves-effect waves-light popup_selector" data-input="image" data-preview="holder_logo" data-inputid="image">Select</button>
                      </div>
                      </div>
                      <small class="form-text text-muted">(<?php echo e(trans('words.recommended_resolution')); ?> : 800x480, 600x350)</small>
                      <div id="image_holder" style="margin-top:5px;max-height:100px;"></div>
                    </div>
                    </div>

                    <?php if(isset($info->image)): ?>
                    <div class="form-group row">
                    <label class="col-sm-3 col-form-label">&nbsp;</label>
                    <div class="col-sm-8">
                      <img src="<?php echo e(URL::to('/'.$info->image)); ?>" alt="image" class="img-thumbnail" width="140">
                    </div>
                    </div>
                    <?php endif; ?>

                    <div class="form-group row">
                    <label class="col-sm-3 col-form-label"><?php echo e(trans('words.floor_plan_image')); ?></label>
                    <div class="col-sm-8">
                      <div class="input-group">
                      <input type="text" name="floor_plan_image" id="floor_plan_image" value="<?php echo e(isset($info->floor_plan_image) ? stripslashes($info->floor_plan_image) : null); ?>" class="form-control" readonly>
                      <div class="input-group-append">
                        <button type="button" class="btn btn-dark waves-effect waves-light popup_selector" data-input="floor_plan_image" data-preview="holder_logo" data-inputid="floor_plan_image">Select</button>
                      </div>
                      </div>
                      <small class="form-text text-muted">(<?php echo e(trans('words.recommended_resolution')); ?> : 800x480, 600x350)</small>
                      <div id="floor_plan_image_holder" style="margin-top:5px;max-height:100px;"></div>
                    </div>
                    </div>

                    <?php if(isset($info->floor_plan_image)): ?>
                    <div class="form-group row">
                    <label class="col-sm-3 col-form-label">&nbsp;</label>
                    <div class="col-sm-8">
                      <img src="<?php echo e(URL::to('/'.$info->floor_plan_image)); ?>" alt="image" class="img-thumbnail" width="140">
                    </div>
                    </div>
                    <?php endif; ?>

                    <div class="form-group row">
                    <label class="col-sm-3 col-form-label">Property Brochure (PDF)</label>
                    <div class="col-sm-8">
                      <input type="file" name="brochure_file" id="brochure_file" class="form-control" accept="application/pdf">
                      <small class="form-text text-muted">Upload property brochure in PDF format (max 20 MB)</small> 
                    </div>
                  </div>

                    <?php if(isset($info->brochure)): ?>
                    <div class="form-group row">
                    <label class="col-sm-3 col-form-label">&nbsp;</label>
                    <div class="col-sm-8">
                      <a href="<?php echo e(URL::to('/'.$info->brochure)); ?>" target="_blank" class="btn btn-info btn-sm">
                      <i class="fa fa-file-pdf-o"></i> View Brochure
                      </a>
                    </div>
                    </div>
                    <?php endif; ?>

                    <div class="form-group row">
                    <label class="col-sm-3 col-form-label"><?php echo e(trans('words.gallery_images')); ?></label>
                    <div class="col-sm-8">
                      <?php if(isset($info->id)): ?>
                      <div class="row">
                      <?php $__currentLoopData = $gallery_images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $gallery_img): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-md-6 col-xl-3 col-lg-4 gallery_block" id="gallery_box<?php echo e($gallery_img->id); ?>">
                        <span title="Delete" class="gall_delete_img">
                          <a href="#" class="image_remove" data-toggle="tooltip" title="<?php echo e(trans('words.remove')); ?>" data-id="<?php echo e($gallery_img->id); ?>"> <i class="fa fa-remove"></i> </a>
                        </span>
                        <img src="<?php echo e(url('/'.$gallery_img->image)); ?>" class="img-thumbnail" alt="gallery" width="140">
                        </div>
                      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                      </div>
                      <br/>
                      <?php endif; ?>

                      <div class="form-group row">
                      <label class="col-sm-2 col-form-label"><?php echo e(trans('words.image')); ?> 1</label>
                      <div class="col-sm-10">
                        <div class="input-group">
                        <input type="text" name="image_gallery[]" id="image1" value="" class="form-control" readonly>
                        <div class="input-group-append">
                          <button type="button" class="btn btn-dark waves-effect waves-light popup_selector" data-input="image" data-preview="holder_logo" data-inputid="image1">Select</button>
                        </div>
                        </div>
                        <div id="image1_holder" class="gallery_img_item" style="margin-top:5px;max-height:100px;"></div>
                      </div>
                      </div>

                      <div id="dynamicInput"></div>

                      <div class="form-group row">
                      <label class="col-sm-2 col-form-label">&nbsp;</label>
                      <div class="col-sm-10">
                        <button type="button" class="btn btn-success btn-xs" onClick="addInput('dynamicInput');"><?php echo e(trans('words.add_more_image')); ?></button>
                      </div>
                      </div>
                    </div>
                    </div>

                    <div class="form-group row">
                    <label class="col-sm-3 col-form-label"><?php echo e(trans('words.status')); ?></label>
                    <div class="col-sm-8">
                      <select class="form-control" name="status">
                      <option value="1" <?php if(isset($info->status) AND $info->status==1): ?> selected <?php endif; ?>><?php echo e(trans('words.active')); ?></option>
                      <option value="0" <?php if(isset($info->status) AND $info->status==0): ?> selected <?php endif; ?>><?php echo e(trans('words.inactive')); ?></option>
                      </select>
                    </div>
                    </div>
                    <div class="form-group row">
                    <div class="offset-sm-3 col-sm-9 pl-1">
                      <button type="submit" class="btn btn-primary waves-effect waves-light"> <?php echo e(trans('words.save')); ?></button>
                    </div>
                    </div>
                  <?php echo e(html()->form()->close()); ?>

              </div>
            </div>            
          </div>              
        </div>
      </div>

      <?php echo $__env->make("admin.copyright", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?> 
    
    </div>  

<script type="text/javascript">
    
     
// function to update the file selected by elfinder
function processSelectedFile(filePath, requestingField) {
   
  'use strict';    

    var elfinderUrl = "<?php echo e(URL::to('/')); ?>/";
     
      var target_preview = $('#'+requestingField+'_holder');
      target_preview.html('');
      target_preview.append(
              $('<img>').css('height', '5rem').attr('src', elfinderUrl + filePath.replace(/\\/g,"/"))
            );
      target_preview.trigger('change');
     
    $('#' + requestingField).val(filePath.replace(/\\/g,"/")).trigger('change');
 
}
 
 </script>

 <script type="text/javascript">
  
  'use strict';    

    <?php if(Session::has('flash_message')): ?>     
 
      const Toast = Swal.mixin({
        toast: true,
        position: 'top-end',
        showConfirmButton: false,
        timer: 3000,
        timerProgressBar: false,         
      })

      Toast.fire({
        icon: 'success',
        title: '<?php echo e(Session::get('flash_message')); ?>'
      })     
     
  <?php endif; ?>

  <?php
    $errors_html = '';
    if (isset($errors) && is_object($errors) && method_exists($errors, 'all')) {
        $errors_html = '<p>' . implode('<br/>', $errors->all()) . '</p>';
    }
  ?>

  <?php if($errors && is_object($errors) && $errors->any()): ?>
          Swal.fire({
            icon: 'error',
            title: 'Oops...',
            html: '<?php echo $errors_html; ?>',
            showConfirmButton: true,
            confirmButtonColor: '#10c469',
            background:"#1a2234",
            color:"#fff"
           }) 
  <?php endif; ?>
 
  </script>

<script src="<?php echo e(URL::asset('admin_assets/js/jquery.min.js')); ?>"></script>
<script type="text/javascript">
  $(document).ready(function(e) {

    'use strict';    
       
    $("#news_type").change(function(){         
        var type=$("#news_type").val();

        if(type=="Image")
        {   
            $("#gallery_section").show();
            $("#video_section").hide();
        }         
        else
        {
            $("#gallery_section").hide();
            $("#video_section").show();
            $("#url_id_sec").hide();
        }

    });  

    $("#news_video_type").change(function(){         
        var video_type=$("#news_video_type").val();

        if(video_type=="Local")
        {   
            $("#local_id_sec").show();
            $("#url_id_sec").hide();
        }         
        else
        {
            $("#local_id_sec").hide();
            $("#url_id_sec").show();
        }

    }); 

    // Populate cities on load if editing
    var initialLocation = $('#location').val();
    var selectedCity = '<?php echo e(isset($info->city_id) ? $info->city_id : ''); ?>';
    function loadCities(locId, selected){
      var $city = $('#city_id');
      $city.html('<option value="">Select city</option>').trigger('change');
      if(!locId){ return; }
      $.get("<?php echo e(url('admin/cities-by-location')); ?>/"+locId, function(res){
        if(res && res.status==1){
          var opts = '<option value="">Select city</option>';
          (res.cities || []).forEach(function(c){
            var sel = (String(selected)===String(c.id)) ? ' selected' : '';
            opts += '<option value="'+c.id+'"'+sel+'>'+c.name.replace(/&/g,'&amp;').replace(/</g,'&lt;')+'</option>';
          });
          $city.html(opts).trigger('change');
        }
      });
    }
    if(initialLocation){ loadCities(initialLocation, selectedCity); }
    $('#location').on('change', function(){ loadCities($(this).val(), ''); });
    
    // Brochure file size validation (max 20 MB)
    $('#brochure_file').on('change', function(){
      var file = this.files && this.files[0] ? this.files[0] : null;
      if(!file) return;
      var maxBytes = 20 * 1024 * 1024; // 20 MB
      if(file.size > maxBytes){
        // Reset input and alert user
        $(this).val('');
        Swal.fire({
          icon: 'error',
          title: 'File too large',
          text: 'Please upload a PDF up to 20 MB in size.',
          confirmButtonColor: '#10c469',
          background: '#1a2234',
          color: '#fff'
        });
      }
    });
  });
  });
</script>

<script type="text/javascript">
// JavaScript Document
'use strict';    
var counter = 1;
var limit = 50;
function addInput(divName){
     if (counter == limit)  {
          alert("You have reached the limit of adding " + counter + " inputs");
     }
     else {
          var newdiv = document.createElement('div');

          var wall_number=counter+1;

          newdiv.innerHTML ='<div class="form-group row"><label class="col-sm-2 col-form-label"><?php echo e(trans('words.image')); ?> '+wall_number+'</label><div class="col-sm-10"><div class="input-group"><input type="text" name="image_gallery[]" id="image'+wall_number+'" value="" class="form-control" readonly><div class="input-group-append"><button type="button" class="btn btn-dark waves-effect waves-light popup_selector" data-input="image" data-preview="holder_logo'+wall_number+'" data-inputid="image'+wall_number+'">Select</button></div></div><div id="image'+wall_number+'_holder" style="margin-top:5px;max-height:100px;"></div></div></div>';
          document.getElementById(divName).appendChild(newdiv);
          counter++;
     }
}

</script> 

<script type="text/javascript">
  //Single
  $(".image_remove").on('click', function () {      

   'use strict';    
  
  var post_id = $(this).data("id");
  var action_name='gallery_img_delete';

  Swal.fire({
  title: '<?php echo e(trans('words.dlt_warning')); ?>',
  text: "<?php echo e(trans('words.dlt_warning_text')); ?>",
  icon: 'warning',
  showCancelButton: true,
  confirmButtonColor: '#3085d6',
  cancelButtonColor: '#d33',
  confirmButtonText: '<?php echo e(trans('words.dlt_confirm')); ?>',
  cancelButtonText: "<?php echo e(trans('words.btn_cancel')); ?>",
  background:"#1a2234",
  color:"#fff"

}).then((result) => {

  //alert(post_id);

  //alert(JSON.stringify(result));

    if(result.isConfirmed) { 

        $.ajax({
            type: 'post',
            url: "<?php echo e(URL::to('admin/ajax_delete')); ?>",
            dataType: 'json',
            data: {"_token": "<?php echo e(csrf_token()); ?>",id: post_id, action_for: action_name},
            success: function(res) {

              if(res.status=='1')
              {  

                  var selector = "#gallery_box"+post_id;
                    $(selector ).fadeOut(1000);
                    setTimeout(function(){
                            $(selector ).remove()
                        }, 1000);

                  Swal.fire({
                    position: 'center',
                    icon: 'success',
                    title: '<?php echo e(trans('words.deleted')); ?>!',
                    showConfirmButton: true,
                    confirmButtonColor: '#10c469',
                    background:"#1a2234",
                    color:"#fff"
                  })
                
              } 
              else
              { 
                Swal.fire({
                        position: 'center',
                        icon: 'error',
                        title: 'Something went wrong!',
                        showConfirmButton: true,
                        confirmButtonColor: '#10c469',
                        background:"#1a2234",
                        color:"#fff"
                       })
              }
              
            }
        });
    }
 
})

});  
</script>
<!-- Leaflet CSS -->
<link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css" />

<!-- Leaflet JavaScript -->
<script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js"></script>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Initialize map with default location
    var map = L.map('map').setView([0, 0], 2);
    
    // Add OpenStreetMap tiles
    L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
        attribution: '© OpenStreetMap contributors'
    }).addTo(map);
    
    // Get current coordinates from form or try to get user's location
    var currentLat = parseFloat(document.getElementById('latitude').value) || 0;
    var currentLng = parseFloat(document.getElementById('longitude').value) || 0;
    
    var marker = null;
    
    // If we have existing coordinates, use them
    if (currentLat !== 0 && currentLng !== 0) {
        map.setView([currentLat, currentLng], 13);
        marker = L.marker([currentLat, currentLng]).addTo(map);
    } else {
        // Try to get user's current location
        if (navigator.geolocation) {
            navigator.geolocation.getCurrentPosition(
                function(position) {
                    var lat = position.coords.latitude;
                    var lng = position.coords.longitude;
                    
                    // Center map on user's location
                    map.setView([lat, lng], 13);
                    
                    // Add marker at user's location
                    marker = L.marker([lat, lng]).addTo(map);
                    
                    // Update form fields with current location
                    document.getElementById('latitude').value = lat.toFixed(6);
                    document.getElementById('longitude').value = lng.toFixed(6);
                },
                function(error) {
                    console.log('Geolocation error:', error);
                    // Fallback to a default location (e.g., center of the country or city)
                    map.setView([40.7128, -74.0060], 10); // New York City as fallback
                }
            );
        } else {
            // Fallback if geolocation is not supported
            map.setView([40.7128, -74.0060], 10); // New York City as fallback
        }
    }
    
    // Add click event to map
    map.on('click', function(e) {
        var lat = e.latlng.lat;
        var lng = e.latlng.lng;
        
        // Update input fields
        document.getElementById('latitude').value = lat.toFixed(6);
        document.getElementById('longitude').value = lng.toFixed(6);
        
        // Remove existing marker
        if (marker) {
            map.removeLayer(marker);
        }
        
        // Add new marker
        marker = L.marker([lat, lng]).addTo(map);
    });
    
    // Add geocoding functionality
    function geocodeAddress(address) {
        if (!address) return;
        
        // Using Nominatim (OpenStreetMap's geocoding service)
        fetch(`https://nominatim.openstreetmap.org/search?format=json&q=${encodeURIComponent(address)}&limit=1`)
            .then(response => response.json())
            .then(data => {
                if (data && data.length > 0) {
                    var lat = parseFloat(data[0].lat);
                    var lng = parseFloat(data[0].lon);
                    
                    map.setView([lat, lng], 13);
                    
                    // Update input fields
                    document.getElementById('latitude').value = lat.toFixed(6);
                    document.getElementById('longitude').value = lng.toFixed(6);
                    
                    // Remove existing marker
                    if (marker) {
                        map.removeLayer(marker);
                    }
                    
                    // Add new marker
                    marker = L.marker([lat, lng]).addTo(map);
                }
            })
            .catch(error => console.error('Geocoding error:', error));
    }
    
    // Add geocoding when address changes
    var addressInput = document.querySelector('input[name="address"]');
    if (addressInput) {
        addressInput.addEventListener('blur', function() {
            if (this.value.trim()) {
                geocodeAddress(this.value);
            }
        });
    }
    
    // Add current location button functionality
    var getCurrentLocationBtn = document.getElementById('getCurrentLocation');
    if (getCurrentLocationBtn) {
        getCurrentLocationBtn.addEventListener('click', function() {
            if (navigator.geolocation) {
                getCurrentLocationBtn.innerHTML = '<i class="fa fa-spinner fa-spin"></i> Getting Location...';
                getCurrentLocationBtn.disabled = true;
                
                navigator.geolocation.getCurrentPosition(
                    function(position) {
                        var lat = position.coords.latitude;
                        var lng = position.coords.longitude;
                        
                        // Center map on user's location
                        map.setView([lat, lng], 13);
                        
                        // Remove existing marker
                        if (marker) {
                            map.removeLayer(marker);
                        }
                        
                        // Add marker at user's location
                        marker = L.marker([lat, lng]).addTo(map);
                        
                        // Update form fields with current location
                        document.getElementById('latitude').value = lat.toFixed(6);
                        document.getElementById('longitude').value = lng.toFixed(6);
                        
                        // Reset button
                        getCurrentLocationBtn.innerHTML = '<i class="fa fa-location-arrow"></i> Current Location';
                        getCurrentLocationBtn.disabled = false;
                    },
                    function(error) {
                        console.log('Geolocation error:', error);
                        alert('Unable to get your current location. Please select manually on the map.');
                        
                        // Reset button
                        getCurrentLocationBtn.innerHTML = '<i class="fa fa-location-arrow"></i> Current Location';
                        getCurrentLocationBtn.disabled = false;
                    }
                );
            } else {
                alert('Geolocation is not supported by this browser.');
            }
        });
    }
});
</script>

<!-- Advanced Amenities Selection JavaScript -->
<script type="text/javascript">
document.addEventListener('DOMContentLoaded', function() {
    'use strict';
    
    // Predefined amenities with categories and icons
    const amenitiesData = {
        basic: [
            { name: 'Air Conditioning', icon: 'fa-snowflake-o', value: 'Air Conditioning' },
            { name: 'Heating', icon: 'fa-thermometer-half', value: 'Heating' },
            { name: 'Parking', icon: 'fa-car', value: 'Parking' },
            { name: 'Elevator', icon: 'fa-arrows-v', value: 'Elevator' },
            { name: 'Balcony', icon: 'fa-home', value: 'Balcony' },
            { name: 'Garden', icon: 'fa-leaf', value: 'Garden' },
            { name: 'Terrace', icon: 'fa-home', value: 'Terrace' },
            { name: 'Storage', icon: 'fa-archive', value: 'Storage' }
        ],
        security: [
            { name: 'Security Guard', icon: 'fa-shield', value: 'Security Guard' },
            { name: 'CCTV', icon: 'fa-video-camera', value: 'CCTV' },
            { name: 'Alarm System', icon: 'fa-bell', value: 'Alarm System' },
            { name: 'Intercom', icon: 'fa-phone', value: 'Intercom' },
            { name: 'Gated Community', icon: 'fa-lock', value: 'Gated Community' },
            { name: 'Fire Safety', icon: 'fa-fire-extinguisher', value: 'Fire Safety' }
        ],
        entertainment: [
            { name: 'Swimming Pool', icon: 'fa-tint', value: 'Swimming Pool' },
            { name: 'Gym', icon: 'fa-dumbbell', value: 'Gym' },
            { name: 'Clubhouse', icon: 'fa-building', value: 'Clubhouse' },
            { name: 'Playground', icon: 'fa-child', value: 'Playground' },
            { name: 'Tennis Court', icon: 'fa-table-tennis', value: 'Tennis Court' },
            { name: 'Basketball Court', icon: 'fa-basketball-ball', value: 'Basketball Court' },
            { name: 'Cinema Hall', icon: 'fa-film', value: 'Cinema Hall' },
            { name: 'Library', icon: 'fa-book', value: 'Library' }
        ],
        outdoor: [
            { name: 'BBQ Area', icon: 'fa-fire', value: 'BBQ Area' },
            { name: 'Jogging Track', icon: 'fa-running', value: 'Jogging Track' },
            { name: 'Landscaping', icon: 'fa-tree', value: 'Landscaping' },
            { name: 'Fountain', icon: 'fa-tint', value: 'Fountain' },
            { name: 'Walking Trail', icon: 'fa-walking', value: 'Walking Trail' },
            { name: 'Outdoor Seating', icon: 'fa-chair', value: 'Outdoor Seating' }
        ],
        utilities: [
            { name: 'WiFi', icon: 'fa-wifi', value: 'WiFi' },
            { name: 'Cable TV', icon: 'fa-tv', value: 'Cable TV' },
            { name: 'Internet', icon: 'fa-globe', value: 'Internet' },
            { name: 'Laundry', icon: 'fa-tshirt', value: 'Laundry' },
            { name: 'Power Backup', icon: 'fa-battery-full', value: 'Power Backup' },
            { name: 'Water Heater', icon: 'fa-shower', value: 'Water Heater' },
            { name: 'Dishwasher', icon: 'fa-utensils', value: 'Dishwasher' },
            { name: 'Microwave', icon: 'fa-microchip', value: 'Microwave' }
        ]
    };
    
    let selectedAmenities = [];
    let currentFilter = 'all';
    let searchTerm = '';
    
    // Initialize amenities
    function initializeAmenities() {
        const existingAmenities = document.getElementById('amenities_input').value;
        if (existingAmenities) {
            selectedAmenities = existingAmenities.split(',').map(a => a.trim()).filter(a => a);
        }
        renderAmenities();
        updateSelectedDisplay();
    }
    
    // Render amenities grid
    function renderAmenities() {
        const container = document.getElementById('amenities_container');
        container.innerHTML = '';
        
        let amenitiesToShow = [];
        
        // Get amenities based on filter
        if (currentFilter === 'all') {
            Object.values(amenitiesData).forEach(category => {
                amenitiesToShow = amenitiesToShow.concat(category);
            });
        } else {
            amenitiesToShow = amenitiesData[currentFilter] || [];
        }
        
        // Filter by search term
        if (searchTerm) {
            amenitiesToShow = amenitiesToShow.filter(amenity => 
                amenity.name.toLowerCase().includes(searchTerm.toLowerCase())
            );
        }
        
        // Render amenities
        amenitiesToShow.forEach(amenity => {
            const isSelected = selectedAmenities.includes(amenity.value);
            const amenityElement = createAmenityElement(amenity, isSelected);
            container.appendChild(amenityElement);
        });
    }
    
    // Create amenity element
    function createAmenityElement(amenity, isSelected) {
        const col = document.createElement('div');
        col.className = 'col-md-4 col-sm-6 mb-2';
        
        const amenityClass = isSelected ? 'amenity-item selected' : 'amenity-item';
        
        col.innerHTML = `
            <div class="${amenityClass}" data-value="${amenity.value}" style="
                padding: 10px;
                border: 1px solid ${isSelected ? '#ef4444' : '#4a5568'};
                border-radius: 5px;
                cursor: pointer;
                transition: all 0.3s;
                background-color: ${isSelected ? '#dc2626' : '#2d3748'};
                color: ${isSelected ? '#ffffff' : '#e2e8f0'};
            " onmouseover="this.style.backgroundColor='${isSelected ? '#dc2626' : '#4a5568'}'" onmouseout="this.style.backgroundColor='${isSelected ? '#dc2626' : '#2d3748'}'">
                <div class="d-flex align-items-center">
                    <i class="fa ${amenity.icon} mr-2" style="color: ${isSelected ? '#ffffff' : '#a0aec0'};"></i>
                    <span style="font-size: 14px; color: ${isSelected ? '#ffffff' : '#e2e8f0'};">
                        ${amenity.name}
                    </span>
                    ${isSelected ? '<i class="fa fa-check ml-auto" style="color: #10b981;"></i>' : ''}
                </div>
            </div>
        `;
        
        // Add click event
        col.querySelector('.amenity-item').addEventListener('click', function() {
            toggleAmenity(amenity.value);
        });
        
        return col;
    }
    
    // Toggle amenity selection
    function toggleAmenity(value) {
        const index = selectedAmenities.indexOf(value);
        if (index > -1) {
            selectedAmenities.splice(index, 1);
        } else {
            selectedAmenities.push(value);
        }
        
        // Update hidden input
        document.getElementById('amenities_input').value = selectedAmenities.join(',');
        
        // Re-render amenities and selected display
        renderAmenities();
        updateSelectedDisplay();
    }
    
    // Update selected amenities display
    function updateSelectedDisplay() {
        const display = document.getElementById('selected_amenities_display');
        
        if (selectedAmenities.length === 0) {
            display.innerHTML = '<span class="text-muted" style="color: #a0aec0;">No amenities selected</span>';
            return;
        }
        
        display.innerHTML = selectedAmenities.map(amenity => `
            <span class="badge badge-primary mr-2 mb-2" style="font-size: 12px; padding: 5px 10px; background-color: #dc2626; color: #ffffff; border: 1px solid #ef4444;">
                ${amenity}
                <i class="fa fa-times ml-1" style="cursor: pointer; color: #ffffff;" onclick="removeAmenity('${amenity}')"></i>
            </span>
        `).join('');
    }
    
    // Remove amenity from selected
    window.removeAmenity = function(value) {
        const index = selectedAmenities.indexOf(value);
        if (index > -1) {
            selectedAmenities.splice(index, 1);
            document.getElementById('amenities_input').value = selectedAmenities.join(',');
            renderAmenities();
            updateSelectedDisplay();
        }
    };
    
    // Filter buttons
    document.querySelectorAll('.filter-btn').forEach(btn => {
        btn.addEventListener('click', function() {
            // Remove active class from all buttons
            document.querySelectorAll('.filter-btn').forEach(b => b.classList.remove('active'));
            // Add active class to clicked button
            this.classList.add('active');
            
            currentFilter = this.dataset.category;
            renderAmenities();
        });
    });
    
    // Search functionality
    document.getElementById('amenities_search').addEventListener('input', function() {
        searchTerm = this.value;
        renderAmenities();
    });
    
    // Custom amenity addition
    document.getElementById('add_custom_amenity').addEventListener('click', function(e) {
        e.preventDefault(); // Prevent form submission
        e.stopPropagation(); // Stop event bubbling
        
        const customInput = document.getElementById('custom_amenity');
        const value = customInput.value.trim();
        
        if (value && !selectedAmenities.includes(value)) {
            selectedAmenities.push(value);
            document.getElementById('amenities_input').value = selectedAmenities.join(',');
            customInput.value = '';
            updateSelectedDisplay();
        }
    });
    
    // Allow Enter key for custom amenity
    document.getElementById('custom_amenity').addEventListener('keypress', function(e) {
        if (e.key === 'Enter') {
            e.preventDefault(); // Prevent form submission
            e.stopPropagation(); // Stop event bubbling
            document.getElementById('add_custom_amenity').click();
        }
    });
    
    // Initialize on page load
    initializeAmenities();
});
</script>

<style>
/* Dark Theme with Red Buttons for Amenities */
.amenity-item {
    background-color: #2d3748 !important;
    border-color: #4a5568 !important;
    color: #e2e8f0 !important;
    transition: all 0.3s ease;
}

.amenity-item:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 12px rgba(0,0,0,0.3);
    background-color: #4a5568 !important;
    border-color: #dc2626 !important;
}

.amenity-item.selected {
    background-color: #dc2626 !important;
    border-color: #ef4444 !important;
    color: #ffffff !important;
}

.amenity-item.selected:hover {
    background-color: #dc2626 !important;
    border-color: #f87171 !important;
}

.amenity-item i {
    color: #a0aec0 !important;
}

.amenity-item.selected i {
    color: #ffffff !important;
}

.amenity-item.selected .fa-check {
    color: #10b981 !important;
}

.selected-amenities-container {
    min-height: 50px;
    display: flex;
    flex-wrap: wrap;
    align-items: center;
    background-color: #2d3748 !important;
    border-color: #4a5568 !important;
    color: #e2e8f0 !important;
}

.amenities-grid {
    background-color: #2d3748 !important;
    border-color: #4a5568 !important;
}

.amenities-search input {
    background-color: #2d3748 !important;
    border-color: #4a5568 !important;
    color: #e2e8f0 !important;
}

.amenities-search input:focus {
    background-color: #2d3748 !important;
    border-color: #dc2626 !important;
    color: #e2e8f0 !important;
    box-shadow: 0 0 0 0.2rem rgba(220, 38, 38, 0.25);
}

.amenities-search input::placeholder {
    color: #a0aec0 !important;
}

.amenities-filter .btn {
    margin-right: 5px;
    margin-bottom: 5px;
    background-color: #4a5568 !important;
    border-color: #4a5568 !important;
    color: #e2e8f0 !important;
}

.amenities-filter .btn:hover {
    background-color: #2d3748 !important;
    border-color: #dc2626 !important;
    color: #ffffff !important;
}

.amenities-filter .btn.active {
    background-color: #dc2626 !important;
    color: #ffffff !important;
    border-color: #ef4444 !important;
}

.custom-amenity input {
    background-color: #2d3748 !important;
    border-color: #4a5568 !important;
    color: #e2e8f0 !important;
}

.custom-amenity input:focus {
    background-color: #2d3748 !important;
    border-color: #dc2626 !important;
    color: #e2e8f0 !important;
    box-shadow: 0 0 0 0.2rem rgba(220, 38, 38, 0.25);
}

.custom-amenity input::placeholder {
    color: #a0aec0 !important;
}

.custom-amenity .btn-success {
    background-color: #dc2626 !important;
    border-color: #dc2626 !important;
    color: #ffffff !important;
}

.custom-amenity .btn-success:hover {
    background-color: #b91c1c !important;
    border-color: #b91c1c !important;
}

.badge-primary {
    background-color: #dc2626 !important;
    color: #ffffff !important;
    border: 1px solid #ef4444 !important;
}

.badge-primary .fa-times {
    color: #ffffff !important;
}

.text-muted {
    color: #a0aec0 !important;
}

/* Dark theme for form labels */
.form-label {
    color: #e2e8f0 !important;
}

/* Dark theme for the amenities section background */
.amenities-section {
    background-color: #1a202c !important;
    padding: 20px;
    border-radius: 8px;
    margin-bottom: 20px;
}

/* Scrollbar styling for dark theme */
.amenities-grid::-webkit-scrollbar {
    width: 8px;
}

.amenities-grid::-webkit-scrollbar-track {
    background: #2d3748;
    border-radius: 4px;
}

.amenities-grid::-webkit-scrollbar-thumb {
    background: #4a5568;
    border-radius: 4px;
}

.amenities-grid::-webkit-scrollbar-thumb:hover {
    background: #dc2626;
}

/* Red theme enhancements for buttons and selected items */
.amenity-item:hover {
    box-shadow: 0 4px 12px rgba(220, 38, 38, 0.4);
}

.amenity-item.selected {
    box-shadow: 0 2px 8px rgba(220, 38, 38, 0.3);
}

/* Red glow effect for selected items */
.amenity-item.selected::before {
    content: '';
    position: absolute;
    top: -2px;
    left: -2px;
    right: -2px;
    bottom: -2px;
    background: linear-gradient(45deg, #dc2626, #ef4444, #f87171, #ef4444, #dc2626);
    border-radius: 7px;
    z-index: -1;
    opacity: 0.3;
}
</style>

<?php $__env->stopSection(); ?>


<?php echo $__env->make("admin.admin_app", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/dextragr/public_html/floorlocator/resources/views/admin/pages/property/addedit.blade.php ENDPATH**/ ?>