

<?php $__env->startSection('head_title', trans('words.pricing') . ' - ' . getcong('site_name')); ?>

<?php $__env->startSection('head_url', Request::url()); ?>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
<style>
    .header-content {
        text-align: center;
        margin-bottom: 2rem;
    }

    .header-content h1 {
        font-size: 2rem;
        color: #2c3e50;
        margin-bottom: 1rem;
    }

    .benefits {
        display: flex;
        justify-content: center;
        gap: 2rem;
        flex-wrap: wrap;
    }

    .benefits span {
        display: flex;
        align-items: center;
        gap: 0.5rem;
        font-size: 1rem;
        color: #2c3e50;
    }

    .benefits i {
        color: #D8232A;
    }

    .form-wrapper {
        max-width: 50%;
        margin: 0 auto;
        padding: 2rem;
        background: white;
        border-radius: 8px;
        box-shadow: 0 2px 10px rgba(0, 0, 0, 0.1);
    }

    .form-container {
        width: 100%;
    }

    .trusted-banner {
        text-align: center;
        background: #f8f9fa;
        padding: 1rem;
        margin-top: 2rem;
    }

    .trusted-banner p {
        margin: 0;
        color: #2c3e50;
        font-size: 0.9rem;
        display: flex;
        align-items: center;
        justify-content: center;
        gap: 0.5rem;
    }

    .trusted-banner i {
        color: #D8232A;
    }

    .input-group {
        display: flex;
        gap: 0.75rem;
        margin-bottom: 0.75rem;
    }

    .input-wrapper {
        flex: 1;
        position: relative;
    }

    .input-group input,
    select {
        flex: 1;
        width: 100%;
        padding: 0.5rem 0.75rem;
        border: 1px solid #ccc;
        border-radius: 4px;
        font-size: 0.9rem;
    }

    .error-message {
        color: #D8232A;
        font-size: 0.8rem;
        margin-top: 0.25rem;
        min-height: 1rem;
    }

    .form-errors {
        color: #D8232A;
        background-color: #fff5f5;
        padding: 0.75rem;
        border-radius: 4px;
        margin-bottom: 1rem;
        display: none;
        border: 1px solid #D8232A;
    }

    .form-errors div {
        margin-bottom: 0.25rem;
    }

    .form-errors div:last-child {
        margin-bottom: 0;
    }

    input:invalid:not(:placeholder-shown),
    select:invalid:not(:placeholder-shown) {
        border-color: #D8232A;
    }

    input:valid:not(:placeholder-shown),
    select:valid:not(:placeholder-shown) {
        border-color: #4CAF50;
    }

    .phone-input {
        display: flex;
        flex: 1;
        min-width: 0;
        /* Add this to prevent flex item from overflowing */
    }

    .phone-input select {
        width: 70px;
        border-right: none;
        border-top-right-radius: 0;
        border-bottom-right-radius: 0;
        flex-shrink: 0;
        /* Prevent select from shrinking */
    }

    .phone-input input {
        width: 100%;
        /* Use width instead of flex */
        min-width: 0;
        /* Allow input to shrink below its content size */
        border-top-left-radius: 0;
        border-bottom-left-radius: 0;
    }

    /* Ensure consistent widths in the input group */
    .input-wrapper {
        min-width: 0;
        /* Allow wrapper to shrink */
        flex: 1;
        display: flex;
        flex-direction: column;
    }

    .city-select {
        flex: 1;
    }

    .toggle {
        display: flex;
        align-items: center;
        gap: 0.5rem;
        margin: 1rem 0;
    }

    .whatsapp {
        color: green;
        font-weight: bold;
    }

    /* Toggle Switch */
    .switch {
        position: relative;
        display: inline-block;
        width: 40px;
        height: 22px;
    }

    .switch input {
        opacity: 0;
        width: 0;
        height: 0;
    }

    .slider {
        position: absolute;
        cursor: pointer;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background-color: #ccc;
        transition: .4s;
        border-radius: 34px;
    }

    .slider:before {
        position: absolute;
        content: "";
        height: 16px;
        width: 16px;
        left: 3px;
        bottom: 3px;
        background-color: #D8232A;
        ;
        transition: .4s;
        border-radius: 50%;
    }

    input:checked+.slider {
        background-color: #25D366;
    }

    input:checked+.slider:before {
        transform: translateX(18px);
    }

    .tabs {
        display: flex;
        gap: 1rem;
        margin: 1rem 0;
    }

    .tabs button {
        flex: 1;
        padding: 0.75rem;
        border: 1px solid #ccc;
        background-color: white;
        cursor: pointer;
        border-radius: 4px;
        position: relative;
    }

    .tabs button.active {
        border-bottom: 2px solid teal;
    }

    .tabs .new {
        background-color: red;
        color: white;
        font-size: 10px;
        padding: 2px 4px;
        border-radius: 4px;
        margin-left: 4px;
    }

    .property-type,
    .tabs {
        display: flex;
        gap: 0.75rem;
        margin: 0.75rem 0;
        flex-wrap: wrap;
    }

    .property-option {
        flex: 1;
        min-width: 80px;
        position: relative;
        cursor: pointer;
        margin: 0;
    }

    .property-option input[type="radio"] {
        position: absolute;
        opacity: 0;
        cursor: pointer;
    }

    .button-label {
        display: flex;
        flex-direction: column;
        align-items: center;
        gap: 0.35rem;
        padding: 0.5rem;
        text-align: center;
        border: 1px solid #ccc;
        background-color: white;
        border-radius: 4px;
        transition: all 0.3s ease;
        font-size: 0.85rem;
    }

    .button-label i {
        font-size: 1.1rem;
        color: #2c3e50;
        transition: all 0.3s ease;
    }

    .property-option input[type="radio"]:checked+.button-label i {
        color: rgb(216, 35, 42);
        ;
    }

    .property-option input[type="radio"]:checked+.button-label {
        background-color: rgb(247, 247, 247);
        color: rgb(216, 35, 42);
        border-color: 1px solid rgb(238, 238, 238);
        transform: scale(1.02);
        font-weight: bold;
        /* box-shadow: 0 2px 4px rgba(0,0,0,0.1); */
    }

    .button-label:hover {
        border-color: #2c3e50;
    }

    .property-option input[type="radio"]:focus+.button-label {
        outline: 2px solid #2c3e50;
        outline-offset: 2px;
    }

    .submit-btn {
        width: 100%;
        padding: 0.75rem;
        background-color: #D8232A;
        color: white;
        font-size: 0.95rem;
        border: none;
        border-radius: 4px;
        cursor: pointer;
        margin-top: 0.75rem;
        transition: background-color 0.3s ease;
    }

    .submit-btn:hover {
        background-color: #ff4146;
    }

    /* Basic styles (same as before) */

    /* Tablet responsiveness */
    @media (max-width: 1024px) {
        .form-wrapper {
            max-width: 90%;
            padding: 1.5rem;
        }

        .benefits {
            gap: 1rem;
        }

        .property-type, .tabs {
            gap: 0.5rem;
        }

        .property-option {
            min-width: 110px;
        }
    }

    /* Mobile responsiveness */
    @media (max-width: 768px) {
        .header-content h1 {
            font-size: 1.5rem;
            margin-bottom: 0.75rem;
        }

        .benefits {
            flex-direction: column;
            gap: 0.5rem;
            align-items: center;
        }

        .form-wrapper {
            max-width: 100%;
            margin: 0;
            padding: 1rem;
            border-radius: 0;
            box-shadow: none;
        }

        .section-title p {
            font-size: 0.9rem;
            margin-bottom: 0.75rem;
            font-weight: 500;
        }

        .input-group {
            flex-direction: column;
            gap: 0.5rem;
        }

        .input-wrapper {
            width: 100%;
        }

        /* Property type specific mobile styles */
        .property-type, .tabs {
            display: flex;
            flex-wrap: wrap;
            gap: 8px;
            width: 100%;
        }

        .property-option {
            flex: 1 1 calc(50% - 4px);
            min-width: 0;
            max-width: calc(50% - 4px);
            margin: 0;
        }

        /* First row items - for two items in first row */
        .property-type#propertyPurpose .property-option {
            flex: 1 1 calc(50% - 4px);
            max-width: calc(50% - 4px);
        }

        /* Purpose and Category buttons */
        #propertyPurpose .button-label,
        #propertyCategory .button-label {
            padding: 12px 8px;
            height: auto;
            min-height: 48px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: 500;
        }

        /* Property type buttons with icons */
        #propertyType .button-label {
            padding: 10px 8px;
            min-height: 72px;
            justify-content: center;
        }

        .button-label i {
            font-size: 1.2rem;
            margin-bottom: 4px;
        }

        .button-label span {
            font-size: 0.85rem;
            line-height: 1.2;
            text-align: center;
            width: 100%;
        }

        .error-message {
            font-size: 0.75rem;
        }

        .submit-btn {
            padding: 0.875rem;
            font-size: 0.9rem;
            margin-top: 1rem;
        }

        /* Improve form errors display on mobile */
        .form-errors {
            margin: 0.5rem 0;
            padding: 0.5rem;
            font-size: 0.8rem;
        }

        /* Improve spacing between sections */
        .section-title {
            margin-top: 1rem;
        }

        /* Make inputs larger for better touch targets */
        input, select {
            height: 42px;
        }
    }

    /* Small mobile devices */
    @media (max-width: 480px) {
        .header-content h1 {
            font-size: 1.25rem;
        }

        .benefits span {
            font-size: 0.9rem;
        }

        .form-wrapper {
            padding: 0.75rem;
        }

        /* Adjust property type layouts for very small screens */
        .property-type, .tabs {
            gap: 6px;
        }

        /* Keep two columns but make them full width for very small screens */
        .property-option {
            flex: 1 1 calc(50% - 3px);
            max-width: calc(50% - 3px);
        }

        /* Compact buttons for small screens */
        #propertyPurpose .button-label,
        #propertyCategory .button-label {
            padding: 10px 6px;
            min-height: 44px;
            font-size: 0.8rem;
        }

        #propertyType .button-label {
            padding: 8px 6px;
            min-height: 64px;
        }

        .button-label i {
            font-size: 1.1rem;
            margin-bottom: 3px;
        }

        .button-label span {
            font-size: 0.8rem;
        }

        /* Better spacing for section titles */
        .section-title p {
            font-size: 0.85rem;
            margin-bottom: 0.5rem;
        }
    }

    /* Extra small devices */
    @media (max-width: 360px) {
        .property-type, .tabs {
            gap: 4px;
        }

        .property-option {
            flex: 1 1 calc(50% - 2px);
            max-width: calc(50% - 2px);
        }

        #propertyType .button-label {
            min-height: 60px;
        }

        .button-label span {
            font-size: 0.75rem;
        }
    }
</style>
<?php $__env->startSection('content'); ?>

    <!--Breadcrumb section starts-->
    <div class="breadcrumb-section"
        style="background-color: #2c3e50">
        
    </div>
    <!--Breadcrumb section ends-->

    <!--Subscription Plan starts-->
    <div class="about-section pt-30 pb-10">
        <div class="container">
            <div class="header-content">
                <h1>Post Your Property</h1>
                <div class="benefits">
                    <span><i class="fas fa-check-circle"></i> Zero Brokerage</span>
                    <span><i class="fas fa-bolt"></i> Quick Listings</span>
                    <span><i class="fas fa-users"></i> 10L+ Active Users</span>
                </div>
            </div>
            <div class="form-wrapper">
                <div class="form-container">
                    <form id="propertyForm" action="<?php echo e(url('post-property/save')); ?>" method="POST" novalidate>
                        <?php echo csrf_field(); ?>
                        <div id="formErrors" class="form-errors"></div>
                        <?php if($errors->any()): ?>
                            <div class="alert alert-danger">
                                <ul>
                                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li><?php echo e($error); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </div>
                        <?php endif; ?>
                        
                        <div class="section-title">
                            <p>I Want to</p>
                        </div>
                        <div class="property-type" id="propertyPurpose">
                            <label class="property-option">
                                <input type="radio" name="property_purpose" value="sale" checked>
                                <span class="button-label active">Sale</span>
                            </label>
                            <label class="property-option">
                                <input type="radio" name="property_purpose" value="rent">
                                <span class="button-label">Rent</span>
                            </label>
                            
                        </div>

                        
                        <div class="section-title">
                            <p>Property Category</p>
                        </div>
                        <div class="tabs" id="propertyCategory">
                            <label class="property-option">
                                <input type="radio" name="property_category" value="residential" checked>
                                <span class="button-label active">Residential</span>
                            </label>
                            <label class="property-option">
                                <input type="radio" name="property_category" value="commercial">
                                <span class="button-label">Commercial</span>
                            </label>
                            <label class="property-option">
                                <input type="radio" name="property_category" value="land">
                                <span class="button-label">Land/Plot</span>
                                
                            </label>
                        </div>

                        
                        <div class="section-title property-type-section" style="display: none;">
                            <p>Property Type</p>
                        </div>
                        <div class="property-type" id="propertyType" style="display: none;">
                            <label class="property-option">
                                <input type="radio" name="property_type" value="apartment" checked>
                                <span class="button-label active">
                                    <i class="fas fa-building"></i>
                                    <span>Apartment</span>
                                </span>
                            </label>
                            <label class="property-option">
                                <input type="radio" name="property_type" value="independent">
                                <span class="button-label">
                                    <i class="fas fa-home"></i>
                                    <span>Independent House</span>
                                </span>
                            </label>
                            <label class="property-option">
                                <input type="radio" name="property_type" value="villa">
                                <span class="button-label">
                                    <i class="fas fa-hotel"></i>
                                    <span>Villa</span>
                                </span>
                            </label>
                            <label class="property-option">
                                <input type="radio" name="property_type" value="studio">
                                <span class="button-label">
                                    <i class="fas fa-door-open"></i>
                                    <span>Studio Apartment</span>
                                </span>
                            </label>
                            <label class="property-option">
                                <input type="radio" name="property_type" value="farmhouse">
                                <span class="button-label">
                                    <i class="fas fa-warehouse"></i>
                                    <span>Farm House</span>
                                </span>
                            </label>
                        </div>

                        <div class="input-group">
                            <div class="input-wrapper">
                                <input type="text" id="name" name="name" placeholder="Name" required
                                    minlength="3" pattern="^[a-zA-Z ]{3,50}$"
                                    title="Please enter a valid name (3-50 characters, letters only)" />
                                <div class="error-message"></div>
                            </div>
                            <div class="input-wrapper">
                                <input type="email" id="email" name="email" placeholder="Email" required
                                    pattern="[a-z0-9._%+-]+@[a-z0-9.-]+\.[a-z]{2,}$" />
                                <div class="error-message"></div>
                            </div>
                        </div>

                        <div class="input-group">
                            <div class="phone-input input-wrapper">
                                <input type="tel" id="mobile" name="mobile" placeholder="Mobile Number" required
                                    pattern="^[6-9]\d{9}$" title="Please enter a valid 10-digit mobile number" />
                                <div class="error-message"></div>
                            </div>
                            <div class="input-wrapper">
                                <select id="city" name="city" class="city-select" required>
                                    <option value="">Select City</option>
                                    <option value="chennai">Chennai</option>
                                    <option value="coimbatore">Coimbatore</option>
                                    <option value="trichy">Trichy</option>
                                    <option value="madurai">Madurai</option>
                                    <option value="salem">Salem</option>
                                    <option value="erode">Erode</option>
                                    <option value="tirunelveli">Tirunelveli</option>
                                    <option value="vellore">Vellore</option>
                                    <option value="thanjavur">Thanjavur</option>
                                    <option value="dindigul">Dindigul</option>
                                    <option value="nagercoil">Nagercoil</option>
                                    <option value="karur">Karur</option>
                                    <option value="cuddalore">Cuddalore</option>
                                    <option value="theni">Theni</option>
                                    <option value="tiruppur">Tiruppur</option>
                                    <option value="kanyakumari">Kanyakumari</option>
                                    <option value="other">Other</option>
                                </select>
                                <div class="error-message"></div>
                            </div>
                        </div>

                        

                        
                        <button type="submit" class="submit-btn">Start Posting Your Ad For FREE</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
    <!--Subscription Plan ends-->

    <div class="trusted-banner">
        <p><i class="fas fa-shield-alt"></i> Trusted by 30 Lac+ Property Owners</p>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script type="text/javascript">
        // Error message handling
        <?php if(Session::has('error_flash_message')): ?>
            const Toast = Swal.mixin({
                toast: true,
                position: 'top-end',
                showConfirmButton: false,
                timer: 3000,
                timerProgressBar: false,
            })

            Toast.fire({
                icon: 'error',
                title: '<?php echo e(Session::get('error_flash_message')); ?>'
            })
        <?php endif; ?>

        // Form validation and submit handling
        document.addEventListener('DOMContentLoaded', function() {
            const propertyTypes = {
                commercial: {
                    sale: [{
                            name: 'Office',
                            icon: 'briefcase'
                        },
                        {
                            name: 'Shop',
                            icon: 'store'
                        },
                        {
                            name: 'Showroom',
                            icon: 'store-alt'
                        },
                        {
                            name: 'Warehouse',
                            icon: 'warehouse'
                        },
                        {
                            name: 'Industrial',
                            icon: 'industry'
                        }
                    ],
                    rent: [{
                            name: 'Office',
                            icon: 'briefcase'
                        },
                        {
                            name: 'Shop',
                            icon: 'store'
                        },
                        {
                            name: 'Showroom',
                            icon: 'store-alt'
                        },
                        {
                            name: 'Warehouse',
                            icon: 'warehouse'
                        },
                        {
                            name: 'Industrial',
                            icon: 'industry'
                        }
                    ]
                }
            };

            function updatePropertyTypes() {
                const purpose = document.querySelector('input[name="property_purpose"]:checked').value;
                const category = document.querySelector('input[name="property_category"]:checked').value;
                const propertyTypeContainer = document.getElementById('propertyType');
                const propertyTypeSection = document.querySelector('.property-type-section');

                // Show/hide property type section based on category
                if (category === 'commercial') {
                    propertyTypeSection.style.display = 'block';
                    propertyTypeContainer.style.display = 'flex';

                    // Get available types based on selection
                    const types = propertyTypes[category]?.[purpose] || [];

                    // Generate new radio buttons
                    const html = types.map((type, index) => `
                        <label class="property-option">
                            <input type="radio" name="property_type" value="${type.name.toLowerCase().replace(/\s+/g, '_')}"
                                ${index === 0 ? 'checked' : ''}>
                            <span class="button-label ${index === 0 ? 'active' : ''}">
                                <i class="fas fa-${type.icon}"></i>
                                <span>${type.name}</span>
                            </span>
                        </label>
                    `).join('');

                    propertyTypeContainer.innerHTML = html;
                } else {
                    propertyTypeSection.style.display = 'none';
                    propertyTypeContainer.style.display = 'none';
                }
            }

            // Add event listeners
            document.getElementById('propertyPurpose').addEventListener('change', updatePropertyTypes);
            document.getElementById('propertyCategory').addEventListener('change', updatePropertyTypes);

            // Initialize property types
            updatePropertyTypes();

            // Form validation
            const form = document.getElementById('propertyForm');
            const formErrors = document.getElementById('formErrors');
            const inputs = form.querySelectorAll('input, select');

            // Real-time validation
            inputs.forEach(input => {
                // Mark input as touched when user interacts with it
                input.addEventListener('input', function() {
                    this.dataset.touched = 'true';
                    validateInput(this);
                });

                input.addEventListener('blur', function() {
                    this.dataset.touched = 'true';
                    validateInput(this);
                });
            });

            function validateInput(input, showError = false) {
                const errorElement = input.closest('.input-wrapper').querySelector('.error-message');

                // Only show errors if showError is true or if the input has been touched
                if (input.validity.valid) {
                    errorElement.textContent = '';
                    return true;
                }

                if (showError || input.dataset.touched === 'true') {
                    if (input.validity.valueMissing) {
                        errorElement.textContent = `${input.placeholder || input.name} is required`;
                    } else if (input.validity.typeMismatch && input.type === 'email') {
                        errorElement.textContent = 'Please enter a valid email address';
                    } else if (input.validity.patternMismatch) {
                        errorElement.textContent = input.title || 'Please enter a valid value';
                    }
                }
                return false;
            }

            // Form submission
            form.addEventListener('submit', async function(e) {
                e.preventDefault();

                // Clear previous errors
                formErrors.style.display = 'none';
                formErrors.textContent = '';

                // Reset error messages
                document.querySelectorAll('.error-message').forEach(error => {
                    error.textContent = '';
                });

                // Validate all required fields
                let isValid = true;
                const errorMessages = [];

                // Check name
                const nameInput = form.querySelector('#name');
                if (!nameInput.value.trim()) {
                    errorMessages.push('Name is required');
                    nameInput.closest('.input-wrapper').querySelector('.error-message').textContent =
                        'Name is required';
                    isValid = false;
                } else if (!nameInput.value.match(/^[a-zA-Z ]{3,50}$/)) {
                    errorMessages.push('Please enter a valid name (3-50 characters, letters only)');
                    nameInput.closest('.input-wrapper').querySelector('.error-message').textContent =
                        'Please enter a valid name (3-50 characters, letters only)';
                    isValid = false;
                }

                // Check email
                const emailInput = form.querySelector('#email');
                if (!emailInput.value.trim()) {
                    errorMessages.push('Email is required');
                    emailInput.closest('.input-wrapper').querySelector('.error-message').textContent =
                        'Email is required';
                    isValid = false;
                } else if (!emailInput.value.match(
                        /^[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,}$/)) {
                    errorMessages.push('Please enter a valid email address');
                    emailInput.closest('.input-wrapper').querySelector('.error-message').textContent =
                        'Please enter a valid email address';
                    isValid = false;
                }

                // Check mobile
                const mobileInput = form.querySelector('#mobile');
                if (!mobileInput.value.trim()) {
                    errorMessages.push('Mobile number is required');
                    mobileInput.closest('.input-wrapper').querySelector('.error-message').textContent =
                        'Mobile number is required';
                    isValid = false;
                } else if (!mobileInput.value.match(/^[6-9]\d{9}$/)) {
                    errorMessages.push('Please enter a valid 10-digit mobile number');
                    mobileInput.closest('.input-wrapper').querySelector('.error-message').textContent =
                        'Please enter a valid 10-digit mobile number';
                    isValid = false;
                }

                // Check city
                const citySelect = form.querySelector('#city');
                if (!citySelect.value) {
                    errorMessages.push('Please select a city');
                    citySelect.closest('.input-wrapper').querySelector('.error-message').textContent =
                        'Please select a city';
                    isValid = false;
                }

                // Show form level errors if any
                if (!isValid) {
                    // formErrors.innerHTML = errorMessages.map(msg => `<div>${msg}</div>`).join('');
                    // formErrors.style.display = 'block';
                    // Scroll to the first error
                    const firstError = document.querySelector('.error-message:not(:empty)');
                    if (firstError) {
                        firstError.scrollIntoView({
                            behavior: 'smooth',
                            block: 'center'
                        });
                    }
                    return;
                } // Collect form data
                const formData = {
                    property_purpose: form.querySelector('input[name="property_purpose"]:checked')
                        .value,
                    property_category: form.querySelector('input[name="property_category"]:checked')
                        .value,
                    property_type: form.querySelector('input[name="property_type"]:checked')?.value,
                    name: form.querySelector('#name').value,
                    email: form.querySelector('#email').value,
                    mobile: form.querySelector('#mobile').value,
                    city: form.querySelector('#city').value
                };

                try {
                    // Show loading state
                    const submitBtn = form.querySelector('.submit-btn');
                    const originalBtnText = submitBtn.textContent;
                    submitBtn.disabled = true;
                    submitBtn.textContent = 'Processing...';

                    const formData = new FormData(form);

                    // Send the form data via AJAX
                    const response = await fetch(form.action, {
                        method: 'POST',
                        body: formData,
                        headers: {
                            'X-CSRF-TOKEN': document.querySelector('input[name="_token"]').value,
                            'Accept': 'application/json'
                        },
                        credentials: 'same-origin'
                    });

                    const result = await response.json();

                    if (response.ok) {
                        Swal.fire({
                            icon: 'success',
                            title: 'Success!',
                            text: result.message || 'Your property listing has been submitted successfully.',
                            confirmButtonColor: '#D8232A'
                        }).then((result) => {
                            if (result.isConfirmed) {
                                form.reset();
                                window.location.href = '<?php echo e(url('/')); ?>';
                                // updatePropertyTypes();
                                // // If there's a redirect URL, go there
                                // if (result.redirect) {
                                //     // redirect to base url + result.redirect
                                //     window.location.href = '<?php echo e(url('/')); ?>';
                                // }
                            }
                        });
                    } else {
                        // Handle validation errors
                        if (response.status === 422 && result.errors) {
                            // Clear previous errors
                            document.querySelectorAll('.error-message').forEach(el => el.textContent = '');

                            // Display new errors under each field
                            Object.keys(result.errors).forEach(field => {
                                const errorElement = document.querySelector(`[name="${field}"]`)
                                    ?.closest('.input-wrapper')
                                    ?.querySelector('.error-message');
                                if (errorElement) {
                                    errorElement.textContent = result.errors[field][0];
                                }
                            });

                            // Show first error in SweetAlert
                            const firstError = Object.values(result.errors)[0][0];
                            throw new Error(firstError);
                        } else {
                            throw new Error(result.message || 'Something went wrong');
                        }
                    }
                } catch (error) {
                    Swal.fire({
                        icon: 'error',
                        title: 'Oops...',
                        text: error.message || 'Something went wrong! Please try again.',
                        confirmButtonColor: '#D8232A'
                    });
                } finally {
                    submitBtn.disabled = false;
                    submitBtn.textContent = originalBtnText;
                }
            });
        });
    </script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('site_app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/dextragr/public_html/realestate.dextragroups.com/resources/views/pages/post_property.blade.php ENDPATH**/ ?>