

<?php $__env->startSection("content"); ?>

<div class="content-page">
    <div class="content">
        <div class="container-fluid">
            
            <!-- Payment Statistics -->
            <div class="row">
                <div class="col-xl-3 col-md-6">
                    <div class="card-box">
                        <div class="float-right mt-2">
                            <i class="fa fa-credit-card text-primary" style="font-size: 24px;"></i>
                        </div>
                        <div>
                            <h4 class="mb-1 mt-1"><span data-plugin="counterup"><?php echo e($stats['total_payments']); ?></span></h4>
                            <p class="text-muted mb-0">Total Payments</p>
                        </div>
                    </div>
                </div>

                <div class="col-xl-3 col-md-6">
                    <div class="card-box">
                        <div class="float-right mt-2">
                            <i class="fa fa-check-circle text-success" style="font-size: 24px;"></i>
                        </div>
                        <div>
                            <h4 class="mb-1 mt-1"><span data-plugin="counterup"><?php echo e($stats['completed_payments']); ?></span></h4>
                            <p class="text-muted mb-0">Completed</p>
                        </div>
                    </div>
                </div>

                <div class="col-xl-3 col-md-6">
                    <div class="card-box">
                        <div class="float-right mt-2">
                            <i class="fa fa-clock-o text-warning" style="font-size: 24px;"></i>
                        </div>
                        <div>
                            <h4 class="mb-1 mt-1"><span data-plugin="counterup"><?php echo e($stats['pending_payments']); ?></span></h4>
                            <p class="text-muted mb-0">Pending</p>
                        </div>
                    </div>
                </div>

                <div class="col-xl-3 col-md-6">
                    <div class="card-box">
                        <div class="float-right mt-2">
                            <i class="fa fa-dollar text-info" style="font-size: 24px;"></i>
                        </div>
                        <div>
                            <h4 class="mb-1 mt-1"><?php echo e(html_entity_decode(getCurrencySymbols(getcong('currency_code')))); ?><?php echo e(number_format($stats['total_revenue'], 2)); ?></h4>
                            <p class="text-muted mb-0">Total Revenue</p>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-12">
                    <div class="card-box table-responsive">
                        
                        <!-- Filters -->
                        <div class="row mb-3">
                            <div class="col-md-2">
                                <select class="form-control" name="status_filter" id="status_filter">
                                    <option value="">All Status</option>
                                    <option value="?status=completed" <?php if(request('status') == 'completed'): ?> selected <?php endif; ?>>Completed</option>
                                    <option value="?status=pending" <?php if(request('status') == 'pending'): ?> selected <?php endif; ?>>Pending</option>
                                    <option value="?status=failed" <?php if(request('status') == 'failed'): ?> selected <?php endif; ?>>Failed</option>
                                    <option value="?status=refunded" <?php if(request('status') == 'refunded'): ?> selected <?php endif; ?>>Refunded</option>
                                </select>
                            </div>
                            
                            <div class="col-md-2">
                                <select class="form-control" name="gateway_filter" id="gateway_filter">
                                    <option value="">All Gateways</option>
                                    <?php $__currentLoopData = $gateways; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gateway): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="?gateway=<?php echo e($gateway->gateway_name); ?>" <?php if(request('gateway') == $gateway->gateway_name): ?> selected <?php endif; ?>>
                                            <?php echo e($gateway->gateway_name); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>

                            <div class="col-md-2">
                                <input type="date" name="date_from" class="form-control" placeholder="From Date" value="<?php echo e(request('date_from')); ?>">
                            </div>

                            <div class="col-md-2">
                                <input type="date" name="date_to" class="form-control" placeholder="To Date" value="<?php echo e(request('date_to')); ?>">
                            </div>

                            <div class="col-md-3">
                                <?php echo e(html()->form('GET', url('/admin/payments'))
                                   ->attributes(['class' => 'app-search', 'id' => 'search'])->open()); ?>

                                    <input type="text" name="s" placeholder="Search by payment ID, email, user name..." class="form-control" value="<?php echo e(request('s')); ?>">
                                    <button type="submit"><i class="fa fa-search"></i></button>
                                <?php echo e(html()->form()->close()); ?>

                            </div>

                            <div class="col-md-1">
                                <button type="button" class="btn btn-success" data-toggle="modal" data-target="#addManualPayment">
                                    <i class="fa fa-plus"></i> Add
                                </button>
                            </div>
                        </div>

                        <?php if(Session::has('flash_message')): ?>
                            <div class="alert alert-success">
                                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                                <?php echo e(Session::get('flash_message')); ?>

                            </div>
                        <?php endif; ?>

                        <div class="table-responsive">
                            <table class="table table-bordered table-hover">
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>User</th>
                                        <th>Plan</th>
                                        <th>Amount</th>
                                        <th>Gateway</th>
                                        <th>Payment ID</th>
                                        <th>Status</th>
                                        <th>Type</th>
                                        <th>Date</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__currentLoopData = $payments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $payment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($payment->id); ?></td>
                                        <td>
                                            <a href="<?php echo e(url('admin/users/history/'.$payment->user_id)); ?>" class="text-primary">
                                                <?php echo e($payment->user ? $payment->user->name : 'N/A'); ?>

                                            </a>
                                            <br><small class="text-muted"><?php echo e($payment->email); ?></small>
                                        </td>
                                        <td><?php echo e($payment->subscriptionPlan ? $payment->subscriptionPlan->plan_name : 'N/A'); ?></td>
                                        <td>
                                            <strong><?php echo e($payment->formatted_amount); ?></strong>
                                            <?php if($payment->currency != getcong('currency_code')): ?>
                                                <br><small class="text-muted"><?php echo e($payment->currency); ?></small>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <span class="badge badge-primary"><?php echo e($payment->gateway); ?></span>
                                        </td>
                                        <td>
                                            <code><?php echo e($payment->payment_id); ?></code>
                                        </td>
                                        <td>
                                            <span class="badge <?php echo e($payment->status_badge); ?>">
                                                <?php echo e(ucfirst($payment->payment_status)); ?>

                                            </span>
                                        </td>
                                        <td><?php echo e(ucfirst($payment->transaction_type)); ?></td>
                                        <td><?php echo e($payment->formatted_date); ?></td>
                                        <td>
                                            <a href="<?php echo e(url('admin/payments/'.$payment->id)); ?>" class="btn btn-sm btn-info" title="View Details">
                                                <i class="fa fa-eye"></i>
                                            </a>
                                            <?php if(Auth::User()->usertype == "Admin"): ?>
                                                <button type="button" class="btn btn-sm btn-warning" data-toggle="modal" data-target="#updateStatus<?php echo e($payment->id); ?>" title="Update Status">
                                                    <i class="fa fa-edit"></i>
                                                </button>
                                            <?php endif; ?>
                                        </td>
                                    </tr>

                                    <!-- Update Status Modal -->
                                    <?php if(Auth::User()->usertype == "Admin"): ?>
                                    <div class="modal fade" id="updateStatus<?php echo e($payment->id); ?>" tabindex="-1" role="dialog">
                                        <div class="modal-dialog" role="document">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h4 class="modal-title">Update Payment Status</h4>
                                                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                                                </div>
                                                <?php echo e(html()->form('POST', url('/admin/payments/'.$payment->id.'/update-status'))
                                                   ->attributes(['class' => 'form-horizontal'])->open()); ?>

                                                <div class="modal-body">
                                                    <div class="form-group">
                                                        <label>Payment Status</label>
                                                        <select name="payment_status" class="form-control" required>
                                                            <option value="pending" <?php if($payment->payment_status == 'pending'): ?> selected <?php endif; ?>>Pending</option>
                                                            <option value="completed" <?php if($payment->payment_status == 'completed'): ?> selected <?php endif; ?>>Completed</option>
                                                            <option value="failed" <?php if($payment->payment_status == 'failed'): ?> selected <?php endif; ?>>Failed</option>
                                                            <option value="refunded" <?php if($payment->payment_status == 'refunded'): ?> selected <?php endif; ?>>Refunded</option>
                                                        </select>
                                                    </div>
                                                    <div class="form-group">
                                                        <label>Admin Notes</label>
                                                        <textarea name="notes" class="form-control" rows="3" placeholder="Add notes about this status change..."><?php echo e($payment->notes); ?></textarea>
                                                    </div>
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="submit" class="btn btn-primary">Update Status</button>
                                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                                                </div>
                                                <?php echo e(html()->form()->close()); ?>

                                            </div>
                                        </div>
                                    </div>
                                    <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>
                            </table>
                        </div>

                        <nav class="paging_simple_numbers">
                            <?php echo $__env->make('admin.pagination', ['paginator' => $payments], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?> 
                        </nav>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php echo $__env->make("admin.copyright", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?> 
</div>

<!-- Add Manual Payment Modal -->
<?php if(Auth::User()->usertype == "Admin"): ?>
<div class="modal fade" id="addManualPayment" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Add Manual Payment</h4>
                <button type="button" class="close" data-dismiss="modal">&times;</button>
            </div>
            <?php echo e(html()->form('POST', url('/admin/payments/manual'))
               ->attributes(['class' => 'form-horizontal'])->open()); ?>

            <div class="modal-body">
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>User *</label>
                            <select name="user_id" class="form-control" required>
                                <option value="">Select User</option>
                                <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($user->id); ?>"><?php echo e($user->name); ?> (<?php echo e($user->email); ?>)</option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Subscription Plan (Optional)</label>
                            <select name="plan_id" class="form-control">
                                <option value="">No Plan / Custom Payment</option>
                                <?php $__currentLoopData = \App\SubscriptionPlan::where('status', '1')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $plan): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($plan->id); ?>" data-price="<?php echo e($plan->plan_price); ?>"><?php echo e($plan->plan_name); ?> - <?php echo e(html_entity_decode(getCurrencySymbols(getcong('currency_code')))); ?><?php echo e($plan->plan_price); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Payment Amount *</label>
                            <input type="number" name="payment_amount" class="form-control" step="0.01" min="0" required>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Payment Gateway *</label>
                            <select name="gateway" class="form-control" required>
                                <option value="">Select Gateway</option>
                                <option value="Bank Transfer">Bank Transfer</option>
                                <option value="Cash">Cash</option>
                                <?php $__currentLoopData = $gateways; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gateway): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($gateway->gateway_name); ?>"><?php echo e($gateway->gateway_name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Payment ID/Reference *</label>
                            <input type="text" name="payment_id" class="form-control" placeholder="Enter payment reference" required>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Transaction Type</label>
                            <select name="transaction_type" class="form-control">
                                <option value="subscription">Subscription</option>
                                <option value="upgrade">Plan Upgrade</option>
                                <option value="renewal">Plan Renewal</option>
                                <option value="refund">Refund</option>
                                <option value="other">Other</option>
                            </select>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Payment Status</label>
                            <select name="payment_status" class="form-control">
                                <option value="completed">Completed</option>
                                <option value="pending">Pending</option>
                                <option value="failed">Failed</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Description</label>
                            <input type="text" name="description" class="form-control" placeholder="Payment description">
                        </div>
                    </div>
                </div>
                
                <div class="form-group">
                    <label>Admin Notes</label>
                    <textarea name="notes" class="form-control" rows="3" placeholder="Add any notes about this payment..."></textarea>
                </div>
            </div>
            <div class="modal-footer">
                <button type="submit" class="btn btn-primary">Add Payment</button>
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
            </div>
            <?php echo e(html()->form()->close()); ?>

        </div>
    </div>
</div>
<?php endif; ?>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Auto-fill payment amount when plan is selected (optional)
    const planSelect = document.querySelector('#addManualPayment select[name="plan_id"]');
    const amountField = document.querySelector('#addManualPayment input[name="payment_amount"]');
    
    if (planSelect && amountField) {
        planSelect.addEventListener('change', function() {
            const selectedOption = this.options[this.selectedIndex];
            const price = selectedOption.getAttribute('data-price');
            
            if (price && !amountField.value) {
                amountField.value = price;
            }
        });
    }

    // Generate unique payment ID
    const paymentIdField = document.querySelector('#addManualPayment input[name="payment_id"]');
    if (paymentIdField) {
        document.querySelector('[data-target="#addManualPayment"]').addEventListener('click', function() {
            const timestamp = Date.now();
            const paymentId = 'MANUAL_' + timestamp;
            setTimeout(function() {
                paymentIdField.value = paymentId;
            }, 100);
        });
    }

    // Filter handlers
    document.getElementById('status_filter').addEventListener('change', function() {
        if (this.value) {
            window.location.href = this.value;
        } else {
            window.location.href = '<?php echo e(url("admin/payments")); ?>';
        }
    });

    document.getElementById('gateway_filter').addEventListener('change', function() {
        if (this.value) {
            window.location.href = this.value;
        } else {
            window.location.href = '<?php echo e(url("admin/payments")); ?>';
        }
    });

    // Date range filter
    const dateFrom = document.querySelector('input[name="date_from"]');
    const dateTo = document.querySelector('input[name="date_to"]');
    
    if (dateFrom && dateTo) {
        [dateFrom, dateTo].forEach(input => {
            input.addEventListener('change', function() {
                if (dateFrom.value && dateTo.value) {
                    const url = new URL(window.location.href);
                    url.searchParams.set('date_from', dateFrom.value);
                    url.searchParams.set('date_to', dateTo.value);
                    window.location.href = url.toString();
                }
            });
        });
    }
});
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make("admin.admin_app", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/dextragr/public_html/floorlocator/resources/views/admin/pages/payments/index.blade.php ENDPATH**/ ?>