<?php $__env->startSection('head_title', 'Request Custom Plan - '.getcong('site_name')); ?>
<?php $__env->startSection('head_url', Request::url()); ?>

<?php $__env->startSection('content'); ?>

<div class="breadcrumb-section bg-xs" style="background-image: url(<?php echo e(URL::asset('site_assets/images/breadcrumb-1.jpg')); ?>)">
  <div class="overlay op-2"></div>
  <div class="container">
    <div class="row">
      <div class="col-md-12 text-center">
        <div class="breadcrumb-menu">
          <h2>Request Custom Plan</h2>
          <span><a href="<?php echo e(URL::to('/')); ?>"><?php echo e(trans('words.home')); ?></a></span> <span>Request Custom Plan</span>
        </div>
      </div>
    </div>
  </div>
</div>

<div class="about-section pt-30 pb-30">
  <div class="container">
    <div class="row justify-content-center">
      <div class="col-lg-8 col-md-10">
        <div class="card-box p-4">
          <?php echo e(html()->form('POST', url('/custom-plan/request'))->attributes(['id' => 'custom_plan_form'])->open()); ?>

            <div class="form-group">
              <label>Property postings needed *</label>
              <input type="number" class="form-control" name="property_posts_needed" value="<?php echo e(old('property_posts_needed')); ?>" min="1" step="1" required>
            </div>
            <div class="form-group">
              <label>Ads postings needed</label>
              <input type="number" class="form-control" name="ads_posts_needed" value="<?php echo e(old('ads_posts_needed')); ?>" min="0" step="1">
            </div>
            <div class="form-group">
              <label>Special notes (requirements)</label>
              <textarea class="form-control" name="notes" rows="4" placeholder="Describe any special requirements"><?php echo e(old('notes')); ?></textarea>
            </div>
            <div class="form-group">
              <label>Payment preference *</label>
              <select class="form-control" name="payment_preference" required>
                <option value="online" <?php if(old('payment_preference')==='online'): ?> selected <?php endif; ?>>Online</option>
                <option value="cash" <?php if(old('payment_preference')==='cash'): ?> selected <?php endif; ?>>Cash</option>
              </select>
            </div>

            <div class="form-group mt-3">
              <button type="submit" class="btn vfx7">Submit Request</button>
              <a href="<?php echo e(url('pricing')); ?>" class="btn btn-secondary">Back to Plans</a>
            </div>
          <?php echo e(html()->form()->close()); ?>

        </div>

        <?php if(count($errors) > 0): ?>
          <div class="alert alert-danger mt-3">
            <ul class="mb-0">
              <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <li><?php echo e($error); ?></li>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </ul>
          </div>
        <?php endif; ?>
      </div>
    </div>
  </div>
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('site_app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/dextragr/public_html/floorlocator/resources/views/pages/payment/custom_plan_request.blade.php ENDPATH**/ ?>