<?php $__env->startSection('content'); ?>
<div class="content-page">
  <div class="content">
    <div class="container-fluid">
      <div class="row">
        <div class="col-lg-12">
          <div class="card-box">
            <h4 class="header-title m-t-0 m-b-30"><?php echo e($page_title); ?></h4>

            <div class="table-responsive">
              <table class="table table-striped" style="color:#e6e6e6;">
                <thead>
                  <tr>
                    <th>ID</th>
                    <th>User</th>
                    <th>Requested</th>
                    <th>Payment Pref</th>
                    <th>Status</th>
                    <th>Approved Price</th>
                    <th>Created</th>
                    <th>Action</th>
                  </tr>
                </thead>
                <tbody>
                <?php $__currentLoopData = $requests; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $req): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <tr>
                    <td><?php echo e($req->id); ?></td>
                    <td><?php echo e(optional($req->user)->name); ?><br><small><?php echo e(optional($req->user)->email); ?></small></td>
                    <td>
                      Props: <?php echo e($req->property_posts_requested); ?><br>
                      Ads: <?php echo e($req->ads_posts_requested ?? '-'); ?>

                    </td>
                    <td><?php echo e(ucfirst($req->payment_preference)); ?></td>
                    <td>
                      <?php
                        $badge = 'badge-secondary';
                        switch($req->status){
                          case 'pending': $badge='badge-warning'; break;
                          case 'approved': $badge='badge-primary'; break;
                          case 'awaiting_payment': $badge='badge-info'; break;
                          case 'activated': $badge='badge-success'; break;
                          case 'rejected': $badge='badge-danger'; break;
                        }
                      ?>
                      <span class="badge <?php echo e($badge); ?>"><?php echo e(strtoupper($req->status)); ?></span>
                    </td>
                    <td><?php echo e($req->approved_price ? number_format($req->approved_price,2) : '-'); ?></td>
                    <td><?php echo e($req->created_at?->format('Y-m-d H:i')); ?></td>
                    <td>
                      <a href="<?php echo e(url('admin/custom-plans/'.$req->id)); ?>" class="btn btn-sm btn-primary">Review</a>
                      <?php if($req->user_id): ?>
                        <a href="<?php echo e(url('admin/users/'.$req->user_id)); ?>" class="btn btn-sm btn-purple">View User</a>
                      <?php endif; ?>
                    </td>
                  </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
              </table>
            </div>

            <?php echo $__env->make('_particles.pagination', ['paginator' => $requests], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

          </div>
        </div>
      </div>
    </div>
  </div>
  <?php echo $__env->make('admin.copyright', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.admin_app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/dextragr/public_html/realestate.dextragroups.com/resources/views/admin/pages/custom_plans/index.blade.php ENDPATH**/ ?>