

<?php $__env->startSection('content'); ?>
<div class="content-page">
  <div class="content">
    <div class="container-fluid">
      <div class="row">
        <div class="col-lg-12">
          <div class="card-box" style="color:#e6e6e6;">
            <div class="d-flex justify-content-between align-items-center mb-3">
              <h4 class="header-title m-t-0 m-b-0"><?php echo e($page_title); ?></h4>
              <a href="<?php echo e(url('admin/users')); ?>" class="btn btn-secondary">Back to Users</a>
            </div>

            <div class="row">
              <div class="col-md-4">
                <div class="card" style="background:#0e1422;border:1px solid #24314d;">
                  <div class="card-body">
                    <h5 class="text-muted mb-2">User</h5>
                    <div class="d-flex align-items-center">
                      <div class="mr-3">
                        <img src="<?php echo e($user->user_image ? asset('upload/'.$user->user_image) : asset('admin_assets/images/users/avatar-1.jpg')); ?>" alt="user" class="rounded-circle" width="64" height="64">
                      </div>
                      <div>
                        <div class="font-weight-bold"><?php echo e($user->name); ?></div>
                        <div class="text-muted small"><?php echo e($user->email); ?></div>
                        <div class="text-muted small"><?php echo e($user->phone); ?></div>
                        <div class="badge badge-<?php echo e($user->status ? 'success':'secondary'); ?> mt-1"><?php echo e($user->status ? 'Active':'Inactive'); ?></div>
                      </div>
                    </div>
                  </div>
                </div>
              </div>

              <div class="col-md-4">
                <div class="card" style="background:#0e1422;border:1px solid #24314d;">
                  <div class="card-body">
                    <h5 class="text-muted mb-2">Current Plan</h5>
                    <?php if($plan): ?>
                      <div class="font-weight-bold mb-1"><?php echo e($plan->plan_name); ?></div>
                      <div class="text-muted small mb-2">Price: <?php echo e(number_format($plan->plan_price,2)); ?></div>
                      <div class="text-muted small mb-2">Validity: <?php echo e(\App\SubscriptionPlan::getPlanDuration($plan->id)); ?></div>
                      <div class="text-muted small">Expiry: <?php echo e($expiry_date ?: '-'); ?></div>
                    <?php else: ?>
                      <div class="text-muted">No active plan</div>
                    <?php endif; ?>
                  </div>
                </div>
              </div>

              <div class="col-md-4">
                <div class="card" style="background:#0e1422;border:1px solid #24314d;">
                  <div class="card-body">
                    <h5 class="text-muted mb-2">Usage</h5>
                    <div class="mb-1">Properties: <strong><?php echo e($properties_used); ?></strong> / <strong><?php echo e($property_limit); ?></strong> <span class="text-muted">(left <?php echo e($properties_left); ?>)</span></div>
                    <?php if(!is_null($ads_limit)): ?>
                      <div>Ads: <strong><?php echo e($ads_used ?? '-'); ?></strong> / <strong><?php echo e($ads_limit); ?></strong> <?php if(!is_null($ads_left)): ?> <span class="text-muted">(left <?php echo e($ads_left); ?>)</span><?php endif; ?></div>
                    <?php endif; ?>
                  </div>
                </div>
              </div>
            </div>

            <hr>

            <h5 class="mb-3">Transactions</h5>
            <div class="table-responsive">
              <style>
                /* Scoped dark theme for user transactions table */
                #user-transactions-table {
                  color: #e6e6e6;
                  background: #0e1422;
                  border-color: #24314d;
                }
                #user-transactions-table thead th {
                  background: #121a2b;
                  color: #e6e6e6;
                  border-color: #24314d;
                }
                #user-transactions-table tbody tr {
                  background: #0e1422;
                  border-color: #24314d;
                }
                #user-transactions-table tbody tr:nth-child(odd) {
                  background: #10182a; /* subtle stripe, still dark */
                }
                #user-transactions-table td, #user-transactions-table th {
                  border-color: #24314d !important;
                }
              </style>
              <table id="user-transactions-table" class="table" style="color:#e6e6e6;">
                <thead>
                  <tr>
                    <th>ID</th>
                    <th>Plan</th>
                    <th>Amount</th>
                    <th>Gateway</th>
                    <th>Status</th>
                    <th>Reference</th>
                    <th>Date</th>
                  </tr>
                </thead>
                <tbody>
                  <?php $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $t): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                      <td>#<?php echo e($t->id); ?></td>
                      <td><?php echo e(optional($t->subscriptionPlan)->plan_name); ?></td>
                      <td><?php echo e($t->formatted_amount); ?></td>
                      <td><?php echo e($t->gateway); ?></td>
                      <td><span class="badge <?php echo e($t->status_badge); ?>"><?php echo e(ucfirst($t->payment_status)); ?></span></td>
                      <td><?php echo e($t->reference_id ?: '-'); ?></td>
                      <td><?php echo e($t->formatted_date); ?></td>
                    </tr>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
              </table>
            </div>

            <?php echo $__env->make('_particles.pagination', ['paginator' => $transactions], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

          </div>
        </div>
      </div>
    </div>
  </div>
  <?php echo $__env->make('admin.copyright', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.admin_app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/dextragr/public_html/floorlocator/resources/views/admin/pages/users/show.blade.php ENDPATH**/ ?>