    <!-- Internal CSS for City Modal -->
    <style>
        #cityModal {
            user-select: none;
            position: fixed;
            top: 0;
            left: 0;
            width: 100vw;
            height: 100vh;
            background: rgba(0, 0, 0, 0.35);
            z-index: 9999;
            display: flex;
            align-items: center;
            justify-content: center;
            font-family: Arial, sans-serif;
        }

        #cityModal .city-modal-box {
            background: #fff;
            border-radius: 8px;
            box-shadow: 0 8px 32px rgba(0, 0, 0, 0.18);
            width: 480px;
            max-width: 96vw;
            padding: 32px 32px 24px 32px;
            position: relative;
        }

        #cityModal h3 {
            text-align: center;
            /* font-weight: 600; */
            margin-bottom: 24px;
            color: #D8232A
        }

        #cityModal .city-search {
            display: flex;
            align-items: center;
            border: 1px solid #eee;
            border-radius: 4px;
            padding: 0 12px;
            margin-bottom: 18px;
        }

        #cityModal .city-search input {
            flex: 1;
            border: none;
            outline: none;
            font-size: 16px;
            padding: 10px 0;
            background: transparent;
        }

        #cityModal .city-search .fa-search {
            color: #D8232A;
            font-size: 22px;
            margin-left: 8px;
        }

        #cityModal .city-list-label {
            font-size: 16px;
            margin-bottom: 10px;
            display: block;
            font-weight: 600;
        }

        #cityModal #cityList {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 10px;
        }

        #cityModal .city-option {
            cursor: pointer;
            padding: 6px 0;
            transition: background 0.2s, color 0.2s;
        }

        #cityModal .city-option:hover {
            /* background: #f7f7f7; */
            color: #D8232A;
        }
    </style>
    <!-- City Selection Modal -->
    <div id="cityModal" style="display:none;">
        <div class="city-modal-box">
            <h3>YOUR CITY</h3>
            <div class="city-search">
                <input id="citySearchInput" type="text" placeholder="Select or Type your city" />
                <span><i class="fa fa-search"></i></span>
            </div>
            <div>
                <span class="city-list-label">Popular Cities</span>
                <div id="cityList">
                    
                    <?php
                        $cities = getCityList();
                    ?>

                    <?php $__currentLoopData = $cities; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $city): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="city-option" value="<?php echo e($city->id); ?>"><?php echo e($city->name); ?></div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </div>
    <script>
        // Show city modal only if city_id cookie is not set, before DOMContentLoaded
        (function() {
            function getCookie(name) {
                var match = document.cookie.match(new RegExp('(^| )' + name + '=([^;]+)'));
                if (match) return match[2];
                return null;
            }
            var modal = document.getElementById('cityModal');
            if (!getCookie('city_id')) {
                modal.style.display = 'flex';
            }
        })();

        document.addEventListener('DOMContentLoaded', function() {
            var modal = document.getElementById('cityModal');
            var cityList = document.getElementById('cityList');
            var searchInput = document.getElementById('citySearchInput');
            var options = Array.from(cityList.getElementsByClassName('city-option'));

            function setCookie(name, value, days) {
                var expires = '';
                if (days) {
                    var date = new Date();
                    date.setTime(date.getTime() + (days * 24 * 60 * 60 * 1000));
                    expires = '; expires=' + date.toUTCString();
                }
                document.cookie = name + '=' + (value || '') + expires + '; path=/';
            }

            function selectCity(cityId, cityName) {
                setCookie('city_id', cityId, 30);
                localStorage.setItem('selectedCity', cityName);
                modal.style.display = 'none';
                location.reload();
            }

            options.forEach(function(opt) {
                opt.addEventListener('click', function() {
                    var cityId = opt.getAttribute('value');
                    var cityName = opt.textContent.trim();
                    selectCity(cityId, cityName);
                });
            });
            searchInput.addEventListener('input', function() {
                var val = searchInput.value.toLowerCase();
                options.forEach(function(opt) {
                    if (opt.textContent.toLowerCase().includes(val)) {
                        opt.style.display = '';
                    } else {
                        opt.style.display = 'none';
                    }
                });
            });
            // Prevent closing modal until a city is selected
            modal.addEventListener('click', function(e) {
                if (e.target === modal) {
                    e.stopPropagation();
                }
            });
            searchInput.addEventListener('keydown', function(e) {
                if (e.key === 'Enter' && searchInput.value.trim()) {
                    selectCity(searchInput.value.trim());
                }
            });
        });
    </script>
<?php /**PATH /home/dextragr/public_html/realestate.dextragroups.com/resources/views/pages/city-modal.blade.php ENDPATH**/ ?>