

<?php $__env->startSection('head_title', trans('words.login_text').' | '.getcong('site_name') ); ?>

<?php $__env->startSection('head_url', Request::url()); ?>

<?php $__env->startSection('content'); ?>
<style>
/* Modern Form Styling */
.modern-input {
    border: 1px solid #e3e6f0;
    border-radius: 10px;
    padding: 10px 14px 10px 44px;
    font-size: 14px;
    transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    background-color: #fff;
    line-height: 1.5;
    color: #374151;
}

.modern-input::placeholder {
    color: #9ca3af;
    opacity: 1;
    font-style: italic;
}

.modern-input:focus {
    border-color: #dc3545;
    box-shadow: 0 0 0 6px rgba(220, 53, 69, 0.06);
    outline: none;
    transform: translateY(-1px);
    color: #374151;
}

.form-label {
    font-weight: 600;
    color: #374151;
    margin-bottom: 8px;
    display: block;
    font-size: 14px;
    letter-spacing: 0.025em;
}

/* Input Group Styling */
.input-group {
    position: relative;
}

.input-icon {
    position: absolute;
    left: 18px;
    top: 50%;
    transform: translateY(-50%);
    color: #9ca3af;
    z-index: 2;
    font-size: 18px;
    transition: color 0.3s ease;
    pointer-events: none;
}

.modern-input:focus + .input-icon,
.input-group:focus-within .input-icon {
    color: #dc3545;
}

/* Welcome Section */
.welcome-icon {
    width: 44px;
    height: 44px;
    margin: 0 auto;
    background: linear-gradient(135deg, #dc3545 0%, #c82333 100%);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    color: white;
    font-size: 18px;
}

.welcome-title {
    font-size: 18px;
    font-weight: 700;
    color: #1f2937;
    margin-bottom: 2px;
    letter-spacing: -0.025em;
}

.welcome-subtitle {
    color: #6b7280;
    font-size: 12px;
    margin: 0;
}

/* Modern Button Styling */
.btn-modern {
    border-radius: 10px;
    padding: 10px 14px;
    font-weight: 600;
    font-size: 13px;
    transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    border: none;
    cursor: pointer;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    gap: 8px;
    text-decoration: none;
    position: relative;
    overflow: hidden;
}

.btn-full-width {
    width: 100%;
}

.btn-primary.btn-modern {
    background: linear-gradient(135deg, #dc3545 0%, #c82333 100%);
    color: white;
    box-shadow: 0 6px 18px rgba(220, 53, 69, 0.15);
}

.btn-primary.btn-modern:hover {
    transform: translateY(-2px);
    box-shadow: 0 8px 25px rgba(220, 53, 69, 0.4);
}

.btn-primary.btn-modern:active {
    transform: translateY(0);
}

.btn-icon {
    transition: transform 0.3s ease;
}

.btn:hover .btn-icon {
    transform: translateX(2px);
}

/* Form Text */
.form-text {
    display: block;
    margin-top: 8px;
    font-size: 14px;
    color: #6b7280;
    font-style: italic;
}

/* Account Text */
.account-text {
    color: #6b7280;
    font-size: 14px;
    margin: 0;
}

.account-link {
    color: #dc3545;
    text-decoration: none;
    font-weight: 600;
    transition: color 0.3s ease;
}

.account-link:hover {
    color: #bd2130;
    text-decoration: underline;
}

/* Form Container Styling */
.login-wrapper .ui-dash {
    background: white;
    border-radius: 14px;
    padding: 18px 16px;
    box-shadow: 0 10px 30px rgba(0, 0, 0, 0.06);
    border: 1px solid rgba(0, 0, 0, 0.03);
    backdrop-filter: blur(6px);
}

.vid_title h4 {
    color: #333;
    font-size: 24px;
    margin-bottom: 8px;
}

/* Loading Spinner */
.spinner-border {
    width: 1.4rem;
    height: 1.4rem;
    color: #dc3545;
}

/* Responsive Design */
@media (max-width: 768px) {
    .login-wrapper .ui-dash {
        padding: 14px 12px;
        margin: 0 8px;
    }

    .welcome-title {
        font-size: 16px;
    }

    .modern-input {
        padding: 10px 12px 10px 40px;
        font-size: 14px;
    }

    .input-icon { left: 12px; }

    .btn-modern { padding: 10px 12px; font-size: 13px; }
}

/* Animation for step transitions */
@keyframes fadeInUp {
    from {
        opacity: 0;
        transform: translateY(20px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

#login-form > div {
    animation: fadeInUp 0.5s ease-out;
}

/* Success state styling */
.success-message {
    background: linear-gradient(135deg, #10b981 0%, #059669 100%);
    color: white;
    padding: 16px;
    border-radius: 12px;
    text-align: center;
    margin-bottom: 20px;
}
.input-group>.custom-select:not(:first-child), .input-group>.form-control:not(:first-child) {

    padding-left: 30 !important;
}

/* Compact helpers */
.compact-header .welcome-icon.small-icon { width:36px; height:36px; font-size:16px }
.compact-btn { padding:10px 12px }
.small-link { font-size:13px; }
.mb-12 { margin-bottom:12px }
.mb-15 { margin-bottom:15px }
.input-group>.custom-select:not(:first-child), .input-group>.form-control:not(:first-child) {
    border-radius: 10px;
}
</style>
  <!--Breadcrumb section starts-->
  <div class="breadcrumb-section bg-xs" style="background-image: url(<?php echo e(URL::asset('site_assets/images/breadcrumb-1.jpg')); ?>)">
    <div class="overlay op-2"></div>
    <div class="container">
      <div class="row">
        <div class="col-md-8 offset-md-2 text-center">
          <div class="breadcrumb-menu">
            <h2><?php echo e(trans('words.login_text')); ?></h2>
            <span><a href="<?php echo e(URL::to('/')); ?>" title="<?php echo e(trans('words.home')); ?>"><?php echo e(trans('words.home')); ?></a></span> <span><?php echo e(trans('words.login_text')); ?></span></div>
        </div>
      </div>
    </div>
  </div>
  <!--Breadcrumb section ends-->

  <!--Login starts-->
  <div class="about-section pt-30 pb-20">
    <div class="container">
      <div class="row">
        <div class="col-lg-5 mx-auto">
           <div class="signin-form" style="border: 2px solid #e5e7eb; padding: 10px; border-radius: 30px;">
                <div id="login-form">
                    <div class="text-center mb-20 compact-header">
                        <div class="welcome-icon mb-12 small-icon">
                            <i class="fa fa-sign-in"></i>
                        </div>
                        <h3 class="welcome-title">Welcome Back</h3>
                        <p class="welcome-subtitle">Sign in to your account</p>
                    </div>

                    <div class="form-group mb-15">
                        <label for="phone" class="form-label">Mobile Number</label>
                        <div class="input-group">
                            <span class="input-icon"><i class="fa fa-mobile"></i></span>
                            <input type="tel" name="phone" id="phone" tabindex="1" class="form-control modern-input" placeholder="Mobile number" value="">
                        </div>
                    </div>

                    <div id="otp-section" style="display: none;">
                        <div class="form-group mb-15">
                            <label for="otp" class="form-label">Verification Code</label>
                            <div class="input-group">
                                <span class="input-icon"><i class="fa fa-key"></i></span>
                                <input type="text" name="otp" id="otp" tabindex="2" class="form-control modern-input" placeholder="4-digit code" maxlength="6">
                            </div>
                            <small class="form-text">We've sent a verification code to your number</small>
                        </div>

                        <div class="text-center mb-12">
                            <button type="button" id="verify-otp-btn" class="btn btn-primary btn-modern btn-full-width compact-btn">
                                <span class="btn-text">Sign In</span>
                                <span class="btn-icon"><i class="fa fa-arrow-right"></i></span>
                            </button>
                        </div>
                        <div class="text-center">
                            <button type="button" id="resend-otp-btn" class="btn btn-link btn-modern-link small-link">
                                <i class="fa fa-refresh"></i> Resend
                            </button>
                        </div>
                    </div>

                    <div id="send-otp-section">
                        <div class="text-center mb-12">
                            <button type="button" id="send-otp-btn" class="btn btn-primary btn-modern btn-full-width compact-btn">
                                <span class="btn-text">Send Code</span>
                                <span class="btn-icon"><i class="fa fa-paper-plane"></i></span>
                            </button>
                        </div>
                    </div>

                    <div id="loading" style="display: none;" class="text-center mt-2">
                        <div class="spinner-border text-primary" role="status">
                            <span class="sr-only">Loading...</span>
                        </div>
                    </div>

            <div class="text-center mt-25">
            <p class="account-text">Don't have an account?
                <a href="<?php echo e(url('signup')); ?>" class="account-link">Create Account</a>
            </p>
            </div>
                </div>
		    </div>
         </div>
      </div>
    </div>
  </div>
  <!--Login ends-->


<script type="text/javascript">
'use strict';

<?php if(Session::has('flash_message')): ?>
  const Toast = Swal.mixin({
    toast: true,
    position: 'top-end',
    showConfirmButton: false,
    timer: 3000,
    timerProgressBar: false,
  })

  Toast.fire({
    icon: 'success',
    title: '<?php echo e(Session::get('flash_message')); ?>'
  })
<?php endif; ?>

<?php if(Session::has('error_flash_message')): ?>
  const Toast = Swal.mixin({
    toast: true,
    position: 'top-end',
    showConfirmButton: false,
    timer: 3000,
    timerProgressBar: false,
  })

  Toast.fire({
    icon: 'error',
    title: '<?php echo e(Session::get('error_flash_message')); ?>'
  })
<?php endif; ?>

document.addEventListener('DOMContentLoaded', function() {
    const phoneInput = document.getElementById('phone');
    const sendOtpBtn = document.getElementById('send-otp-btn');
    const otpInput = document.getElementById('otp');
    const verifyOtpBtn = document.getElementById('verify-otp-btn');
    const resendOtpBtn = document.getElementById('resend-otp-btn');
    const otpSection = document.getElementById('otp-section');
    const sendOtpSection = document.getElementById('send-otp-section');
    const loading = document.getElementById('loading');

    let currentPhone = '';

    // Send OTP
    sendOtpBtn.addEventListener('click', function() {
        const phone = phoneInput.value.trim();

        if (!phone) {
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: 'Please enter your mobile number'
            });
            return;
        }

        if (!/^[6-9][0-9]{9}$/.test(phone)) {
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: 'Please enter a valid 10-digit mobile number'
            });
            return;
        }

        currentPhone = phone;
        showLoading();

        fetch('<?php echo e(url("/login/send-otp")); ?>', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            },
            body: JSON.stringify({
                phone: phone,
                _token: document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            })
        })
        .then(response => response.json())
        .then(data => {
            hideLoading();
            if (data.success) {
                otpSection.style.display = 'block';
                sendOtpSection.style.display = 'none';
                otpInput.focus();

                Swal.fire({
                    icon: 'success',
                    title: 'Success',
                    text: data.message
                });
            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: data.message
                });
            }
        })
        .catch(error => {
            hideLoading();
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: 'Something went wrong. Please try again.'
            });
        });
    });

    // Verify OTP
    verifyOtpBtn.addEventListener('click', function() {
        const otp = otpInput.value.trim();

        if (!otp || otp.length !== 4) {
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: 'Please enter a valid 4-digit OTP'
            });
            return;
        }

        showLoading();

        fetch('<?php echo e(url("/login/verify-otp")); ?>', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            },
            body: JSON.stringify({
                phone: currentPhone,
                otp: otp,
                _token: document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            })
        })
        .then(response => response.json())
        .then(data => {
            hideLoading();
            if (data.success) {
                Swal.fire({
                    icon: 'success',
                    title: 'Success',
                    text: data.message
                }).then(() => {
                    window.location.href = data.redirect || '/dashboard';
                });
            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: data.message
                });
            }
        })
        .catch(error => {
            hideLoading();
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: 'Something went wrong. Please try again.'
            });
        });
    });

    // Resend OTP
    resendOtpBtn.addEventListener('click', function() {
        if (!currentPhone) {
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: 'Please enter your mobile number first'
            });
            return;
        }

        showLoading();

        fetch('<?php echo e(url("/login/resend-otp")); ?>', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            },
            body: JSON.stringify({
                type: 'login',
                phone: currentPhone,
                _token: document.querySelector('meta[name="csrf-token"]').getAttribute('content')
            })
        })
        .then(response => response.json())
        .then(data => {
            hideLoading();
            if (data.success) {
                Swal.fire({
                    icon: 'success',
                    title: 'Success',
                    text: data.message
                });
            } else {
                Swal.fire({
                    icon: 'error',
                    title: 'Error',
                    text: data.message
                });
            }
        })
        .catch(error => {
            hideLoading();
            Swal.fire({
                icon: 'error',
                title: 'Error',
                text: 'Something went wrong. Please try again.'
            });
        });
    });

    function showLoading() {
        loading.style.display = 'block';
        sendOtpBtn.disabled = true;
        verifyOtpBtn.disabled = true;
        resendOtpBtn.disabled = true;
    }

    function hideLoading() {
        loading.style.display = 'none';
        sendOtpBtn.disabled = false;
        verifyOtpBtn.disabled = false;
        resendOtpBtn.disabled = false;
    }

    // Enter key to send OTP
    phoneInput.addEventListener('keypress', function(e) {
        if (e.key === 'Enter') {
            sendOtpBtn.click();
        }
    });

    // Enter key to verify OTP
    otpInput.addEventListener('keypress', function(e) {
        if (e.key === 'Enter') {
            verifyOtpBtn.click();
        }
    });
});
</script>



<?php echo $__env->make('site_app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/dextragr/public_html/floorlocator/resources/views/pages/user/phone_login.blade.php ENDPATH**/ ?>