<?php $__env->startSection('head_title', getcong('site_name')); ?>

<?php $__env->startSection('head_url', Request::url()); ?>

<?php $__env->startSection('content'); ?>

    

    <!--Hero section starts (Swiper slider)-->
    <div class="hero-swiper-wrapper">
        <div class="swiper-container hero-swiper">
            <div class="swiper-wrapper">
                <?php $__currentLoopData = $banners; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $banner): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <?php
                        $bannerLink = $banner->redirect_url ?? '';
                        $isExternal = $bannerLink && (Str::startsWith($bannerLink, ['http://', 'https://']));
                    ?>
                    <div class="swiper-slide">
                        <?php if($bannerLink): ?>
                            <a href="<?php echo e($isExternal ? $bannerLink : url($bannerLink)); ?>" <?php if($isExternal): ?> rel="noopener noreferrer" <?php endif; ?> class="banner-link">
                        <?php endif; ?>

                        <div class="hero vfx2 section-padding" style="background-image: url(<?php echo e(URL::asset($banner->image_path)); ?>)">
                            <div class="overlay"></div>
                            <!--Listing filter starts-->
                            <div class="container vfx-posabs">
                                <div class="row">
                                    <div class="col-md-10 offset-md-1">
                                        
                                    </div>
                                </div>
                            </div>
                            <!--Listing filter ends-->
                        </div>

                        <?php if($bannerLink): ?>
                            </a>
                        <?php endif; ?>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
            <!-- Pagination -->
            <div class="swiper-pagination hero-swiper-pagination"></div>
            <!-- Navigation -->
            <div class="swiper-button-next hero-swiper-next"></div>
            <div class="swiper-button-prev hero-swiper-prev"></div>
        </div>
    </div>

    <style>
        /* ensure pagination dots are visible on hero */
        .hero-swiper-pagination { position: absolute; bottom: 18px; left: 50%; transform: translateX(-50%); z-index: 50; }
        .hero-swiper-pagination .swiper-pagination-bullet { width: 10px; height: 10px; opacity: 1; background: rgba(255,255,255,0.8); border: 1px solid rgba(0,0,0,0.12); }
        .hero-swiper-pagination .swiper-pagination-bullet-active { background: #088178; border-color: #088178; }

    /* make entire banner slide clickable when wrapped in .banner-link */
    .banner-link { display: block; position: relative; color: inherit; text-decoration: none; }
    .banner-link:focus { outline: 2px solid rgba(8,129,120,0.6); outline-offset: 2px; }
    </style>

    <?php $__env->startPush('scripts'); ?>
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            if (typeof Swiper !== 'undefined') {
                var heroSwiper = new Swiper('.hero-swiper', {
                    loop: true,
                    slidesPerView: 1,
                    autoHeight: true,
                    autoplay: {
                        delay: 5000,
                        disableOnInteraction: false,
                        pauseOnMouseEnter: true
                    },
                    speed: 800,
                    grabCursor: true,
                    keyboard: { enabled: true, onlyInViewport: true },
                    pagination: { el: '.hero-swiper-pagination', clickable: true },
                    navigation: { nextEl: '.hero-swiper-next', prevEl: '.hero-swiper-prev' },
                    effect: 'fade',
                    fadeEffect: { crossFade: true },
                    a11y: true
                });
                // small debug: uncomment if bullets missing
                // console.log('Hero swiper initialized, pagination children:', document.querySelector('.hero-swiper-pagination')?.children.length);
            } else {
                console.warn('Swiper not found — ensure Swiper JS/CSS are loaded in layout.');
            }
        });
    </script>
    <?php $__env->stopPush(); ?>

    <!--Hero section ends-->

    <!-- Add banner Section -->
    <?php if(get_web_banner('home_top') != ''): ?>
        <div class="add_banner_section pb-0 mb-20">
            <div class="container">
                <div class="row">
                    <div class="col-md-12">
                        <?php echo stripslashes(get_web_banner('home_top')); ?>

                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>
    <!-- Add banner Section -->

    
    <div class="vfx-team-section-area bg-cb-gra pb-20 pt-20">
        <div class="container">
            <div class="row">
                <div class="col-md-12">

                    <?php echo e(html()->form('GET', url('/properties/search'))->attributes(['class' => 'vfx_hero_form_area vfx2 filter listing-filter bg-cb', 'id' => 'search', 'role' => 'form'])->open()); ?>


                    <div class="row">
                        <div class="col-xl-4 col-lg-3 col-sm-12 pr-lg-0">
                            <div class="input-search">
                                <input type="text" name="search_text" id="search_text"
                                    placeholder="<?php echo e(trans('words.search_by_title')); ?>">
                            </div>
                        </div>
                        <div class="col-xl-2 col-lg-3 col-sm-12 pr-lg-0">
                            <select name="purpose" class="vfx_hero_form_area_input vfx-custom-select-area">
                                <option value=""><?php echo e(trans('words.purpose')); ?></option>

                                <option value="<?php echo e(trans('words.sale')); ?>"><?php echo e(trans('words.sale')); ?></option>
                                <option value="<?php echo e(trans('words.rent')); ?>"><?php echo e(trans('words.rent')); ?></option>
                            </select>
                        </div>
                        <div class="col-xl-2 col-lg-3 col-sm-12 pr-lg-0">
                            <select name="type_id" class="vfx_hero_form_area_input vfx-custom-select-area">
                                <option value=""><?php echo e(trans('words.property_type')); ?></option>
                                <?php $__currentLoopData = \App\Type::where('status', 1)->orderby('type_name')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type_data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($type_data->id); ?>"><?php echo e($type_data->type_name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="col-xl-2 col-lg-3 col-sm-12 pr-lg-0">
                            <select name="location_id" class="vfx_hero_form_area_input vfx-custom-select-area">
                                <option value=""><?php echo e(trans('words.location')); ?></option>
                                <?php $__currentLoopData = \App\Location::where('status', 1)->orderby('name')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $location_data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($location_data->id); ?>"><?php echo e($location_data->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                        <div class="col-xl-2 col-lg-3 col-sm-12">
                            <div class="submit_btn">
                                <button class="btn vfx3" type="submit"><?php echo e(trans('words.search_text')); ?></button>
                            </div>
                        </div>
                    </div>
                    <?php echo e(html()->form()->close()); ?>

                </div>
            </div>
        </div>
    </div>
    

    <!--Category section starts-->
    
    <!--Category section starts-->

    <!--Latest Property Starts-->
    <div class="vfx-trending-places bg-cb pb-30 pt-20">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <div class="section-title vid-item-section mb-15">
                        <h2><?php echo e(trans('words.latest_property')); ?></h2>
                        <span class="view-more">
                            <a href="<?php echo e(URL::to('latest')); ?>" title="view all"><?php echo e(trans('words.view_all')); ?><svg
                                    xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 512 512"
                                    style="vertical-align: text-top">
                                    <path fill="none" stroke="currentColor" stroke-linecap="round"
                                        stroke-linejoin="round" stroke-width="60" d="m184 112l144 144l-144 144"></path>
                                </svg></a>
                        </span>
                    </div>
                </div>
                <div class="swiper-container vfx-latest-property-wrap">
                    <div class="swiper-wrapper">

                        <?php $__currentLoopData = $latest_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $latest_data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="swiper-slide">
                                <div class="vfx-single-property-box-area">
                                    <div class="vfx-property-item"> <a class="vfx-property-img"
                                            href="<?php echo e(URL::to('properties/' . $latest_data->slug . '/' . $latest_data->id)); ?>"
                                            title="<?php echo e(stripslashes($latest_data->title)); ?>"><img
                                                src="<?php echo e(\URL::to('/' . $latest_data->image)); ?>" alt="image"
                                                title="image"> </a>
                                        <ul class="vfx-feature-text">
                                            <?php if($latest_data->purpose == 'Rent'): ?>
                                                <li class="feature_cb"><span><?php echo e(trans('words.rent')); ?></span></li>
                                            <?php else: ?>
                                                <li class="feature_or"><span><?php echo e(trans('words.sale')); ?></span></li>
                                            <?php endif; ?>
                                            <?php if($latest_data->verified == 'YES'): ?>
                                                <li class="feature_cb verified_item"><i class="fa fa-check 1"
                                                        data-toggle="tooltip" data-placement="top" title=""
                                                        data-original-title="<?php echo e(trans('words.verified')); ?>"></i></li>
                                            <?php endif; ?>
                                        </ul>
                                        <div class="vfx-property-author-wrap">
                                            <p class="text-tlt"><?php echo e($latest_data->types->type_name); ?></p>
                                            <ul class="vfx-save-btn">

                                                <li data-toggle="tooltip" data-placement="top" title=""
                                                    data-original-title="Set Favourite"
                                                    class="favourite_property favourite_title_id<?php echo e($latest_data->id); ?>"
                                                    data-id="<?php echo e($latest_data->id); ?>">
                                                    <?php if(check_favourite('Property', $latest_data->id, isset(Auth::user()->id) ? Auth::user()->id : '')): ?>
                                                        <a href="Javascript:void(0);" title="fav"><i
                                                                class="fa fa-heart favourite_icon_id<?php echo e($latest_data->id); ?>"></i></a>
                                                    <?php else: ?>
                                                        <a href="Javascript:void(0);" title="fav"><i
                                                                class="fa fa-heart-o favourite_icon_id<?php echo e($latest_data->id); ?>"></i></a>
                                                    <?php endif; ?>
                                                </li>

                                            </ul>
                                        </div>
                                    </div>
                                    <div class="vfx-property-title-box-area">
                                        <h4><a href="<?php echo e(URL::to('properties/' . $latest_data->slug . '/' . $latest_data->id)); ?>"
                                                title="<?php echo e(stripslashes($latest_data->title)); ?>"><?php echo e(Str::limit(stripslashes($latest_data->title), 30)); ?></a>
                                        </h4>
                                        <div class="vfx-property-location"> <i class="fa fa-map-marker"></i>
                                            <p>
                                                <?php if(isset($latest_data->locations->name) and $latest_data->locations->name != ''): ?>
                                                    <?php echo e($latest_data->locations->name); ?>

                                                <?php else: ?>
                                                    <?php echo e(Str::limit(stripslashes($latest_data->address), 40)); ?>

                                                <?php endif; ?>
                                            </p>
                                        </div>
                                        <div class="trending-bottom">
                                            <div class="trend-left float-left">
                                                <div class="vfx-property-author-wrap">
                                                    <a href="<?php echo e(URL::to('properties/owner/' . $latest_data->user_id)); ?>"
                                                        class="property-author" title="user profile">

                                                        <?php if($latest_data->users->user_image): ?>
                                                            <img src="<?php echo e(\URL::to('upload/' . $latest_data->users->user_image)); ?>"
                                                                alt="user_image"
                                                                title="<?php echo e(stripslashes($latest_data->title)); ?>">
                                                        <?php else: ?>
                                                            <img src="<?php echo e(\URL::to('site_assets/images/user-default.jpg')); ?>"
                                                                alt="user" title="title">
                                                        <?php endif; ?>

                                                        <span><?php echo e($latest_data->users->name); ?></span>
                                                    </a>
                                                </div>
                                            </div>
                                            <a href="<?php echo e(URL::to('properties/' . $latest_data->slug . '/' . $latest_data->id)); ?>"
                                                class="vfx-trend-right float-right"
                                                title="<?php echo e(stripslashes($latest_data->title)); ?>">
                                                <div class="vfx-trend-open-price">
                                                    <?php echo e(html_entity_decode(getCurrencySymbols(getcong('currency_code')))); ?><?php echo e(number_format($latest_data->price)); ?>

                                                </div>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                    </div>
                </div>
                <div class="vfx-latest-property-pagination"></div>
            </div>
        </div>
    </div>
    <!--Latest Property Ends-->

    <?php if(count($trending_list) > 0): ?>
        <!--Popular Property Starts-->
        <div class="vfx-trending-places our-story-bg-2 pb-30 mt-20">
            <div class="container">
                <div class="row">
                    <div class="col-md-12">
                        <div class="section-title vid-item-section mb-15">
                            <h2><?php echo e(trans('words.trending_now')); ?></h2>
                            <span class="view-more">
                                <a href="<?php echo e(URL::to('popular')); ?>" title="popular"><?php echo e(trans('words.view_all')); ?><svg
                                        xmlns="http://www.w3.org/2000/svg" width="18" height="18"
                                        viewBox="0 0 512 512" style="vertical-align: text-top">
                                        <path fill="none" stroke="currentColor" stroke-linecap="round"
                                            stroke-linejoin="round" stroke-width="60" d="m184 112l144 144l-144 144">
                                        </path>
                                    </svg></a>
                            </span>
                        </div>
                    </div>
                    <div class="swiper-container vfx-popular-property-wrap">
                        <div class="swiper-wrapper">

                            <?php $__currentLoopData = $trending_list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trending_data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $property_info = \App\Property::find($trending_data->post_id);
                                ?>
                                <div class="swiper-slide">
                                    <div class="vfx-single-property-box-area">
                                        <div class="vfx-property-item"> <a class="vfx-property-img"
                                                href="<?php echo e(URL::to('properties/' . $property_info->slug . '/' . $property_info->id)); ?>"
                                                title="<?php echo e(stripslashes($property_info->title)); ?>"><img
                                                    src="<?php echo e(\URL::to('/' . $property_info->image)); ?>" alt="image"
                                                    title="image"> </a>
                                            <ul class="vfx-feature-text">
                                                <?php if($property_info->purpose == 'Rent'): ?>
                                                    <li class="feature_cb"><span><?php echo e(trans('words.rent')); ?></span></li>
                                                <?php else: ?>
                                                    <li class="feature_or"><span><?php echo e(trans('words.sale')); ?></span></li>
                                                <?php endif; ?>

                                                <?php if($property_info->verified == 'YES'): ?>
                                                    <li class="feature_cb verified_item"><i class="fa fa-check 1"
                                                            data-toggle="tooltip" data-placement="top" title=""
                                                            data-original-title="<?php echo e(trans('words.verified')); ?>"></i></li>
                                                <?php endif; ?>
                                            </ul>
                                            <div class="vfx-property-author-wrap">
                                                <p class="text-tlt"><?php echo e($property_info->types->type_name); ?></p>
                                                <ul class="vfx-save-btn">

                                                    <li data-toggle="tooltip" data-placement="top" title=""
                                                        data-original-title="Set Favourite"
                                                        class="favourite_property favourite_title_id<?php echo e($property_info->id); ?>"
                                                        data-id="<?php echo e($property_info->id); ?>">
                                                        <?php if(check_favourite('Property', $property_info->id, isset(Auth::user()->id) ? Auth::user()->id : '')): ?>
                                                            <a href="Javascript:void(0);" title="view"><i
                                                                    class="fa fa-heart favourite_icon_id<?php echo e($property_info->id); ?>"></i></a>
                                                        <?php else: ?>
                                                            <a href="Javascript:void(0);" title="view"><i
                                                                    class="fa fa-heart-o favourite_icon_id<?php echo e($property_info->id); ?>"></i></a>
                                                        <?php endif; ?>
                                                    </li>

                                                </ul>
                                            </div>
                                        </div>
                                        <div class="vfx-property-title-box-area">
                                            <h4><a href="<?php echo e(URL::to('properties/' . $property_info->slug . '/' . $property_info->id)); ?>"
                                                    title="<?php echo e(stripslashes($property_info->title)); ?>"><?php echo e(Str::limit(stripslashes($property_info->title), 30)); ?></a>
                                            </h4>
                                            <div class="vfx-property-location"> <i class="fa fa-map-marker"></i>
                                                <p>
                                                    <?php if(isset($property_info->locations->name) and $property_info->locations->name != ''): ?>
                                                        <?php echo e($property_info->locations->name); ?>

                                                    <?php else: ?>
                                                        <?php echo e(Str::limit(stripslashes($property_info->address), 40)); ?>

                                                    <?php endif; ?>
                                                </p>
                                            </div>
                                            <div class="trending-bottom">
                                                <div class="trend-left float-left">
                                                    <div class="vfx-property-author-wrap">
                                                        <a href="<?php echo e(URL::to('properties/owner/' . $property_info->user_id)); ?>"
                                                            class="property-author">

                                                            <?php if($property_info->users->user_image): ?>
                                                                <img src="<?php echo e(\URL::to('upload/' . $property_info->users->user_image)); ?>"
                                                                    alt="user_image"
                                                                    title="<?php echo e(stripslashes($property_info->title)); ?>">
                                                            <?php else: ?>
                                                                <img src="<?php echo e(\URL::to('site_assets/images/user-default.jpg')); ?>"
                                                                    alt="user_image"
                                                                    title="<?php echo e(stripslashes($property_info->title)); ?>">
                                                            <?php endif; ?>

                                                            <span><?php echo e($property_info->users->name); ?></span>
                                                        </a>
                                                    </div>
                                                </div>
                                                <a href="<?php echo e(URL::to('properties/' . $property_info->slug . '/' . $property_info->id)); ?>"
                                                    class="vfx-trend-right float-right"
                                                    title="<?php echo e(stripslashes($property_info->title)); ?>">
                                                    <div class="vfx-trend-open-price">
                                                        <?php echo e(html_entity_decode(getCurrencySymbols(getcong('currency_code')))); ?><?php echo e(number_format($property_info->price)); ?>

                                                    </div>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                        </div>
                    </div>
                    <div class="vfx-popular-property-pagination"></div>
                </div>
            </div>
        </div>
        <!--Popular Property Ends-->
    <?php endif; ?>

    <!-- Add banner Section -->
    <?php if(get_web_banner('home_bottom') != ''): ?>
        <div class="add_banner_section pt-0">
            <div class="container">
                <div class="row">
                    <div class="col-md-12">
                        <?php echo stripslashes(get_web_banner('home_bottom')); ?>

                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <span class="vfx-scroll-top-btn"><i class="lnr lnr-arrow-up"></i></span>


    <!--Page Wrapper ends-->
<?php $__env->stopSection(); ?>

<?php echo $__env->make('site_app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\webapplication\realestate.dextragroups.com\resources\views/pages/index.blade.php ENDPATH**/ ?>