<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('banners', function (Blueprint $table) {
            $table->id();                                // banner_id
            $table->unsignedInteger('user_id');
            $table->foreign('user_id')->references('id')->on('users')->onDelete('cascade');

            $table->string('name', 150);                 // banner-name
            $table->string('slug')->unique();            // slug
            $table->string('image_path');                // banner image path or URL
            $table->string('redirect_url')->nullable();  // redirect url

            $table->text('description')->nullable();     // description
            $table->decimal('cost', 12, 2)->default(0);  // cost
            $table->tinyInteger('status')->default(1);   // 1=active, 0=inactive

            $table->dateTime('starts_at')->nullable();   // banner-start-date
            $table->dateTime('ends_at')->nullable();     // banner-stop-date

            $table->decimal('lat', 10, 7)->nullable();   // latitude
            $table->decimal('lng', 10, 7)->nullable();   // longitude

            $table->timestamps();                        // created-at, updated-at

            // helpful indexes
            $table->index(['status', 'starts_at', 'ends_at']);
            $table->index('cost');
            $table->index(['lat', 'lng']);
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('banners');
    }
};
