<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('transaction', function (Blueprint $table) {
            // Add new columns for enhanced payment history
            $table->string('transaction_type')->default('subscription')->after('payment_id'); // subscription, property_listing, etc.
            $table->text('description')->nullable()->after('transaction_type');
            $table->string('currency', 3)->default('USD')->after('description');
            $table->decimal('original_amount', 10, 2)->nullable()->after('currency');
            $table->string('payment_status')->default('completed')->after('original_amount'); // pending, completed, failed, refunded
            $table->string('reference_id')->nullable()->after('payment_status'); // internal reference
            $table->json('payment_details')->nullable()->after('reference_id'); // store gateway response
            $table->timestamp('payment_date')->nullable()->after('payment_details');
            $table->string('ip_address', 45)->nullable()->after('payment_date');
            $table->text('notes')->nullable()->after('ip_address'); // admin notes
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('transaction', function (Blueprint $table) {
            $table->dropColumn([
                'transaction_type',
                'description', 
                'currency',
                'original_amount',
                'payment_status',
                'reference_id',
                'payment_details',
                'payment_date',
                'ip_address',
                'notes',
                'created_at',
                'updated_at'
            ]);
        });
    }
};
