@extends("admin.admin_app")

@section("content")


  <div class="content-page">
    <div class="content">
      <div class="container-fluid">
        <div class="row">
          <div class="col-12">
            <div class="card-box table-responsive">

              <div class="row">
                <div class="col-md-3">

                  {{ html()->form('GET', route('admin.herobanner.index'))
    ->attributes(['class' => 'app-search', 'id' => 'search'])->open() }}
                  <input type="text" name="s" placeholder="{{trans('words.search_by_Banner_name')}}" class="form-control">
                  <button type="submit"><i class="fa fa-search"></i></button>
                  {{ html()->form()->close() }}
                </div>
                <div class="col-md-3">
                  <a href="{{route('admin.herobanner.create')}}"
                    class="btn btn-success btn-md waves-effect waves-light m-b-20 mt-2" data-toggle="tooltip"
                    title="{{trans('words.add_banner')}}"><i class="fa fa-plus"></i> {{trans('words.add_banner')}}</a>
                </div>
                <div class="col-sm-3">

                </div>
                <!-- <div class="col-md-3">
                  <a href="{{URL::to('admin/users/export')}}"
                    class="btn btn-info btn-md waves-effect waves-light m-b-20 mt-2 pull-right" data-toggle="tooltip"
                    title="{{trans('words.export_user')}}"><i class="fa fa-file-excel-o"></i>
                    {{trans('words.export_user')}}</a>
                </div> -->
              </div>

              @if(Session::has('flash_message'))
                <div class="alert alert-success">
                  <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span></button>
                  {{ Session::get('flash_message') }}
                </div>
              @endif
              <div class="table-responsive">
                <table class="table table-bordered">
                  <thead>
                    <tr>
                      <th>{{ trans('words.banner_for') }}</th>
                      <th>{{ trans('words.banner_name') }}</th>
                      <th>{{ trans('words.slug') }}</th>
                      <th>{{ trans('words.small_title') }}</th>
                      <th>{{ trans('words.main_content') }}</th>
                      <th>{{ trans('words.bottom_content') }}</th>
                      <th>{{ trans('words.cost') }}</th>
                      <th>{{ trans('words.status') }}</th>
                      <th>{{ trans('words.start_at') }}</th>
                      <th>{{ trans('words.end_at') }}</th>
                      <th>{{ trans('words.action') }}</th>
                    </tr>
                  </thead>
                  <tbody>
                    @foreach($banners as $banner)
                      <tr id="post_id_{{ $banner->id }}">
                        <td>{{ $banner->user ? $banner->user->name : 'N/A' }}</td>
                        <td>{{ $banner->name }}</td>
                        <td>{{ $banner->slug }}</td>
                        <td>{{ $banner->description['small_title'] ?? 'N/A' }}</td>
                        <td>{{ $banner->description['main_content'] ?? 'N/A' }}</td>
                        <td>{{ $banner->description['bottom_content'] ?? 'N/A' }}</td>
                        <td>{{ $banner->cost }}</td>
                        <td>
                          @if($banner->status == 1)
                            <span class="badge badge-success">Active</span>
                          @else
                            <span class="badge badge-danger">Inactive</span>
                          @endif
                        </td>
                        <td>{{ $banner->starts_at }}</td>
                        <td>{{ $banner->ends_at }}</td>
                        <td>

                          <a href="{{ route('admin.herobanner.edit', $banner->id) }}"
                            class="btn btn-icon waves-effect waves-light btn-success m-b-5 m-r-5" data-toggle="tooltip"
                            title="{{trans('words.edit')}}"> <i class="fa fa-edit"></i> </a>

                          <a href="#" class="btn btn-icon waves-effect waves-light btn-danger m-b-5 data_remove"
                            data-toggle="tooltip" title="{{trans('words.remove')}}" data-id="{{ $banner->id }}"> <i
                              class="fa fa-remove"></i> </a>

                        </td>


                    @endforeach
                  </tbody>
                </table>
              </div>
              <nav class="paging_simple_numbers">
                @include('admin.pagination', ['paginator' => $banners])
              </nav>

            </div>
          </div>
        </div>
      </div>
    </div>
    @include("admin.copyright")
  </div>

  <script src="{{ URL::asset('admin_assets/js/jquery.min.js') }}"></script>

  <!-- SweetAlert2 -->
  <script src="{{ URL::asset('admin_assets/js/sweetalert2@11.js') }}"></script>

  <script type="text/javascript">

    $(".data_remove").on('click', function () {

      'use strict';

      var post_id = $(this).data("id");
      var action_name = 'banner_delete';

      Swal.fire({
        title: '{{trans('words.dlt_warning')}}',
        text: "{{trans('words.dlt_warning_text')}}",
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: '{{trans('words.dlt_confirm')}}',
        cancelButtonText: "{{trans('words.btn_cancel')}}",
        background: "#1a2234",
        color: "#fff"

      }).then((result) => {

        if (result.isConfirmed) {

          $.ajax({
            type: 'post',
            url: "{{ route('admin.herobanner.destroy', '__ID__') }}".replace('__ID__', post_id),
            dataType: 'json',
            data: { "_token": "{{ csrf_token() }}", "_method": "DELETE" },
            success: function (res) {

              if (res.status == '1') {
                // Reload the page to reflect the updated data
                location.reload();
                
                Swal.fire({
                  position: 'center',
                  icon: 'success',
                  title: '{{trans('words.deleted')}}!',
                  showConfirmButton: true,
                  confirmButtonColor: '#10c469',
                  background: "#1a2234",
                  color: "#fff"
                })
              } else if (res.status == '0') {
                Swal.fire({
                  position: 'center',
                  icon: 'error',
                  title: res.message ? res.message : 'Something went wrong!',
                  showConfirmButton: true,
                  confirmButtonColor: '#10c469',
                  background: "#1a2234",
                  color: "#fff"
                })
              }

            }
          });
        }

      })

    });

  </script>


@endsection