@extends("admin.admin_app")

@section("content")

<div class="content-page">
    <div class="content">
        <div class="container-fluid">
            
            <!-- Payment Statistics -->
            <div class="row">
                <div class="col-xl-3 col-md-6">
                    <div class="card-box">
                        <div class="float-right mt-2">
                            <i class="fa fa-credit-card text-primary" style="font-size: 24px;"></i>
                        </div>
                        <div>
                            <h4 class="mb-1 mt-1"><span data-plugin="counterup">{{ $stats['total_payments'] }}</span></h4>
                            <p class="text-muted mb-0">Total Payments</p>
                        </div>
                    </div>
                </div>

                <div class="col-xl-3 col-md-6">
                    <div class="card-box">
                        <div class="float-right mt-2">
                            <i class="fa fa-check-circle text-success" style="font-size: 24px;"></i>
                        </div>
                        <div>
                            <h4 class="mb-1 mt-1"><span data-plugin="counterup">{{ $stats['completed_payments'] }}</span></h4>
                            <p class="text-muted mb-0">Completed</p>
                        </div>
                    </div>
                </div>

                <div class="col-xl-3 col-md-6">
                    <div class="card-box">
                        <div class="float-right mt-2">
                            <i class="fa fa-clock-o text-warning" style="font-size: 24px;"></i>
                        </div>
                        <div>
                            <h4 class="mb-1 mt-1"><span data-plugin="counterup">{{ $stats['pending_payments'] }}</span></h4>
                            <p class="text-muted mb-0">Pending</p>
                        </div>
                    </div>
                </div>

                <div class="col-xl-3 col-md-6">
                    <div class="card-box">
                        <div class="float-right mt-2">
                            <i class="fa fa-dollar text-info" style="font-size: 24px;"></i>
                        </div>
                        <div>
                            <h4 class="mb-1 mt-1">{{html_entity_decode(getCurrencySymbols(getcong('currency_code')))}}{{ number_format($stats['total_revenue'], 2) }}</h4>
                            <p class="text-muted mb-0">Total Revenue</p>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-12">
                    <div class="card-box table-responsive">
                        
                        <!-- Filters -->
                        <div class="row mb-3">
                            <div class="col-md-2">
                                <select class="form-control" name="status_filter" id="status_filter">
                                    <option value="">All Status</option>
                                    <option value="?status=completed" @if(request('status') == 'completed') selected @endif>Completed</option>
                                    <option value="?status=pending" @if(request('status') == 'pending') selected @endif>Pending</option>
                                    <option value="?status=failed" @if(request('status') == 'failed') selected @endif>Failed</option>
                                    <option value="?status=refunded" @if(request('status') == 'refunded') selected @endif>Refunded</option>
                                </select>
                            </div>
                            
                            <div class="col-md-2">
                                <select class="form-control" name="gateway_filter" id="gateway_filter">
                                    <option value="">All Gateways</option>
                                    @foreach($gateways as $gateway)
                                        <option value="?gateway={{ $gateway->gateway_name }}" @if(request('gateway') == $gateway->gateway_name) selected @endif>
                                            {{ $gateway->gateway_name }}
                                        </option>
                                    @endforeach
                                </select>
                            </div>

                            <div class="col-md-2">
                                <input type="date" name="date_from" class="form-control" placeholder="From Date" value="{{ request('date_from') }}">
                            </div>

                            <div class="col-md-2">
                                <input type="date" name="date_to" class="form-control" placeholder="To Date" value="{{ request('date_to') }}">
                            </div>

                            <div class="col-md-3">
                                {{ html()->form('GET', url('/admin/payments'))
                                   ->attributes(['class' => 'app-search', 'id' => 'search'])->open() }}
                                    <input type="text" name="s" placeholder="Search by payment ID, email, user name..." class="form-control" value="{{ request('s') }}">
                                    <button type="submit"><i class="fa fa-search"></i></button>
                                {{ html()->form()->close() }}
                            </div>

                            <div class="col-md-1">
                                <button type="button" class="btn btn-success" data-toggle="modal" data-target="#addManualPayment">
                                    <i class="fa fa-plus"></i> Add
                                </button>
                            </div>
                        </div>

                        @if(Session::has('flash_message'))
                            <div class="alert alert-success">
                                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                                {{ Session::get('flash_message') }}
                            </div>
                        @endif

                        <div class="table-responsive">
                            <table class="table table-bordered table-hover">
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>User</th>
                                        <th>Plan</th>
                                        <th>Amount</th>
                                        <th>Gateway</th>
                                        <th>Payment ID</th>
                                        <th>Status</th>
                                        <th>Type</th>
                                        <th>Date</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($payments as $payment)
                                    <tr>
                                        <td>{{ $payment->id }}</td>
                                        <td>
                                            <a href="{{ url('admin/users/history/'.$payment->user_id) }}" class="text-primary">
                                                {{ $payment->user ? $payment->user->name : 'N/A' }}
                                            </a>
                                            <br><small class="text-muted">{{ $payment->email }}</small>
                                        </td>
                                        <td>{{ $payment->subscriptionPlan ? $payment->subscriptionPlan->plan_name : 'N/A' }}</td>
                                        <td>
                                            <strong>{{ $payment->formatted_amount }}</strong>
                                            @if($payment->currency != getcong('currency_code'))
                                                <br><small class="text-muted">{{ $payment->currency }}</small>
                                            @endif
                                        </td>
                                        <td>
                                            <span class="badge badge-primary">{{ $payment->gateway }}</span>
                                        </td>
                                        <td>
                                            <code>{{ $payment->payment_id }}</code>
                                        </td>
                                        <td>
                                            <span class="badge {{ $payment->status_badge }}">
                                                {{ ucfirst($payment->payment_status) }}
                                            </span>
                                        </td>
                                        <td>{{ ucfirst($payment->transaction_type) }}</td>
                                        <td>{{ $payment->formatted_date }}</td>
                                        <td>
                                            <a href="{{ url('admin/payments/'.$payment->id) }}" class="btn btn-sm btn-info" title="View Details">
                                                <i class="fa fa-eye"></i>
                                            </a>
                                            @if(Auth::User()->usertype == "Admin")
                                                <button type="button" class="btn btn-sm btn-warning" data-toggle="modal" data-target="#updateStatus{{ $payment->id }}" title="Update Status">
                                                    <i class="fa fa-edit"></i>
                                                </button>
                                            @endif
                                        </td>
                                    </tr>

                                    <!-- Update Status Modal -->
                                    @if(Auth::User()->usertype == "Admin")
                                    <div class="modal fade" id="updateStatus{{ $payment->id }}" tabindex="-1" role="dialog">
                                        <div class="modal-dialog" role="document">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h4 class="modal-title">Update Payment Status</h4>
                                                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                                                </div>
                                                {{ html()->form('POST', url('/admin/payments/'.$payment->id.'/update-status'))
                                                   ->attributes(['class' => 'form-horizontal'])->open() }}
                                                <div class="modal-body">
                                                    <div class="form-group">
                                                        <label>Payment Status</label>
                                                        <select name="payment_status" class="form-control" required>
                                                            <option value="pending" @if($payment->payment_status == 'pending') selected @endif>Pending</option>
                                                            <option value="completed" @if($payment->payment_status == 'completed') selected @endif>Completed</option>
                                                            <option value="failed" @if($payment->payment_status == 'failed') selected @endif>Failed</option>
                                                            <option value="refunded" @if($payment->payment_status == 'refunded') selected @endif>Refunded</option>
                                                        </select>
                                                    </div>
                                                    <div class="form-group">
                                                        <label>Admin Notes</label>
                                                        <textarea name="notes" class="form-control" rows="3" placeholder="Add notes about this status change...">{{ $payment->notes }}</textarea>
                                                    </div>
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="submit" class="btn btn-primary">Update Status</button>
                                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                                                </div>
                                                {{ html()->form()->close() }}
                                            </div>
                                        </div>
                                    </div>
                                    @endif
                                    @endforeach
                                </tbody>
                            </table>
                        </div>

                        <nav class="paging_simple_numbers">
                            @include('admin.pagination', ['paginator' => $payments]) 
                        </nav>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @include("admin.copyright") 
</div>

<!-- Add Manual Payment Modal -->
@if(Auth::User()->usertype == "Admin")
<div class="modal fade" id="addManualPayment" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Add Manual Payment</h4>
                <button type="button" class="close" data-dismiss="modal">&times;</button>
            </div>
            {{ html()->form('POST', url('/admin/payments/manual'))
               ->attributes(['class' => 'form-horizontal'])->open() }}
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>User *</label>
                            <select name="user_id" class="form-control" required>
                                <option value="">Select User</option>
                                @foreach($users as $user)
                                    <option value="{{ $user->id }}">{{ $user->name }} ({{ $user->email }})</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Subscription Plan (Optional)</label>
                            <select name="plan_id" class="form-control">
                                <option value="">No Plan / Custom Payment</option>
                                @foreach(\App\SubscriptionPlan::where('status', '1')->get() as $plan)
                                    <option value="{{ $plan->id }}" data-price="{{ $plan->plan_price }}">{{ $plan->plan_name }} - {{html_entity_decode(getCurrencySymbols(getcong('currency_code')))}}{{ $plan->plan_price }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Payment Amount *</label>
                            <input type="number" name="payment_amount" class="form-control" step="0.01" min="0" required>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Payment Gateway *</label>
                            <select name="gateway" class="form-control" required>
                                <option value="">Select Gateway</option>
                                <option value="Manual">Manual</option>
                                <option value="Bank Transfer">Bank Transfer</option>
                                <option value="Cash">Cash</option>
                                @foreach($gateways as $gateway)
                                    <option value="{{ $gateway->gateway_name }}">{{ $gateway->gateway_name }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Payment ID/Reference *</label>
                            <input type="text" name="payment_id" class="form-control" placeholder="Enter payment reference" required>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Transaction Type</label>
                            <select name="transaction_type" class="form-control">
                                <option value="subscription">Subscription</option>
                                <option value="upgrade">Plan Upgrade</option>
                                <option value="renewal">Plan Renewal</option>
                                <option value="refund">Refund</option>
                                <option value="other">Other</option>
                            </select>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Payment Status</label>
                            <select name="payment_status" class="form-control">
                                <option value="completed">Completed</option>
                                <option value="pending">Pending</option>
                                <option value="failed">Failed</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Description</label>
                            <input type="text" name="description" class="form-control" placeholder="Payment description">
                        </div>
                    </div>
                </div>
                
                <div class="form-group">
                    <label>Admin Notes</label>
                    <textarea name="notes" class="form-control" rows="3" placeholder="Add any notes about this payment..."></textarea>
                </div>
            </div>
            <div class="modal-footer">
                <button type="submit" class="btn btn-primary">Add Payment</button>
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
            </div>
            {{ html()->form()->close() }}
        </div>
    </div>
</div>
@endif

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Auto-fill payment amount when plan is selected (optional)
    const planSelect = document.querySelector('#addManualPayment select[name="plan_id"]');
    const amountField = document.querySelector('#addManualPayment input[name="payment_amount"]');
    
    if (planSelect && amountField) {
        planSelect.addEventListener('change', function() {
            const selectedOption = this.options[this.selectedIndex];
            const price = selectedOption.getAttribute('data-price');
            
            if (price && !amountField.value) {
                amountField.value = price;
            }
        });
    }

    // Generate unique payment ID
    const paymentIdField = document.querySelector('#addManualPayment input[name="payment_id"]');
    if (paymentIdField) {
        document.querySelector('[data-target="#addManualPayment"]').addEventListener('click', function() {
            const timestamp = Date.now();
            const paymentId = 'MANUAL_' + timestamp;
            setTimeout(function() {
                paymentIdField.value = paymentId;
            }, 100);
        });
    }

    // Filter handlers
    document.getElementById('status_filter').addEventListener('change', function() {
        if (this.value) {
            window.location.href = this.value;
        } else {
            window.location.href = '{{ url("admin/payments") }}';
        }
    });

    document.getElementById('gateway_filter').addEventListener('change', function() {
        if (this.value) {
            window.location.href = this.value;
        } else {
            window.location.href = '{{ url("admin/payments") }}';
        }
    });

    // Date range filter
    const dateFrom = document.querySelector('input[name="date_from"]');
    const dateTo = document.querySelector('input[name="date_to"]');
    
    if (dateFrom && dateTo) {
        [dateFrom, dateTo].forEach(input => {
            input.addEventListener('change', function() {
                if (dateFrom.value && dateTo.value) {
                    const url = new URL(window.location.href);
                    url.searchParams.set('date_from', dateFrom.value);
                    url.searchParams.set('date_to', dateTo.value);
                    window.location.href = url.toString();
                }
            });
        });
    }
});
</script>

@endsection
