@extends("admin.admin_app")

@section("content")

<div class="content-page">
    <div class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-8">
                    <div class="card-box">
                        <h4 class="header-title mb-3">Payment Details #{{ $payment->id }}</h4>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <table class="table table-borderless">
                                    <tr>
                                        <td><strong>Payment ID:</strong></td>
                                        <td><code>{{ $payment->payment_id }}</code></td>
                                    </tr>
                                    <tr>
                                        <td><strong>Reference ID:</strong></td>
                                        <td>{{ $payment->reference_id ?: 'N/A' }}</td>
                                    </tr>
                                    <tr>
                                        <td><strong>Amount:</strong></td>
                                        <td><strong class="text-success">{{ $payment->formatted_amount }}</strong></td>
                                    </tr>
                                    <tr>
                                        <td><strong>Currency:</strong></td>
                                        <td>{{ $payment->currency }}</td>
                                    </tr>
                                    <tr>
                                        <td><strong>Gateway:</strong></td>
                                        <td><span class="badge badge-primary">{{ $payment->gateway }}</span></td>
                                    </tr>
                                    <tr>
                                        <td><strong>Status:</strong></td>
                                        <td><span class="badge {{ $payment->status_badge }}">{{ ucfirst($payment->payment_status) }}</span></td>
                                    </tr>
                                </table>
                            </div>
                            <div class="col-md-6">
                                <table class="table table-borderless">
                                    <tr>
                                        <td><strong>Transaction Type:</strong></td>
                                        <td>{{ ucfirst($payment->transaction_type) }}</td>
                                    </tr>
                                    <tr>
                                        <td><strong>Payment Date:</strong></td>
                                        <td>{{ $payment->formatted_date }}</td>
                                    </tr>
                                    <tr>
                                        <td><strong>IP Address:</strong></td>
                                        <td>{{ $payment->ip_address ?: 'N/A' }}</td>
                                    </tr>
                                    <tr>
                                        <td><strong>Created:</strong></td>
                                        <td>{{ $payment->created_at ? $payment->created_at->format('M d, Y h:i A') : 'N/A' }}</td>
                                    </tr>
                                    <tr>
                                        <td><strong>Updated:</strong></td>
                                        <td>{{ $payment->updated_at ? $payment->updated_at->format('M d, Y h:i A') : 'N/A' }}</td>
                                    </tr>
                                </table>
                            </div>
                        </div>

                        @if($payment->description)
                        <div class="mt-3">
                            <h5>Description</h5>
                            <p class="text-muted">{{ $payment->description }}</p>
                        </div>
                        @endif

                        @if($payment->notes)
                        <div class="mt-3">
                            <h5>Admin Notes</h5>
                            <div class="alert alert-info">{{ $payment->notes }}</div>
                        </div>
                        @endif

                        @if($payment->payment_details)
                        <div class="mt-3">
                            <h5>Payment Gateway Details</h5>
                            <pre class="bg-light p-3 rounded"><code>{{ json_encode($payment->payment_details, JSON_PRETTY_PRINT) }}</code></pre>
                        </div>
                        @endif
                    </div>
                </div>

                <div class="col-lg-4">
                    <!-- User Information -->
                    <div class="card-box">
                        <h4 class="header-title mb-3">User Information</h4>
                        @if($payment->user)
                        <div class="text-center mb-3">
                            @if($payment->user->user_image)
                                <img src="{{ URL::asset('upload/' . $payment->user->user_image) }}" class="rounded-circle" width="80" height="80">
                            @else
                                <img src="{{ URL::asset('admin_assets/images/user-default.png') }}" class="rounded-circle" width="80" height="80">
                            @endif
                        </div>
                        <table class="table table-borderless">
                            <tr>
                                <td><strong>Name:</strong></td>
                                <td>{{ $payment->user->name }}</td>
                            </tr>
                            <tr>
                                <td><strong>Email:</strong></td>
                                <td>{{ $payment->user->email }}</td>
                            </tr>
                            <tr>
                                <td><strong>Phone:</strong></td>
                                <td>{{ $payment->user->phone ?: 'N/A' }}</td>
                            </tr>
                            <tr>
                                <td><strong>Status:</strong></td>
                                <td>
                                    @if($payment->user->status == 1)
                                        <span class="badge badge-success">Active</span>
                                    @else
                                        <span class="badge badge-danger">Inactive</span>
                                    @endif
                                </td>
                            </tr>
                        </table>
                        <div class="text-center">
                            <a href="{{ url('admin/users/history/'.$payment->user->id) }}" class="btn btn-primary btn-sm">
                                <i class="fa fa-user"></i> View User Profile
                            </a>
                        </div>
                        @else
                        <p class="text-muted">User information not available</p>
                        @endif
                    </div>

                    <!-- Subscription Plan Information -->
                    @if($payment->subscriptionPlan)
                    <div class="card-box">
                        <h4 class="header-title mb-3">Subscription Plan</h4>
                        <table class="table table-borderless">
                            <tr>
                                <td><strong>Plan Name:</strong></td>
                                <td>{{ $payment->subscriptionPlan->plan_name }}</td>
                            </tr>
                            <tr>
                                <td><strong>Plan Price:</strong></td>
                                <td>{{html_entity_decode(getCurrencySymbols(getcong('currency_code')))}}{{ $payment->subscriptionPlan->plan_price }}</td>
                            </tr>
                            <tr>
                                <td><strong>Plan Duration:</strong></td>
                                <td>{{ $payment->subscriptionPlan->plan_days }} days</td>
                            </tr>
                        </table>
                    </div>
                    @endif

                    <!-- Quick Actions -->
                    @if(Auth::User()->usertype == "Admin")
                    <div class="card-box">
                        <h4 class="header-title mb-3">Quick Actions</h4>
                        <div class="d-grid gap-2">
                            <button type="button" class="btn btn-warning btn-block" data-toggle="modal" data-target="#updateStatusModal">
                                <i class="fa fa-edit"></i> Update Status
                            </button>
                            <a href="{{ url('admin/payments') }}" class="btn btn-secondary btn-block">
                                <i class="fa fa-arrow-left"></i> Back to Payments
                            </a>
                        </div>
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
    @include("admin.copyright") 
</div>

<!-- Update Status Modal -->
@if(Auth::User()->usertype == "Admin")
<div class="modal fade" id="updateStatusModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Update Payment Status</h4>
                <button type="button" class="close" data-dismiss="modal">&times;</button>
            </div>
            {{ html()->form('POST', url('/admin/payments/'.$payment->id.'/update-status'))
               ->attributes(['class' => 'form-horizontal'])->open() }}
            <div class="modal-body">
                <div class="form-group">
                    <label>Payment Status</label>
                    <select name="payment_status" class="form-control" required>
                        <option value="pending" @if($payment->payment_status == 'pending') selected @endif>Pending</option>
                        <option value="completed" @if($payment->payment_status == 'completed') selected @endif>Completed</option>
                        <option value="failed" @if($payment->payment_status == 'failed') selected @endif>Failed</option>
                        <option value="refunded" @if($payment->payment_status == 'refunded') selected @endif>Refunded</option>
                    </select>
                </div>
                <div class="form-group">
                    <label>Admin Notes</label>
                    <textarea name="notes" class="form-control" rows="4" placeholder="Add notes about this status change...">{{ $payment->notes }}</textarea>
                </div>
            </div>
            <div class="modal-footer">
                <button type="submit" class="btn btn-primary">Update Status</button>
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
            </div>
            {{ html()->form()->close() }}
        </div>
    </div>
</div>
@endif

@endsection
