@extends("admin.admin_app")

@section("content")

<div class="content-page">
    <div class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-sm-8">
                    <div class="bg-picture card-box">
                        <div class="p-t-10 pull-right">
                            @if($user->status == 1)
                                <span class="badge badge-success">{{trans('words.active')}}</span> 
                            @else
                                <span class="badge badge-danger">{{trans('words.inactive')}}</span>
                            @endif
                        </div>

                        <div class="profile-info-name">
                            @if($user->user_image)
                                <img src="{{ URL::asset('upload/' . $user->user_image) }}" class="img-thumbnail" alt="profile_img" style="width: 155px">
                            @else          
                                <img src="{{ URL::asset('admin_assets/images/user-default.png') }}" class="img-thumbnail" alt="profile_img" style="width: 155px">
                            @endif

                            <div class="profile-info-detail">
                                <h4 class="m-0">{{$user->name}}</h4>
                                <p class="text-muted m-b-20">
                                    <b>{{trans('words.email')}}:</b> {{$user->email}}
                                    <br /><b>{{trans('words.phone')}}:</b> {{$user->phone}}
                                </p>
                            </div>
                            <div class="clearfix"></div>
                        </div>
                    </div>
                </div>

                <div class="col-sm-4">
                    <div class="card-box">
                        <h4 class="header-title m-t-0 m-b-30">Payment Summary</h4>
                        <ul class="list-group m-b-0 user-list">
                            <li class="list-group-item">
                                <div class="user-desc">
                                    <span class="name">{{ $payments->where('payment_status', 'completed')->count() }}</span>
                                    <span class="desc">Completed Payments</span>
                                </div>
                            </li>
                            <li class="list-group-item">
                                <div class="user-desc">
                                    <span class="name">{{html_entity_decode(getCurrencySymbols(getcong('currency_code')))}}{{ number_format($payments->where('payment_status', 'completed')->sum('payment_amount'), 2) }}</span>
                                    <span class="desc">Total Paid</span>
                                </div>
                            </li>
                            <li class="list-group-item">
                                <div class="user-desc">
                                    <span class="name">{{\App\SubscriptionPlan::getSubscriptionPlanInfo($user->plan_id, 'plan_name')}}</span>
                                    <span class="desc">{{trans('words.current_plan')}}</span>
                                </div>
                            </li>
                            <li class="list-group-item">
                                <div class="user-desc">
                                    <span class="name">@if($user->exp_date){{date('F d, Y', $user->exp_date)}}@endif</span>
                                    <span class="desc">{{trans('words.subscription_expires_on')}}</span>
                                </div>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-sm-12">
                    <div class="card-box">
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <h4 class="header-title m-t-0 m-b-30">Payment History</h4>
                            </div>
                            <div class="col-md-6 text-right">
                                @if(Auth::User()->usertype == "Admin")
                                <button type="button" class="btn btn-success btn-sm" data-toggle="modal" data-target="#addManualPayment">
                                    <i class="fa fa-plus"></i> Add Manual Payment
                                </button>
                                @endif
                            </div>
                        </div>

                        @if(Session::has('flash_message'))
                            <div class="alert alert-success">
                                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                                {{ Session::get('flash_message') }}
                            </div>
                        @endif

                        <div class="table-responsive">
                            <table class="table table-bordered table-hover">
                                <thead>
                                    <tr>
                                        <th>ID</th>
                                        <th>Plan</th>
                                        <th>Amount</th>
                                        <th>Gateway</th>
                                        <th>Payment ID</th>
                                        <th>Status</th>
                                        <th>Type</th>
                                        <th>Date</th>
                                        <th>Actions</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($payments as $payment)
                                    <tr>
                                        <td>{{ $payment->id }}</td>
                                        <td>{{ $payment->subscriptionPlan ? $payment->subscriptionPlan->plan_name : 'N/A' }}</td>
                                        <td><strong>{{ $payment->formatted_amount }}</strong></td>
                                        <td><span class="badge badge-primary">{{ $payment->gateway }}</span></td>
                                        <td><code>{{ $payment->payment_id }}</code></td>
                                        <td><span class="badge {{ $payment->status_badge }}">{{ ucfirst($payment->payment_status) }}</span></td>
                                        <td>{{ ucfirst($payment->transaction_type) }}</td>
                                        <td>{{ $payment->formatted_date }}</td>
                                        <td>
                                            <a href="{{ url('admin/payments/'.$payment->id) }}" class="btn btn-sm btn-info" title="View Details">
                                                <i class="fa fa-eye"></i>
                                            </a>
                                            @if(Auth::User()->usertype == "Admin")
                                                <button type="button" class="btn btn-sm btn-warning" data-toggle="modal" data-target="#updateStatus{{ $payment->id }}" title="Update Status">
                                                    <i class="fa fa-edit"></i>
                                                </button>
                                            @endif
                                        </td>
                                    </tr>

                                    <!-- Update Status Modal -->
                                    @if(Auth::User()->usertype == "Admin")
                                    <div class="modal fade" id="updateStatus{{ $payment->id }}" tabindex="-1" role="dialog">
                                        <div class="modal-dialog" role="document">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h4 class="modal-title">Update Payment Status</h4>
                                                    <button type="button" class="close" data-dismiss="modal">&times;</button>
                                                </div>
                                                {{ html()->form('POST', url('/admin/payments/'.$payment->id.'/update-status'))
                                                   ->attributes(['class' => 'form-horizontal'])->open() }}
                                                <div class="modal-body">
                                                    <div class="form-group">
                                                        <label>Payment Status</label>
                                                        <select name="payment_status" class="form-control" required>
                                                            <option value="pending" @if($payment->payment_status == 'pending') selected @endif>Pending</option>
                                                            <option value="completed" @if($payment->payment_status == 'completed') selected @endif>Completed</option>
                                                            <option value="failed" @if($payment->payment_status == 'failed') selected @endif>Failed</option>
                                                            <option value="refunded" @if($payment->payment_status == 'refunded') selected @endif>Refunded</option>
                                                        </select>
                                                    </div>
                                                    <div class="form-group">
                                                        <label>Admin Notes</label>
                                                        <textarea name="notes" class="form-control" rows="3">{{ $payment->notes }}</textarea>
                                                    </div>
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="submit" class="btn btn-primary">Update</button>
                                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                                                </div>
                                                {{ html()->form()->close() }}
                                            </div>
                                        </div>
                                    </div>
                                    @endif
                                    @endforeach
                                </tbody>
                            </table>
                        </div>

                        <nav class="paging_simple_numbers">
                            @include('admin.pagination', ['paginator' => $payments]) 
                        </nav>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @include("admin.copyright") 
</div>

<!-- Add Manual Payment Modal -->
@if(Auth::User()->usertype == "Admin")
<div class="modal fade" id="addManualPayment" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Add Manual Payment for {{ $user->name }}</h4>
                <button type="button" class="close" data-dismiss="modal">&times;</button>
            </div>
            {{ html()->form('POST', url('/admin/payments/manual'))
               ->attributes(['class' => 'form-horizontal'])->open() }}
            <input type="hidden" name="user_id" value="{{ $user->id }}">
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Subscription Plan (Optional)</label>
                            <select name="plan_id" class="form-control">
                                <option value="">No Plan / Custom Payment</option>
                                @foreach(\App\SubscriptionPlan::where('status', '1')->get() as $plan)
                                    <option value="{{ $plan->id }}" data-price="{{ $plan->plan_price }}">{{ $plan->plan_name }} - {{html_entity_decode(getCurrencySymbols(getcong('currency_code')))}}{{ $plan->plan_price }}</option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Payment Amount *</label>
                            <input type="number" name="payment_amount" class="form-control" step="0.01" min="0" required>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Payment Gateway *</label>
                            <select name="gateway" class="form-control" required>
                                <option value="">Select Gateway</option>
                                <option value="Manual">Manual</option>
                                <option value="Bank Transfer">Bank Transfer</option>
                                <option value="Cash">Cash</option>
                                <option value="Check">Check</option>
                                <option value="PayPal">PayPal</option>
                                <option value="Stripe">Stripe</option>
                                <option value="Razorpay">Razorpay</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Payment ID/Reference *</label>
                            <input type="text" name="payment_id" class="form-control" placeholder="Enter payment reference" required>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Transaction Type</label>
                            <select name="transaction_type" class="form-control">
                                <option value="subscription">Subscription</option>
                                <option value="upgrade">Plan Upgrade</option>
                                <option value="renewal">Plan Renewal</option>
                                <option value="refund">Refund</option>
                                <option value="other">Other</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Payment Status</label>
                            <select name="payment_status" class="form-control">
                                <option value="completed">Completed</option>
                                <option value="pending">Pending</option>
                                <option value="failed">Failed</option>
                            </select>
                        </div>
                    </div>
                </div>
                
                <div class="form-group">
                    <label>Description</label>
                    <input type="text" name="description" class="form-control" placeholder="Payment description">
                </div>
                <div class="form-group">
                    <label>Admin Notes</label>
                    <textarea name="notes" class="form-control" rows="3" placeholder="Add any notes about this payment..."></textarea>
                </div>
            </div>
            <div class="modal-footer">
                <button type="submit" class="btn btn-primary">Add Payment</button>
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
            </div>
            {{ html()->form()->close() }}
        </div>
    </div>
</div>
@endif

@endsection
