@extends("admin.admin_app")

@section("content")

  
  <div class="content-page">
      <div class="content">
        <div class="container-fluid">
          <div class="row">
            <div class="col-12">
              <div class="card-box table-responsive">

                <div class="row">                  
                  <div class="col-md-3">
                      
                     {{ html()->form('GET', url('/admin/users'))
                     ->attributes(['class' => 'app-search', 'id' => 'search'])->open() }}  
                      <input type="text" name="s" placeholder="{{trans('words.search_by_name_email')}}" class="form-control">
                      <button type="submit"><i class="fa fa-search"></i></button>
                      {{ html()->form()->close() }}
                  </div>             
                <div class="col-md-3">
                  <a href="{{URL::to('admin/users/add')}}" class="btn btn-success btn-md waves-effect waves-light m-b-20 mt-2" data-toggle="tooltip" title="{{trans('words.add_user')}}"><i class="fa fa-plus"></i> {{trans('words.add_user')}}</a>
                </div>
                <div class="col-sm-3">
                      
                  </div>
                <div class="col-md-3">
                  <a href="{{URL::to('admin/users/export')}}" class="btn btn-info btn-md waves-effect waves-light m-b-20 mt-2 pull-right" data-toggle="tooltip" title="{{trans('words.export_user')}}"><i class="fa fa-file-excel-o"></i> {{trans('words.export_user')}}</a>
                </div>
              </div>

                @if(Session::has('flash_message'))
                    <div class="alert alert-success">
                    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                      <span aria-hidden="true">&times;</span></button>
                        {{ Session::get('flash_message') }}
                    </div>
                @endif
                <div class="table-responsive">
                <table class="table table-bordered">
                  <thead>
                    <tr>
                      <th>{{trans('words.name')}}</th>
                      <th>{{trans('words.email')}}</th>
                      <th>{{trans('words.phone')}}</th>
                      <th>{{trans('words.status')}}</th>                        
                      <th>{{trans('words.action')}}</th>
                    </tr>
                  </thead>
                  <tbody>
                   @foreach($user_list as $i => $user_data)
                    <tr id="post_id_{{$user_data->id}}">
                      <td>{{ $user_data->name }}</td>
                      <td>{{ $user_data->email }}</td>
                      <td>{{ $user_data->phone }}</td>
                      <td>@if($user_data->status==1)<span class="badge badge-success">{{trans('words.active')}}</span> @else<span class="badge badge-danger">{{trans('words.inactive')}}</span>@endif</td>
                      <td>
                        <a href="{{ url('admin/users/edit/'.$user_data->id) }}" class="btn btn-icon waves-effect waves-light btn-success m-b-5 m-r-5" data-toggle="tooltip" title="{{trans('words.edit')}}"> <i class="fa fa-edit"></i> </a>
                        <a href="{{ url('admin/payments/user/'.$user_data->id) }}" class="btn btn-icon waves-effect waves-light btn-info m-b-5 m-r-5" data-toggle="tooltip" title="Payment History"> <i class="fa fa-list-alt"></i> </a>
                        <button type="button" class="btn btn-icon waves-effect waves-light btn-primary m-b-5 m-r-5" data-toggle="modal" data-target="#createPayment{{$user_data->id}}" title="Create Payment Transaction"> <i class="fa fa-plus-circle"></i> </button>
                        <a href="javascript::" onclick="delete_fun('{{$user_data->id}}');" class="btn btn-icon waves-effect waves-light btn-danger m-b-5 data_remove" data-toggle="tooltip" title="{{trans('words.remove')}}"> <i class="fa fa-times"></i> </a>
                      </td>
                    </tr>
                   @endforeach
                     
                     
                     
                  </tbody>
                </table>
              </div>
                <nav class="paging_simple_numbers">
                @include('admin.pagination', ['paginator' => $user_list]) 
                </nav>
           
              </div>
            </div>
          </div>
        </div>
      </div>
      @include("admin.copyright") 
    </div>

<!-- Payment Creation Modals for each user -->
@foreach($user_list as $user_data)
<div class="modal fade" id="createPayment{{$user_data->id}}" tabindex="-1" role="dialog">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Create Payment for {{ $user_data->name }}</h4>
                <button type="button" class="close" data-dismiss="modal">&times;</button>
            </div>
            {{ html()->form('POST', url('/admin/users/create-payment'))
               ->attributes(['class' => 'form-horizontal'])->open() }}
            <input type="hidden" name="user_id" value="{{ $user_data->id }}">
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>User Information</label>
                            <div class="form-control-static">
                                <strong>{{ $user_data->name }}</strong><br>
                                <small class="text-muted">{{ $user_data->email }}</small>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Current Plan</label>
                            <div class="form-control-static">
                                <span class="badge badge-info">
                                    {{ \App\SubscriptionPlan::getSubscriptionPlanInfo($user_data->plan_id, 'plan_name') ?: 'No Plan' }}
                                </span>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Subscription Plan (Optional)</label>
                            <select name="plan_id" class="form-control">
                                <option value="">No Plan / Custom Payment</option>
                                @foreach(\App\SubscriptionPlan::where('status', '1')->get() as $plan)
                                    <option value="{{ $plan->id }}" data-price="{{ $plan->plan_price }}">
                                        {{ $plan->plan_name }} - {{html_entity_decode(getCurrencySymbols(getcong('currency_code')))}}{{ $plan->plan_price }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Payment Amount *</label>
                            <input type="number" name="payment_amount" class="form-control" step="0.01" min="0" placeholder="Enter amount" required>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Payment Gateway *</label>
                            <select name="gateway" class="form-control" required>
                                <option value="">Select Gateway</option>
                                <option value="Manual">Manual</option>
                                <option value="Bank Transfer">Bank Transfer</option>
                                <option value="Cash">Cash</option>
                                <option value="Check">Check</option>
                                <option value="PayPal">PayPal</option>
                                <option value="Stripe">Stripe</option>
                                <option value="Razorpay">Razorpay</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Payment ID/Reference *</label>
                            <input type="text" name="payment_id" class="form-control" placeholder="Enter payment reference" required>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Transaction Type</label>
                            <select name="transaction_type" class="form-control">
                                <option value="subscription">Subscription</option>
                                <option value="upgrade">Plan Upgrade</option>
                                <option value="renewal">Plan Renewal</option>
                                <option value="refund">Refund</option>
                                <option value="other">Other</option>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label>Payment Status</label>
                            <select name="payment_status" class="form-control">
                                <option value="completed">Completed</option>
                                <option value="pending">Pending</option>
                                <option value="failed">Failed</option>
                            </select>
                        </div>
                    </div>
                </div>
                
                <div class="form-group">
                    <label>Description</label>
                    <input type="text" name="description" class="form-control" placeholder="Payment description">
                </div>
                
                <div class="form-group">
                    <label>Admin Notes</label>
                    <textarea name="notes" class="form-control" rows="3" placeholder="Add any notes about this payment..."></textarea>
                </div>
            </div>
            <div class="modal-footer">
                <button type="submit" class="btn btn-primary">Create Payment</button>
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
            </div>
            {{ html()->form()->close() }}
        </div>
    </div>
</div>
@endforeach

<script src="{{ URL::asset('admin_assets/js/jquery.min.js') }}"></script>
 
 <!-- SweetAlert2 -->
 <script src="{{ URL::asset('admin_assets/js/sweetalert2@11.js') }}"></script>
  
 <script type="text/javascript">

// Auto-fill payment amount when plan is selected (optional)
$(document).on('change', 'select[name="plan_id"]', function() {
    var selectedOption = $(this).find('option:selected');
    var price = selectedOption.data('price');
    var modal = $(this).closest('.modal');
    var amountField = modal.find('input[name="payment_amount"]');
    
    if (price && !amountField.val()) {
        amountField.val(price);
    }
});

// Generate unique payment ID
$(document).on('click', '[data-target^="#createPayment"]', function() {
    var userId = $(this).data('target').replace('#createPayment', '');
    var timestamp = Date.now();
    var paymentId = 'PAY_' + userId + '_' + timestamp;
    
    setTimeout(function() {
        $($(this).data('target') + ' input[name="payment_id"]').val(paymentId);
    }.bind(this), 100);
});
 
 $(".data_remove").on('click', function () {      
  
  'use strict';    
   
   var post_id = $(this).data("id");
   var action_name='user_delete';
 
   Swal.fire({
     title: '{{trans('words.dlt_warning')}}',
   text: "{{trans('words.dlt_warning_text')}}",
   icon: 'warning',
   showCancelButton: true,
   confirmButtonColor: '#3085d6',
   cancelButtonColor: '#d33',
   confirmButtonText: '{{trans('words.dlt_confirm')}}',
   cancelButtonText: "{{trans('words.btn_cancel')}}",
   background:"#1a2234",
   color:"#fff"
 
 }).then((result) => {
  
     if(result.isConfirmed) { 
 
         $.ajax({
             type: 'post',
             url: "{{ URL::to('admin/ajax_delete') }}",
             dataType: 'json',
             data: {"_token": "{{ csrf_token() }}",id: post_id, action_for: action_name},
             success: function(res) {
 
               if(res.status=='1')
               {  
 
                   var selector = "#post_id_"+post_id;
                     $(selector ).fadeOut(1000);
                     setTimeout(function(){
                             $(selector ).remove()
                         }, 1000);
 
                   Swal.fire({
                     position: 'center',
                     icon: 'success',
                     title: '{{trans('words.deleted')}}!',
                     showConfirmButton: true,
                     confirmButtonColor: '#10c469',
                     background:"#1a2234",
                     color:"#fff"
                   })
                 
               } 
               else
               { 
                 Swal.fire({
                         position: 'center',
                         icon: 'error',
                         title: 'Something went wrong!',
                         showConfirmButton: true,
                         confirmButtonColor: '#10c469',
                         background:"#1a2234",
                         color:"#fff"
                        })
               }
               
             }
         });
     }
  
 })
 
 });
 
 </script>    
    

@endsection