@extends('site_app')

@section('head_title', getcong('site_name'))

@section('head_url', Request::url())
@section('content')
    @if (count($banners) > 0)
        <div class="hero-slider-wrap">
            <div class="swiper-container hero-swiper">
                <div class="swiper-wrapper">
                    @foreach ($banners as $banner)
                        @php
                            $bannerLink = $banner->redirect_url ?? '';
                            $isExternal = $bannerLink && Str::startsWith($bannerLink, ['http://', 'https://']);
                            $bg = asset($banner->image_path ?? '');

                            // Ensure we always have an array even if DB row still stores plain string
                            $desc = is_array($banner->description)
                                ? $banner->description
                                : (json_decode($banner->description ?? '[]', true) ?:
                                []);
                        @endphp

                        <div class="swiper-slide">
                            @if ($bannerLink)
                                <a href="{{ $isExternal ? $bannerLink : url($bannerLink) }}"
                                    @if ($isExternal) rel="noopener noreferrer" @endif class="banner-link">
                            @endif

                            <div class="hero vfx2 section-padding" style="background-image:url('{{ $bg }}')">
                                <div class="overlay"></div>
                                <div class="container vfx-posabs">
                                    <div class="row">
                                        <div class="col-md-10 offset-md-1">
                                            <div class="header-text vfx1">
                                                <p class="mb-12">{{ $desc['small_title'] ?? '' }}</p>
                                                <h1>{{ $desc['main_content'] ?? '' }}</h1>
                                                <p>{{ $desc['bottom_content'] ?? '' }}</p> {{-- typo fixed: bottom_content --}}
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            @if ($bannerLink)
                                </a>
                            @endif
                        </div>
                    @endforeach
                </div>
                <!-- Add Pagination -->
                <div class="swiper-pagination hero-swiper-pagination"></div>
                <!-- Add Navigation -->
                <div class="swiper-button-prev hero-swiper-prev"></div>
                <div class="swiper-button-next hero-swiper-next"></div>
            </div>
        </div>
    @endif
    <!-- Add banner Section -->
    @if (get_web_banner('home_top') != '')
        <div class="add_banner_section pb-0 mb-20">
            <div class="container">
                <div class="row">
                    <div class="col-md-12">
                        {!! stripslashes(get_web_banner('home_top')) !!}
                    </div>
                </div>
            </div>
        </div>
    @endif
    <!-- Add banner Section -->


    <!--search section starts-->
    <div class="container">
        <div class="row">
            <div class="col-md-12">


                {{ html()->form('GET', url('/properties/search'))->attributes(['class' => 'vfx_hero_form_area vfx2 filter listing-filter bg-cb', 'id' => 'search', 'role' => 'form', 'style' => 'max-width:1120px;margin:0 auto;'])->open() }}

                <div class="row justify-content-center align-items-center">
                    <div class="col-12">
                        <h3 class="text-center text-muted">Find your perfect <span class="text-danger">workspace</span> </h3>
                        <div class="vfx-type-tabs text-center mb-3">
                            <ul class="type-tabs-list"
                                style="list-style:none;padding:0;margin:0;display:inline-flex;flex-wrap:wrap;">
                                <li class="tab-item active" data-type-id=""
                                    style="padding:6px 14px;border-bottom:1px solid rgba(0,0,0,0.08);background:#fff;cursor:pointer;font-weight:600;color:#333;">
                                    All</li>
                                @foreach (\App\Type::where('status', 1)->orderby('type_name')->get() as $tab_type)
                                    <li class="tab-item" data-type-id="{{ $tab_type->id }}"
                                        style="padding:6px 14px;border-bottom:1px solid rgba(0,0,0,0.06);background:transparent;cursor:pointer;font-weight:600;color:#333;">
                                        {{ $tab_type->type_name }}</li>
                                @endforeach
                            </ul>
                        </div>
                    </div>
                    <div class="col-xl-4 col-lg-3 col-sm-12 pr-lg-0">
                        <div class="input-search">
                            <input type="text" name="search_text" id="search_text"
                                placeholder="{{ trans('words.search_by_title') }}">
                        </div>
                    </div>
                    <div class="col-xl-2 col-lg-3 col-sm-12 pr-lg-0">
                        <select name="purpose" class="vfx_hero_form_area_input vfx-custom-select-area">
                        </select>
                    </div>
                    <div class="col-xl-2 col-lg-3 col-sm-12 pr-lg-0" hidden>
                        <select name="type_id" class="vfx_hero_form_area_input vfx-custom-select-area">
                            <option value="">{{ trans('words.property_type') }}</option>
                            @foreach (\App\Type::where('status', 1)->orderby('type_name')->get() as $type_data)
                                <option value="{{ $type_data->id }}">{{ $type_data->type_name }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-xl-2 col-lg-3 col-sm-12 pr-lg-0">
                        <select name="location_id" class="vfx_hero_form_area_input vfx-custom-select-area">
                            <option value="">{{ trans('words.city') }}</option>
                            @foreach (\App\Location::where('status', 1)->orderby('name')->get() as $location_data)
                                <option value="{{ $location_data->id }}">{{ $location_data->name }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="col-xl-2 col-lg-3 col-sm-12">
                        <div class="submit_btn">
                            <button class="btn vfx3" type="submit">{{ trans('words.search_property') }}</button>
                        </div>
                    </div>
                </div>
                {{ html()->form()->close() }}
            </div>
        </div>
    </div>
    <!--search section ends-->

    <!--Latest Property Starts-->
    <div class="vfx-trending-places bg-cb pb-30 pt-20">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <div class="section-title vid-item-section mb-15">
                        <h2>{{ trans('words.latest_property') }}</h2>
                        <span class="view-more">
                            <a href="{{ URL::to('latest') }}" title="view all">{{ trans('words.view_all') }}<svg
                                    xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 512 512"
                                    style="vertical-align: text-top">
                                    <path fill="none" stroke="currentColor" stroke-linecap="round"
                                        stroke-linejoin="round" stroke-width="60" d="m184 112l144 144l-144 144"></path>
                                </svg></a>
                        </span>
                    </div>
                </div>
                <div class="swiper-container vfx-latest-property-wrap">
                    <div class="swiper-wrapper">

                        @foreach ($latest_list as $latest_data)
                            <div class="swiper-slide">
                                <div class="vfx-single-property-box-area">
                                    <div class="vfx-property-item"> <a class="vfx-property-img"
                                            href="{{ URL::to('properties/' . $latest_data->slug . '/' . $latest_data->id) }}"
                                            title="{{ stripslashes($latest_data->title) }}"><img
                                                src="{{ \URL::to('/' . $latest_data->image) }}" alt="image"
                                                title="image">
                                        </a>
                                        <ul class="vfx-feature-text">
                                            @if ($latest_data->purpose == 'Rent')
                                                <li class="feature_cb"><span>{{ trans('words.rent') }}</span></li>
                                            @else
                                                <li class="feature_or"><span>{{ trans('words.sale') }}</span></li>
                                            @endif
                                            @if ($latest_data->verified == 'YES')
                                                <li class="feature_cb verified_item"><i class="fa fa-check 1"
                                                        data-toggle="tooltip" data-placement="top" title=""
                                                        data-original-title="{{ trans('words.verified') }}"></i></li>
                                            @endif
                                        </ul>
                                        <div class="vfx-property-author-wrap">
                                            <p class="text-tlt">{{ $latest_data->types->type_name }}</p>
                                            <ul class="vfx-save-btn">

                                                <li data-toggle="tooltip" data-placement="top" title=""
                                                    data-original-title="Set Favourite"
                                                    class="favourite_property favourite_title_id{{ $latest_data->id }}"
                                                    data-id="{{ $latest_data->id }}">
                                                    @if (check_favourite('Property', $latest_data->id, isset(Auth::user()->id) ? Auth::user()->id : ''))
                                                        <a href="Javascript:void(0);" title="fav"><i
                                                                class="fa fa-heart favourite_icon_id{{ $latest_data->id }}"></i></a>
                                                    @else
                                                        <a href="Javascript:void(0);" title="fav"><i
                                                                class="fa fa-heart-o favourite_icon_id{{ $latest_data->id }}"></i></a>
                                                    @endif
                                                </li>

                                            </ul>
                                        </div>
                                    </div>
                                    <div class="vfx-property-title-box-area">
                                        <h4><a href="{{ URL::to('properties/' . $latest_data->slug . '/' . $latest_data->id) }}"
                                                title="{{ stripslashes($latest_data->title) }}">{{ Str::limit(stripslashes($latest_data->title), 30) }}</a>
                                        </h4>
                                        <div class="vfx-property-location"> <i class="fa fa-map-marker"></i>
                                            <p>
                                                @if (isset($latest_data->locations->name) and $latest_data->locations->name != '')
                                                    {{ $latest_data->locations->name }}
                                                @else
                                                    {{ Str::limit(stripslashes($latest_data->address), 40) }}
                                                @endif
                                            </p>
                                        </div>
                                        <div class="trending-bottom">
                                            <div class="trend-left float-left">
                                                <div class="vfx-property-author-wrap">
                                                    <a href="{{ URL::to('properties/owner/' . $latest_data->user_id) }}"
                                                        class="property-author" title="user profile">

                                                        @if ($latest_data->users->user_image)
                                                            <img src="{{ \URL::to('upload/' . $latest_data->users->user_image) }}"
                                                                alt="user_image"
                                                                title="{{ stripslashes($latest_data->title) }}">
                                                        @else
                                                            <img src="{{ \URL::to('site_assets/images/user-default.jpg') }}"
                                                                alt="user" title="title">
                                                        @endif

                                                        <span>{{ $latest_data->users->name }}</span>
                                                    </a>
                                                </div>
                                            </div>
                                            <a href="{{ URL::to('properties/' . $latest_data->slug . '/' . $latest_data->id) }}"
                                                class="vfx-trend-right float-right"
                                                title="{{ stripslashes($latest_data->title) }}">
                                                <div class="vfx-trend-open-price">
                                                    {{ html_entity_decode(getCurrencySymbols(getcong('currency_code'))) }}{{ number_format($latest_data->price) }}
                                                </div>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
                <div class="vfx-latest-property-pagination"></div>
            </div>
        </div>
    </div>
    <!--Latest Property Ends-->

    @if (count($trending_list) > 0)
        <!--Popular Property Starts-->
        <div class="vfx-trending-places our-story-bg-2 pb-30 mt-20">
            <div class="container">
                <div class="row">
                    <div class="col-md-12">
                        <div class="section-title vid-item-section mb-15">
                            <h2>{{ trans('words.high_demand_properties_heading') }}</h2>
                            <span class="view-more">
                                <a href="{{ URL::to('popular') }}" title="popular">{{ trans('words.view_all') }}<svg
                                        xmlns="http://www.w3.org/2000/svg" width="18" height="18"
                                        viewBox="0 0 512 512" style="vertical-align: text-top">
                                        <path fill="none" stroke="currentColor" stroke-linecap="round"
                                            stroke-linejoin="round" stroke-width="60" d="m184 112l144 144l-144 144">
                                        </path>
                                    </svg></a>
                            </span>
                        </div>
                    </div>
                    <div class="swiper-container vfx-popular-property-wrap">
                        <div class="swiper-wrapper">

                            @foreach ($trending_list as $trending_data)
                                @php
                                    $property_info = \App\Property::find($trending_data->post_id);
                                @endphp
                                <div class="swiper-slide">
                                    <div class="vfx-single-property-box-area">
                                        <div class="vfx-property-item"> <a class="vfx-property-img"
                                                href="{{ URL::to('properties/' . $property_info->slug . '/' . $property_info->id) }}"
                                                title="{{ stripslashes($property_info->title) }}"><img
                                                    src="{{ \URL::to('/' . $property_info->image) }}" alt="image"
                                                    title="image"> </a>
                                            <ul class="vfx-feature-text">
                                                @if ($property_info->purpose == 'Rent')
                                                    <li class="feature_cb"><span>{{ trans('words.rent') }}</span></li>
                                                @else
                                                    <li class="feature_or"><span>{{ trans('words.sale') }}</span></li>
                                                @endif

                                                @if ($property_info->verified == 'YES')
                                                    <li class="feature_cb verified_item"><i class="fa fa-check 1"
                                                            data-toggle="tooltip" data-placement="top" title=""
                                                            data-original-title="{{ trans('words.verified') }}"></i></li>
                                                @endif
                                            </ul>
                                            <div class="vfx-property-author-wrap">
                                                <p class="text-tlt">{{ $property_info->types->type_name }}</p>
                                                <ul class="vfx-save-btn">

                                                    <li data-toggle="tooltip" data-placement="top" title=""
                                                        data-original-title="Set Favourite"
                                                        class="favourite_property favourite_title_id{{ $property_info->id }}"
                                                        data-id="{{ $property_info->id }}">
                                                        @if (check_favourite('Property', $property_info->id, isset(Auth::user()->id) ? Auth::user()->id : ''))
                                                            <a href="Javascript:void(0);" title="view"><i
                                                                    class="fa fa-heart favourite_icon_id{{ $property_info->id }}"></i></a>
                                                        @else
                                                            <a href="Javascript:void(0);" title="view"><i
                                                                    class="fa fa-heart-o favourite_icon_id{{ $property_info->id }}"></i></a>
                                                        @endif
                                                    </li>

                                                </ul>
                                            </div>
                                        </div>
                                        <div class="vfx-property-title-box-area">
                                            <h4><a href="{{ URL::to('properties/' . $property_info->slug . '/' . $property_info->id) }}"
                                                    title="{{ stripslashes($property_info->title) }}">{{ Str::limit(stripslashes($property_info->title), 30) }}</a>
                                            </h4>
                                            <div class="vfx-property-location"> <i class="fa fa-map-marker"></i>
                                                <p>
                                                    @if (isset($property_info->locations->name) and $property_info->locations->name != '')
                                                        {{ $property_info->locations->name }}
                                                    @else
                                                        {{ Str::limit(stripslashes($property_info->address), 40) }}
                                                    @endif
                                                </p>
                                            </div>
                                            <div class="trending-bottom">
                                                <div class="trend-left float-left">
                                                    <div class="vfx-property-author-wrap">
                                                        <a href="{{ URL::to('properties/owner/' . $property_info->user_id) }}"
                                                            class="property-author">

                                                            @if ($property_info->users->user_image)
                                                                <img src="{{ \URL::to('upload/' . $property_info->users->user_image) }}"
                                                                    alt="user_image"
                                                                    title="{{ stripslashes($property_info->title) }}">
                                                            @else
                                                                <img src="{{ \URL::to('site_assets/images/user-default.jpg') }}"
                                                                    alt="user_image"
                                                                    title="{{ stripslashes($property_info->title) }}">
                                                            @endif

                                                            <span>{{ $property_info->users->name }}</span>
                                                        </a>
                                                    </div>
                                                </div>
                                                <a href="{{ URL::to('properties/' . $property_info->slug . '/' . $property_info->id) }}"
                                                    class="vfx-trend-right float-right"
                                                    title="{{ stripslashes($property_info->title) }}">
                                                    <div class="vfx-trend-open-price">
                                                        {{ html_entity_decode(getCurrencySymbols(getcong('currency_code'))) }}{{ number_format($property_info->price) }}
                                                    </div>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach


                        </div>
                    </div>
                    <div class="vfx-popular-property-pagination"></div>
                </div>
            </div>
        </div>
        <!--Popular Property Ends-->
    @endif

    @if (count($trending_list) > 0)
        <!--High-Demand Properties Starts-->
        <div class="vfx-trending-places bg-cb pb-30 pt-20">
            <div class="container">
                <div class="row">
                    <div class="col-md-12">
                        <div class="section-title vid-item-section mb-15">
                            <h2>{{ trans('words.trending_now') }}</h2>
                            <span class="view-more">
                                <a href="{{ URL::to('popular') }}" title="popular">{{ trans('words.view_all') }}<svg
                                        xmlns="http://www.w3.org/2000/svg" width="18" height="18"
                                        viewBox="0 0 512 512" style="vertical-align: text-top">
                                        <path fill="none" stroke="currentColor" stroke-linecap="round"
                                            stroke-linejoin="round" stroke-width="60" d="m184 112l144 144l-144 144">
                                        </path>
                                    </svg></a>
                            </span>
                        </div>
                    </div>
                    <div class="swiper-container vfx-popular-property-wrap">
                        <div class="swiper-wrapper">

                            @foreach ($trending_list as $trending_data)
                                @php
                                    $property_info = \App\Property::find($trending_data->post_id);
                                @endphp
                                <div class="swiper-slide">
                                    <div class="vfx-single-property-box-area">
                                        <div class="vfx-property-item"> <a class="vfx-property-img"
                                                href="{{ URL::to('properties/' . $property_info->slug . '/' . $property_info->id) }}"
                                                title="{{ stripslashes($property_info->title) }}"><img
                                                    src="{{ \URL::to('/' . $property_info->image) }}" alt="image"
                                                    title="image"> </a>
                                            <ul class="vfx-feature-text">
                                                @if ($property_info->purpose == 'Rent')
                                                    <li class="feature_cb"><span>{{ trans('words.rent') }}</span></li>
                                                @else
                                                    <li class="feature_or"><span>{{ trans('words.sale') }}</span></li>
                                                @endif

                                                @if ($property_info->verified == 'YES')
                                                    <li class="feature_cb verified_item"><i class="fa fa-check 1"
                                                            data-toggle="tooltip" data-placement="top" title=""
                                                            data-original-title="{{ trans('words.verified') }}"></i></li>
                                                @endif
                                            </ul>
                                            <div class="vfx-property-author-wrap">
                                                <p class="text-tlt">{{ $property_info->types->type_name }}</p>
                                                <ul class="vfx-save-btn">

                                                    <li data-toggle="tooltip" data-placement="top" title=""
                                                        data-original-title="Set Favourite"
                                                        class="favourite_property favourite_title_id{{ $property_info->id }}"
                                                        data-id="{{ $property_info->id }}">
                                                        @if (check_favourite('Property', $property_info->id, isset(Auth::user()->id) ? Auth::user()->id : ''))
                                                            <a href="Javascript:void(0);" title="view"><i
                                                                    class="fa fa-heart favourite_icon_id{{ $property_info->id }}"></i></a>
                                                        @else
                                                            <a href="Javascript:void(0);" title="view"><i
                                                                    class="fa fa-heart-o favourite_icon_id{{ $property_info->id }}"></i></a>
                                                        @endif
                                                    </li>

                                                </ul>
                                            </div>
                                        </div>
                                        <div class="vfx-property-title-box-area">
                                            <h4><a href="{{ URL::to('properties/' . $property_info->slug . '/' . $property_info->id) }}"
                                                    title="{{ stripslashes($property_info->title) }}">{{ Str::limit(stripslashes($property_info->title), 30) }}</a>
                                            </h4>
                                            <div class="vfx-property-location"> <i class="fa fa-map-marker"></i>
                                                <p>
                                                    @if (isset($property_info->locations->name) and $property_info->locations->name != '')
                                                        {{ $property_info->locations->name }}
                                                    @else
                                                        {{ Str::limit(stripslashes($property_info->address), 40) }}
                                                    @endif
                                                </p>
                                            </div>
                                            <div class="trending-bottom">
                                                <div class="trend-left float-left">
                                                    <div class="vfx-property-author-wrap">
                                                        <a href="{{ URL::to('properties/owner/' . $property_info->user_id) }}"
                                                            class="property-author">

                                                            @if ($property_info->users->user_image)
                                                                <img src="{{ \URL::to('upload/' . $property_info->users->user_image) }}"
                                                                    alt="user_image"
                                                                    title="{{ stripslashes($property_info->title) }}">
                                                            @else
                                                                <img src="{{ \URL::to('site_assets/images/user-default.jpg') }}"
                                                                    alt="user_image"
                                                                    title="{{ stripslashes($property_info->title) }}">
                                                            @endif

                                                            <span>{{ $property_info->users->name }}</span>
                                                        </a>
                                                    </div>
                                                </div>
                                                <a href="{{ URL::to('properties/' . $property_info->slug . '/' . $property_info->id) }}"
                                                    class="vfx-trend-right float-right"
                                                    title="{{ stripslashes($property_info->title) }}">
                                                    <div class="vfx-trend-open-price">
                                                        {{ html_entity_decode(getCurrencySymbols(getcong('currency_code'))) }}{{ number_format($property_info->price) }}
                                                    </div>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach


                        </div>
                    </div>
                    <div class="vfx-popular-property-pagination"></div>
                </div>
            </div>
        </div>
        <!--High-Demand Properties Ends-->
    @endif

    @if (count($trending_list) > 0)
        <!--Popular Property Starts-->
        <div class="vfx-trending-places our-story-bg-2 pb-30 mt-20">
            <div class="container">
                <div class="row">
                    <div class="col-md-12">
                        <div class="section-title vid-item-section mb-15">
                            <h2>Apartments for Sale & Rent</h2>
                            <span class="view-more">
                                <a href="{{ URL::to('popular') }}" title="popular">{{ trans('words.view_all') }}<svg
                                        xmlns="http://www.w3.org/2000/svg" width="18" height="18"
                                        viewBox="0 0 512 512" style="vertical-align: text-top">
                                        <path fill="none" stroke="currentColor" stroke-linecap="round"
                                            stroke-linejoin="round" stroke-width="60" d="m184 112l144 144l-144 144">
                                        </path>
                                    </svg></a>
                            </span>
                        </div>
                    </div>
                    <div class="swiper-container vfx-popular-property-wrap">
                        <div class="swiper-wrapper">

                            @foreach ($trending_list as $trending_data)
                                @php
                                    $property_info = \App\Property::find($trending_data->post_id);
                                @endphp
                                <div class="swiper-slide">
                                    <div class="vfx-single-property-box-area">
                                        <div class="vfx-property-item"> <a class="vfx-property-img"
                                                href="{{ URL::to('properties/' . $property_info->slug . '/' . $property_info->id) }}"
                                                title="{{ stripslashes($property_info->title) }}"><img
                                                    src="{{ \URL::to('/' . $property_info->image) }}" alt="image"
                                                    title="image"> </a>
                                            <ul class="vfx-feature-text">
                                                @if ($property_info->purpose == 'Rent')
                                                    <li class="feature_cb"><span>{{ trans('words.rent') }}</span></li>
                                                @else
                                                    <li class="feature_or"><span>{{ trans('words.sale') }}</span></li>
                                                @endif

                                                @if ($property_info->verified == 'YES')
                                                    <li class="feature_cb verified_item"><i class="fa fa-check 1"
                                                            data-toggle="tooltip" data-placement="top" title=""
                                                            data-original-title="{{ trans('words.verified') }}"></i></li>
                                                @endif
                                            </ul>
                                            <div class="vfx-property-author-wrap">
                                                <p class="text-tlt">{{ $property_info->types->type_name }}</p>
                                                <ul class="vfx-save-btn">

                                                    <li data-toggle="tooltip" data-placement="top" title=""
                                                        data-original-title="Set Favourite"
                                                        class="favourite_property favourite_title_id{{ $property_info->id }}"
                                                        data-id="{{ $property_info->id }}">
                                                        @if (check_favourite('Property', $property_info->id, isset(Auth::user()->id) ? Auth::user()->id : ''))
                                                            <a href="Javascript:void(0);" title="view"><i
                                                                    class="fa fa-heart favourite_icon_id{{ $property_info->id }}"></i></a>
                                                        @else
                                                            <a href="Javascript:void(0);" title="view"><i
                                                                    class="fa fa-heart-o favourite_icon_id{{ $property_info->id }}"></i></a>
                                                        @endif
                                                    </li>

                                                </ul>
                                            </div>
                                        </div>
                                        <div class="vfx-property-title-box-area">
                                            <h4><a href="{{ URL::to('properties/' . $property_info->slug . '/' . $property_info->id) }}"
                                                    title="{{ stripslashes($property_info->title) }}">{{ Str::limit(stripslashes($property_info->title), 30) }}</a>
                                            </h4>
                                            <div class="vfx-property-location"> <i class="fa fa-map-marker"></i>
                                                <p>
                                                    @if (isset($property_info->locations->name) and $property_info->locations->name != '')
                                                        {{ $property_info->locations->name }}
                                                    @else
                                                        {{ Str::limit(stripslashes($property_info->address), 40) }}
                                                    @endif
                                                </p>
                                            </div>
                                            <div class="trending-bottom">
                                                <div class="trend-left float-left">
                                                    <div class="vfx-property-author-wrap">
                                                        <a href="{{ URL::to('properties/owner/' . $property_info->user_id) }}"
                                                            class="property-author">

                                                            @if ($property_info->users->user_image)
                                                                <img src="{{ \URL::to('upload/' . $property_info->users->user_image) }}"
                                                                    alt="user_image"
                                                                    title="{{ stripslashes($property_info->title) }}">
                                                            @else
                                                                <img src="{{ \URL::to('site_assets/images/user-default.jpg') }}"
                                                                    alt="user_image"
                                                                    title="{{ stripslashes($property_info->title) }}">
                                                            @endif

                                                            <span>{{ $property_info->users->name }}</span>
                                                        </a>
                                                    </div>
                                                </div>
                                                <a href="{{ URL::to('properties/' . $property_info->slug . '/' . $property_info->id) }}"
                                                    class="vfx-trend-right float-right"
                                                    title="{{ stripslashes($property_info->title) }}">
                                                    <div class="vfx-trend-open-price">
                                                        {{ html_entity_decode(getCurrencySymbols(getcong('currency_code'))) }}{{ number_format($property_info->price) }}
                                                    </div>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach


                        </div>
                    </div>
                    <div class="vfx-popular-property-pagination"></div>
                </div>
            </div>
        </div>
        <!--Popular Property Ends-->
    @endif


    @if (count($trending_list) > 0)
        <!--High-Demand Properties Starts-->
        <div class="vfx-trending-places bg-cb pb-30 pt-20">
            <div class="container">
                <div class="row">
                    <div class="col-md-12">
                        <div class="section-title vid-item-section mb-15">
                            <h2>High-Demand Commercial Listings</h2>
                            <span class="view-more">
                                <a href="{{ URL::to('popular') }}" title="popular">{{ trans('words.view_all') }}<svg
                                        xmlns="http://www.w3.org/2000/svg" width="18" height="18"
                                        viewBox="0 0 512 512" style="vertical-align: text-top">
                                        <path fill="none" stroke="currentColor" stroke-linecap="round"
                                            stroke-linejoin="round" stroke-width="60" d="m184 112l144 144l-144 144">
                                        </path>
                                    </svg></a>
                            </span>
                        </div>
                    </div>
                    <div class="swiper-container vfx-popular-property-wrap">
                        <div class="swiper-wrapper">

                            @foreach ($trending_list as $trending_data)
                                @php
                                    $property_info = \App\Property::find($trending_data->post_id);
                                @endphp
                                <div class="swiper-slide">
                                    <div class="vfx-single-property-box-area">
                                        <div class="vfx-property-item"> <a class="vfx-property-img"
                                                href="{{ URL::to('properties/' . $property_info->slug . '/' . $property_info->id) }}"
                                                title="{{ stripslashes($property_info->title) }}"><img
                                                    src="{{ \URL::to('/' . $property_info->image) }}" alt="image"
                                                    title="image"> </a>
                                            <ul class="vfx-feature-text">
                                                @if ($property_info->purpose == 'Rent')
                                                    <li class="feature_cb"><span>{{ trans('words.rent') }}</span></li>
                                                @else
                                                    <li class="feature_or"><span>{{ trans('words.sale') }}</span></li>
                                                @endif

                                                @if ($property_info->verified == 'YES')
                                                    <li class="feature_cb verified_item"><i class="fa fa-check 1"
                                                            data-toggle="tooltip" data-placement="top" title=""
                                                            data-original-title="{{ trans('words.verified') }}"></i></li>
                                                @endif
                                            </ul>
                                            <div class="vfx-property-author-wrap">
                                                <p class="text-tlt">{{ $property_info->types->type_name }}</p>
                                                <ul class="vfx-save-btn">

                                                    <li data-toggle="tooltip" data-placement="top" title=""
                                                        data-original-title="Set Favourite"
                                                        class="favourite_property favourite_title_id{{ $property_info->id }}"
                                                        data-id="{{ $property_info->id }}">
                                                        @if (check_favourite('Property', $property_info->id, isset(Auth::user()->id) ? Auth::user()->id : ''))
                                                            <a href="Javascript:void(0);" title="view"><i
                                                                    class="fa fa-heart favourite_icon_id{{ $property_info->id }}"></i></a>
                                                        @else
                                                            <a href="Javascript:void(0);" title="view"><i
                                                                    class="fa fa-heart-o favourite_icon_id{{ $property_info->id }}"></i></a>
                                                        @endif
                                                    </li>

                                                </ul>
                                            </div>
                                        </div>
                                        <div class="vfx-property-title-box-area">
                                            <h4><a href="{{ URL::to('properties/' . $property_info->slug . '/' . $property_info->id) }}"
                                                    title="{{ stripslashes($property_info->title) }}">{{ Str::limit(stripslashes($property_info->title), 30) }}</a>
                                            </h4>
                                            <div class="vfx-property-location"> <i class="fa fa-map-marker"></i>
                                                <p>
                                                    @if (isset($property_info->locations->name) and $property_info->locations->name != '')
                                                        {{ $property_info->locations->name }}
                                                    @else
                                                        {{ Str::limit(stripslashes($property_info->address), 40) }}
                                                    @endif
                                                </p>
                                            </div>
                                            <div class="trending-bottom">
                                                <div class="trend-left float-left">
                                                    <div class="vfx-property-author-wrap">
                                                        <a href="{{ URL::to('properties/owner/' . $property_info->user_id) }}"
                                                            class="property-author">

                                                            @if ($property_info->users->user_image)
                                                                <img src="{{ \URL::to('upload/' . $property_info->users->user_image) }}"
                                                                    alt="user_image"
                                                                    title="{{ stripslashes($property_info->title) }}">
                                                            @else
                                                                <img src="{{ \URL::to('site_assets/images/user-default.jpg') }}"
                                                                    alt="user_image"
                                                                    title="{{ stripslashes($property_info->title) }}">
                                                            @endif

                                                            <span>{{ $property_info->users->name }}</span>
                                                        </a>
                                                    </div>
                                                </div>
                                                <a href="{{ URL::to('properties/' . $property_info->slug . '/' . $property_info->id) }}"
                                                    class="vfx-trend-right float-right"
                                                    title="{{ stripslashes($property_info->title) }}">
                                                    <div class="vfx-trend-open-price">
                                                        {{ html_entity_decode(getCurrencySymbols(getcong('currency_code'))) }}{{ number_format($property_info->price) }}
                                                    </div>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach


                        </div>
                    </div>
                    <div class="vfx-popular-property-pagination"></div>
                </div>
            </div>
        </div>
        <!--High-Demand Properties Ends-->
    @endif

    @if (count($trending_list) > 0)
        <!--Popular Property Starts-->
        <div class="vfx-trending-places our-story-bg-2 pb-30 mt-20">
            <div class="container">
                <div class="row">
                    <div class="col-md-12">
                        <div class="section-title vid-item-section mb-15">
                            <h2>Most Searched Properties</h2>
                            <span class="view-more">
                                <a href="{{ URL::to('popular') }}" title="popular">{{ trans('words.view_all') }}<svg
                                        xmlns="http://www.w3.org/2000/svg" width="18" height="18"
                                        viewBox="0 0 512 512" style="vertical-align: text-top">
                                        <path fill="none" stroke="currentColor" stroke-linecap="round"
                                            stroke-linejoin="round" stroke-width="60" d="m184 112l144 144l-144 144">
                                        </path>
                                    </svg></a>
                            </span>
                        </div>
                    </div>
                    <div class="swiper-container vfx-popular-property-wrap">
                        <div class="swiper-wrapper">

                            @foreach ($trending_list as $trending_data)
                                @php
                                    $property_info = \App\Property::find($trending_data->post_id);
                                @endphp
                                <div class="swiper-slide">
                                    <div class="vfx-single-property-box-area">
                                        <div class="vfx-property-item"> <a class="vfx-property-img"
                                                href="{{ URL::to('properties/' . $property_info->slug . '/' . $property_info->id) }}"
                                                title="{{ stripslashes($property_info->title) }}"><img
                                                    src="{{ \URL::to('/' . $property_info->image) }}" alt="image"
                                                    title="image"> </a>
                                            <ul class="vfx-feature-text">
                                                @if ($property_info->purpose == 'Rent')
                                                    <li class="feature_cb"><span>{{ trans('words.rent') }}</span></li>
                                                @else
                                                    <li class="feature_or"><span>{{ trans('words.sale') }}</span></li>
                                                @endif

                                                @if ($property_info->verified == 'YES')
                                                    <li class="feature_cb verified_item"><i class="fa fa-check 1"
                                                            data-toggle="tooltip" data-placement="top" title=""
                                                            data-original-title="{{ trans('words.verified') }}"></i></li>
                                                @endif
                                            </ul>
                                            <div class="vfx-property-author-wrap">
                                                <p class="text-tlt">{{ $property_info->types->type_name }}</p>
                                                <ul class="vfx-save-btn">

                                                    <li data-toggle="tooltip" data-placement="top" title=""
                                                        data-original-title="Set Favourite"
                                                        class="favourite_property favourite_title_id{{ $property_info->id }}"
                                                        data-id="{{ $property_info->id }}">
                                                        @if (check_favourite('Property', $property_info->id, isset(Auth::user()->id) ? Auth::user()->id : ''))
                                                            <a href="Javascript:void(0);" title="view"><i
                                                                    class="fa fa-heart favourite_icon_id{{ $property_info->id }}"></i></a>
                                                        @else
                                                            <a href="Javascript:void(0);" title="view"><i
                                                                    class="fa fa-heart-o favourite_icon_id{{ $property_info->id }}"></i></a>
                                                        @endif
                                                    </li>

                                                </ul>
                                            </div>
                                        </div>
                                        <div class="vfx-property-title-box-area">
                                            <h4><a href="{{ URL::to('properties/' . $property_info->slug . '/' . $property_info->id) }}"
                                                    title="{{ stripslashes($property_info->title) }}">{{ Str::limit(stripslashes($property_info->title), 30) }}</a>
                                            </h4>
                                            <div class="vfx-property-location"> <i class="fa fa-map-marker"></i>
                                                <p>
                                                    @if (isset($property_info->locations->name) and $property_info->locations->name != '')
                                                        {{ $property_info->locations->name }}
                                                    @else
                                                        {{ Str::limit(stripslashes($property_info->address), 40) }}
                                                    @endif
                                                </p>
                                            </div>
                                            <div class="trending-bottom">
                                                <div class="trend-left float-left">
                                                    <div class="vfx-property-author-wrap">
                                                        <a href="{{ URL::to('properties/owner/' . $property_info->user_id) }}"
                                                            class="property-author">

                                                            @if ($property_info->users->user_image)
                                                                <img src="{{ \URL::to('upload/' . $property_info->users->user_image) }}"
                                                                    alt="user_image"
                                                                    title="{{ stripslashes($property_info->title) }}">
                                                            @else
                                                                <img src="{{ \URL::to('site_assets/images/user-default.jpg') }}"
                                                                    alt="user_image"
                                                                    title="{{ stripslashes($property_info->title) }}">
                                                            @endif

                                                            <span>{{ $property_info->users->name }}</span>
                                                        </a>
                                                    </div>
                                                </div>
                                                <a href="{{ URL::to('properties/' . $property_info->slug . '/' . $property_info->id) }}"
                                                    class="vfx-trend-right float-right"
                                                    title="{{ stripslashes($property_info->title) }}">
                                                    <div class="vfx-trend-open-price">
                                                        {{ html_entity_decode(getCurrencySymbols(getcong('currency_code'))) }}{{ number_format($property_info->price) }}
                                                    </div>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach


                        </div>
                    </div>
                    <div class="vfx-popular-property-pagination"></div>
                </div>
            </div>
        </div>
        <!--Popular Property Ends-->
    @endif

    <!-- Add banner Section -->
    @if (get_web_banner('home_bottom') != '')
        <div class="add_banner_section pt-0">
            <div class="container">
                <div class="row">
                    <div class="col-md-12">
                        {!! stripslashes(get_web_banner('home_bottom')) !!}
                    </div>
                </div>
            </div>
        </div>
    @endif

    <span class="vfx-scroll-top-btn"><i class="lnr lnr-arrow-up"></i></span>


    <!--Page Wrapper ends-->
@endsection

@push('scripts')
    <script>
        // Initialize hero Swiper autoplay slider
        document.addEventListener('DOMContentLoaded', function() {
            'use strict';
            if (typeof Swiper !== 'undefined' && document.querySelector('.hero-swiper')) {
                new Swiper('.hero-swiper', {
                    loop: true,
                    autoplay: {
                        delay: 5000,
                        disableOnInteraction: false,
                    },
                    effect: 'fade',
                    fadeEffect: {
                        crossFade: true
                    },
                    pagination: {
                        el: '.hero-swiper-pagination',
                        clickable: true,
                    },
                    navigation: {
                        nextEl: '.hero-swiper-next',
                        prevEl: '.hero-swiper-prev',
                    },
                    speed: 800,
                    allowTouchMove: true
                });
            }
        });

        document.addEventListener('DOMContentLoaded', function() {
            // Type tabs: clicking a tab sets the type_id value (supports select or hidden input)
            var tabs = document.querySelectorAll('.vfx-type-tabs .tab-item');
            var typeSelect = document.querySelector('select[name="type_id"]');
            var typeInput = document.querySelector('input[name="type_id"]');
            var $typeSelect = (window.jQuery && typeSelect) ? jQuery(typeSelect) : null;
            // purpose select
            var purposeSelect = document.querySelector('select[name="purpose"]');
            var $purposeSelect = (window.jQuery && purposeSelect) ? jQuery(purposeSelect) : null;
            // URL to fetch purpose list (server route)
            var getPurposeUrl = "{{ url('/properties/get-purpose-list') }}";

            if (tabs.length && (typeSelect || typeInput)) {
                tabs.forEach(function(tab) {
                    tab.addEventListener('click', function() {
                        tabs.forEach(function(t) {
                            t.classList.remove('active');
                            t.style.background = 'transparent';
                            t.style.color = '#333';
                        });
                        tab.classList.add('active');
                        tab.style.background = '#f7f7f7';
                        tab.style.color = '#d8232a';
                        var id = tab.getAttribute('data-type-id') || '';

                        if (typeSelect) {
                            // set native select value and notify plugin
                            try {
                                typeSelect.value = id;
                                if ($typeSelect && typeof $typeSelect.niceSelect === 'function') {
                                    $typeSelect.val(id);
                                    $typeSelect.trigger('change');
                                    // refresh the nice-select display
                                    $typeSelect.niceSelect('update');
                                } else {
                                    // dispatch change event for vanilla listeners
                                    var evt = new Event('change', {
                                        bubbles: true
                                    });
                                    typeSelect.dispatchEvent(evt);
                                }
                            } catch (e) {
                                console.error(e);
                            }
                            // After setting the type, fetch purpose options for this type and update the purpose select
                            try {
                                if (purposeSelect && getPurposeUrl) {
                                    // preserve a default placeholder
                                    var placeholder = '<option value="">Select Purpose</option>';

                                    // helper: build unique options from an array of items
                                    function buildUniqueOptions(items, includePlaceholder) {
                                        var seen = {};
                                        var html = includePlaceholder ? placeholder : '';
                                        items.forEach(function(it) {
                                            var value = (it && (it.value || it.id)) || it ||
                                                '';
                                            var label = (it && (it.label || it.name || it
                                                .text)) || it || '';
                                            var key = String(value);
                                            if (!seen[key]) {
                                                seen[key] = true;
                                                html += '<option value="' + value + '">' +
                                                    label + '</option>';
                                            }
                                        });
                                        return html;
                                    }

                                    // helper: parse HTML <option> string into array of {value,label}
                                    function parseOptionsHtml(html) {
                                        var tmp = document.createElement('div');
                                        tmp.innerHTML = '<select>' + html + '</select>';
                                        var opts = tmp.querySelectorAll('option');
                                        var arr = [];
                                        opts.forEach(function(o) {
                                            arr.push({
                                                value: o.value,
                                                label: o.textContent
                                            });
                                        });
                                        return arr;
                                    }

                                    // helper: apply options and reinit nice-select safely
                                    function applyPurposeOptionsFromArray(arr, keepPlaceholder) {
                                        var html = buildUniqueOptions(arr, keepPlaceholder);
                                        purposeSelect.innerHTML = html;
                                        if ($purposeSelect && typeof $purposeSelect.niceSelect ===
                                            'function') {
                                            try {
                                                var $pwrap = $purposeSelect.next('.nice-select');
                                                if ($pwrap.length) {
                                                    $pwrap.remove();
                                                }
                                                $purposeSelect.css('display', '');
                                                $purposeSelect.niceSelect();
                                            } catch (err) {
                                                /* ignore */
                                            }
                                        }
                                    }

                                    // Use jQuery if available
                                    if (window.jQuery) {
                                        jQuery.get(getPurposeUrl, {
                                            type_id: id
                                        }, function(resp) {
                                            if (Array.isArray(resp)) {
                                                applyPurposeOptionsFromArray(resp, true);
                                            } else if (typeof resp === 'string') {
                                                if (resp.indexOf('<option') !== -1) {
                                                    var arr = parseOptionsHtml(resp);
                                                    applyPurposeOptionsFromArray(arr,
                                                        false);
                                                } else {
                                                    // plain string -> treat as single option
                                                    applyPurposeOptionsFromArray([resp],
                                                        true);
                                                }
                                            } else {
                                                // fallback
                                                purposeSelect.innerHTML = placeholder;
                                                if ($purposeSelect && typeof $purposeSelect
                                                    .niceSelect === 'function') {
                                                    try {
                                                        $purposeSelect.next('.nice-select')
                                                            .remove();
                                                        $purposeSelect.css('display', '');
                                                        $purposeSelect.niceSelect();
                                                    } catch (e) {}
                                                }
                                            }
                                        }, 'json').fail(function(xhr) {
                                            var txt = xhr.responseText || '';
                                            if (txt.indexOf('<option') !== -1) {
                                                var arr = parseOptionsHtml(txt);
                                                applyPurposeOptionsFromArray(arr, false);
                                            }
                                        });
                                    } else {
                                        // fetch fallback
                                        fetch(getPurposeUrl + '?type_id=' + encodeURIComponent(id))
                                            .then(function(r) {
                                                return r.text();
                                            })
                                            .then(function(text) {
                                                if (text.indexOf('<option') !== -1) {
                                                    var arr = parseOptionsHtml(text);
                                                    applyPurposeOptionsFromArray(arr, false);
                                                } else {
                                                    try {
                                                        var j = JSON.parse(text);
                                                        if (Array.isArray(j)) {
                                                            applyPurposeOptionsFromArray(j,
                                                                true);
                                                        } else {
                                                            purposeSelect.innerHTML =
                                                                placeholder;
                                                        }
                                                    } catch (e) {
                                                        purposeSelect.innerHTML = placeholder;
                                                    }
                                                }
                                            }).catch(function() {
                                                /* noop */
                                            });
                                    }
                                }
                            } catch (ee) {
                                console.error(ee);
                            }
                        } else if (typeInput) {
                            typeInput.value = id;
                        }
                    });
                });

                // initialize active from select/input value
                var current = (typeSelect && typeSelect.value) || (typeInput && typeInput.value) || '';
                var activeTab = document.querySelector('.vfx-type-tabs .tab-item[data-type-id="' + current + '"]');
                if (activeTab) {
                    tabs.forEach(function(t) {
                        t.classList.remove('active');
                        t.style.background = 'transparent';
                        t.style.color = '#333';
                    });
                    activeTab.classList.add('active');
                    activeTab.style.background = '#f7f7f7';
                    activeTab.style.color = '#d8232a';
                    // trigger click to load purpose options for the active tab on page load
                    try {
                        activeTab.click();
                    } catch (e) {
                        /* ignore */ }
                } else {
                    // no active tab found - load for first tab
                    try {
                        if (tabs[0]) tabs[0].click();
                    } catch (e) {
                        /* ignore */ }
                }
            }
        });
    </script>
@endpush
