<?php $__env->startSection("content"); ?>

<div class="content-page">
    <div class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-8">
                    <div class="card-box">
                        <h4 class="header-title mb-3">Payment Details #<?php echo e($payment->id); ?></h4>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <table class="table table-borderless">
                                    <tr>
                                        <td><strong>Payment ID:</strong></td>
                                        <td><code><?php echo e($payment->payment_id); ?></code></td>
                                    </tr>
                                    <tr>
                                        <td><strong>Reference ID:</strong></td>
                                        <td><?php echo e($payment->reference_id ?: 'N/A'); ?></td>
                                    </tr>
                                    <tr>
                                        <td><strong>Amount:</strong></td>
                                        <td><strong class="text-success"><?php echo e($payment->formatted_amount); ?></strong></td>
                                    </tr>
                                    <tr>
                                        <td><strong>Currency:</strong></td>
                                        <td><?php echo e($payment->currency); ?></td>
                                    </tr>
                                    <tr>
                                        <td><strong>Gateway:</strong></td>
                                        <td><span class="badge badge-primary"><?php echo e($payment->gateway); ?></span></td>
                                    </tr>
                                    <tr>
                                        <td><strong>Status:</strong></td>
                                        <td><span class="badge <?php echo e($payment->status_badge); ?>"><?php echo e(ucfirst($payment->payment_status)); ?></span></td>
                                    </tr>
                                </table>
                            </div>
                            <div class="col-md-6">
                                <table class="table table-borderless">
                                    <tr>
                                        <td><strong>Transaction Type:</strong></td>
                                        <td><?php echo e(ucfirst($payment->transaction_type)); ?></td>
                                    </tr>
                                    <tr>
                                        <td><strong>Payment Date:</strong></td>
                                        <td><?php echo e($payment->formatted_date); ?></td>
                                    </tr>
                                    <tr>
                                        <td><strong>IP Address:</strong></td>
                                        <td><?php echo e($payment->ip_address ?: 'N/A'); ?></td>
                                    </tr>
                                    <tr>
                                        <td><strong>Created:</strong></td>
                                        <td><?php echo e($payment->created_at ? $payment->created_at->format('M d, Y h:i A') : 'N/A'); ?></td>
                                    </tr>
                                    <tr>
                                        <td><strong>Updated:</strong></td>
                                        <td><?php echo e($payment->updated_at ? $payment->updated_at->format('M d, Y h:i A') : 'N/A'); ?></td>
                                    </tr>
                                </table>
                            </div>
                        </div>

                        <?php if($payment->description): ?>
                        <div class="mt-3">
                            <h5>Description</h5>
                            <p class="text-muted"><?php echo e($payment->description); ?></p>
                        </div>
                        <?php endif; ?>

                        <?php if($payment->notes): ?>
                        <div class="mt-3">
                            <h5>Admin Notes</h5>
                            <div class="alert alert-info"><?php echo e($payment->notes); ?></div>
                        </div>
                        <?php endif; ?>

                        <?php if($payment->payment_details): ?>
                        <div class="mt-3">
                            <h5>Payment Gateway Details</h5>
                            <pre class="bg-light p-3 rounded"><code><?php echo e(json_encode($payment->payment_details, JSON_PRETTY_PRINT)); ?></code></pre>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>

                <div class="col-lg-4">
                    <!-- User Information -->
                    <div class="card-box">
                        <h4 class="header-title mb-3">User Information</h4>
                        <?php if($payment->user): ?>
                        <div class="text-center mb-3">
                            <?php if($payment->user->user_image): ?>
                                <img src="<?php echo e(URL::asset('upload/' . $payment->user->user_image)); ?>" class="rounded-circle" width="80" height="80">
                            <?php else: ?>
                                <img src="<?php echo e(URL::asset('admin_assets/images/user-default.png')); ?>" class="rounded-circle" width="80" height="80">
                            <?php endif; ?>
                        </div>
                        <table class="table table-borderless">
                            <tr>
                                <td><strong>Name:</strong></td>
                                <td><?php echo e($payment->user->name); ?></td>
                            </tr>
                            <tr>
                                <td><strong>Email:</strong></td>
                                <td><?php echo e($payment->user->email); ?></td>
                            </tr>
                            <tr>
                                <td><strong>Phone:</strong></td>
                                <td><?php echo e($payment->user->phone ?: 'N/A'); ?></td>
                            </tr>
                            <tr>
                                <td><strong>Status:</strong></td>
                                <td>
                                    <?php if($payment->user->status == 1): ?>
                                        <span class="badge badge-success">Active</span>
                                    <?php else: ?>
                                        <span class="badge badge-danger">Inactive</span>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        </table>
                        <div class="text-center">
                            <a href="<?php echo e(url('admin/users/history/'.$payment->user->id)); ?>" class="btn btn-primary btn-sm">
                                <i class="fa fa-user"></i> View User Profile
                            </a>
                        </div>
                        <?php else: ?>
                        <p class="text-muted">User information not available</p>
                        <?php endif; ?>
                    </div>

                    <!-- Subscription Plan Information -->
                    <?php if($payment->subscriptionPlan): ?>
                    <div class="card-box">
                        <h4 class="header-title mb-3">Subscription Plan</h4>
                        <table class="table table-borderless">
                            <tr>
                                <td><strong>Plan Name:</strong></td>
                                <td><?php echo e($payment->subscriptionPlan->plan_name); ?></td>
                            </tr>
                            <tr>
                                <td><strong>Plan Price:</strong></td>
                                <td><?php echo e(html_entity_decode(getCurrencySymbols(getcong('currency_code')))); ?><?php echo e($payment->subscriptionPlan->plan_price); ?></td>
                            </tr>
                            <tr>
                                <td><strong>Plan Duration:</strong></td>
                                <td><?php echo e($payment->subscriptionPlan->plan_days); ?> days</td>
                            </tr>
                        </table>
                    </div>
                    <?php endif; ?>

                    <!-- Quick Actions -->
                    <?php if(Auth::User()->usertype == "Admin"): ?>
                    <div class="card-box">
                        <h4 class="header-title mb-3">Quick Actions</h4>
                        <div class="d-grid gap-2">
                            <button type="button" class="btn btn-warning btn-block" data-toggle="modal" data-target="#updateStatusModal">
                                <i class="fa fa-edit"></i> Update Status
                            </button>
                            <a href="<?php echo e(url('admin/payments')); ?>" class="btn btn-secondary btn-block">
                                <i class="fa fa-arrow-left"></i> Back to Payments
                            </a>
                        </div>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
    <?php echo $__env->make("admin.copyright", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?> 
</div>

<!-- Update Status Modal -->
<?php if(Auth::User()->usertype == "Admin"): ?>
<div class="modal fade" id="updateStatusModal" tabindex="-1" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h4 class="modal-title">Update Payment Status</h4>
                <button type="button" class="close" data-dismiss="modal">&times;</button>
            </div>
            <?php echo e(html()->form('POST', url('/admin/payments/'.$payment->id.'/update-status'))
               ->attributes(['class' => 'form-horizontal'])->open()); ?>

            <div class="modal-body">
                <div class="form-group">
                    <label>Payment Status</label>
                    <select name="payment_status" class="form-control" required>
                        <option value="pending" <?php if($payment->payment_status == 'pending'): ?> selected <?php endif; ?>>Pending</option>
                        <option value="completed" <?php if($payment->payment_status == 'completed'): ?> selected <?php endif; ?>>Completed</option>
                        <option value="failed" <?php if($payment->payment_status == 'failed'): ?> selected <?php endif; ?>>Failed</option>
                        <option value="refunded" <?php if($payment->payment_status == 'refunded'): ?> selected <?php endif; ?>>Refunded</option>
                    </select>
                </div>
                <div class="form-group">
                    <label>Admin Notes</label>
                    <textarea name="notes" class="form-control" rows="4" placeholder="Add notes about this status change..."><?php echo e($payment->notes); ?></textarea>
                </div>
            </div>
            <div class="modal-footer">
                <button type="submit" class="btn btn-primary">Update Status</button>
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
            </div>
            <?php echo e(html()->form()->close()); ?>

        </div>
    </div>
</div>
<?php endif; ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make("admin.admin_app", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/dextragr/public_html/realestate.dextragroups.com/resources/views/admin/pages/payments/show.blade.php ENDPATH**/ ?>