@extends('site_app')

@section('head_title', getcong('site_name'))

@section('head_url', Request::url())

@section('content')

    {{-- @include('pages.home.slider') --}}

    <!--Hero section starts (Swiper slider)-->
    <div class="hero-swiper-wrapper">
        <!-- full-bleed helper: vfx-fullwidth-swiper makes slides span the viewport edges -->
        <div class="swiper-container hero-swiper vfx-fullwidth-swiper">
            <div class="swiper-wrapper">
                @foreach ($banners as $banner)
                    @php
                        $bannerLink = $banner->redirect_url ?? '';
                        $isExternal = $bannerLink && Str::startsWith($bannerLink, ['http://', 'https://']);
                    @endphp
                    <div class="swiper-slide">
                        @if ($bannerLink)
                            <a href="{{ $isExternal ? $bannerLink : url($bannerLink) }}"
                                @if ($isExternal) rel="noopener noreferrer" @endif class="banner-link">
                        @endif

                        <div class="hero vfx2 section-padding">
                            <img src="{{ URL::asset($banner->image_path) }}" alt="" class="hero-img" loading="lazy">
                            <div class="overlay"></div>
                            <!--Listing filter starts-->
                            <div class="container vfx-posabs">
                                <div class="row">
                                    <div class="col-md-10 offset-md-1">
                                        {{-- <div class="header-text vfx1">
                                            <p class="text-uppercase mb-10">{{ trans('words.slider_text1') }}</p>
                                            <h1>{{ trans('words.slider_text2') }}</h1>
                                            <p>{{ trans('words.slider_text3') }}</p>
                                        </div> --}}
                                    </div>
                                </div>
                            </div>
                            <!--Listing filter ends-->
                        </div>

                        @if ($bannerLink)
                            </a>
                        @endif
                    </div>
                @endforeach
            </div>
            <!-- Pagination -->
            <div class="swiper-pagination hero-swiper-pagination"></div>
            <!-- Navigation -->
            {{-- <div class="swiper-button-next hero-swiper-next"></div>
            <div class="swiper-button-prev hero-swiper-prev"></div> --}}
            <div class="hero-swiper-next"></div>
            <div class="hero-swiper-prev"></div>
        </div>
    </div>

    <style>
        /* ensure pagination dots are centered and visible on hero */
        .hero-swiper-wrapper .swiper-container {
            position: relative;
        }

        /* Make the swiper full-bleed (edge to edge) */
        .vfx-fullwidth-swiper {
            width: 100vw;
            margin-left: calc(50% - 50vw);
            margin-right: calc(50% - 50vw);
        }

        /* keep the slider behind the header (header has higher z-index) */
        .hero-swiper-wrapper {
            position: relative;
            z-index: 100;
        }

        .hero-swiper-pagination {
            position: absolute;
            bottom: 18px;
            left: 0;
            right: 0;
            margin: 0 auto;
            text-align: center;
            z-index: 120;
            /* above overlays and nav */
            pointer-events: auto;
            display: block;
        }

        .hero-swiper-pagination .swiper-pagination-bullet {
            display: inline-block;
            margin: 0 6px;
            width: 10px;
            height: 10px;
            opacity: 1;
            background: rgba(255, 255, 255, 0.9);
            border: 1px solid rgba(0, 0, 0, 0.12);
        }

        .hero-swiper-pagination .swiper-pagination-bullet-active {
            background: #088178;
            border-color: #088178;
        }

        /* make entire banner slide clickable when wrapped in .banner-link */
        .banner-link {
            display: block;
            position: relative;
            color: inherit;
            text-decoration: none;
        }

        .banner-link:focus {
            outline: 2px solid rgba(8, 129, 120, 0.6);
            outline-offset: 2px;
        }

        /* spacing between header and banner: computed at runtime from header height */
        .hero-swiper {
            margin-top: 0;
            /* JS will set exact value based on header height */
        }

        /* Reduce hero/banner height but allow images to be fully visible
                   by letting the image determine the slide height (max-height applied).
                   This avoids cropping while keeping a consistent maximum visual size. */
        .hero.vfx2 {
            height: auto !important;
            max-height: 520px;
            overflow: hidden;
            position: relative;
        }

        /* hero image: use natural aspect ratio, fit within max-height */
        .hero .hero-img {
            position: relative;
            display: block;
            width: 100%;
            height: 100%;
            min-height: 220px;
            max-height: 520px;
            object-fit: cover;
            object-position: center center;
            z-index: 0;
        }

        /* overlay and content should sit above the image and not add to container height */
        .hero .overlay {
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            z-index: 1;
        }

        /* .vfx-posabs is intended to absolutely position inner content over the hero; ensure it does not increase slide height */
        .hero .vfx-posabs {
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            z-index: 2;
            display: flex;
            align-items: center;
        }

        /* keep generic container positioning unchanged outside hero */
        .hero>.container {
            position: relative;
            z-index: 2;
        }

        @media (max-width: 991px) {
            .vfx-fullwidth-swiper {
                margin-left: 0;
                margin-right: 0;
                width: 100%;
            }

            .hero.vfx2 {
                max-height: 420px;
            }

            .hero .hero-img {
                object-fit: contain;
                max-height: 420px;
            }
        }

        /* mid-range fix for widths between ~776px and 990px */
        @media (min-width: 776px) and (max-width: 990px) {
            .hero.vfx2 {
                max-height: 340px;
                padding-top: 8px;
                padding-bottom: 8px;
            }

            .hero .hero-img {
                max-height: 340px;
                object-fit: cover;
            }

            /* margin-top is handled dynamically via JS to match header height */
        }

        @media (max-width: 767px) {

            /* reduce extra padding on small screens so hero height follows image */
            .hero.vfx2 {
                max-height: 300px;
                padding-top: 10px;
                padding-bottom: 10px;
            }

            .hero .hero-img {
                max-height: 300px;
            }
        }

        @media (max-width: 575px) {
            .hero.vfx2 {
                max-height: 240px;
                padding-top: 6px;
                padding-bottom: 6px;
            }

            .hero .hero-img {
                max-height: 240px;
            }
        }
    </style>

    @push('scripts')
        <script>
            document.addEventListener('DOMContentLoaded', function() {
                if (typeof Swiper !== 'undefined') {
                    var heroSwiper = new Swiper('.hero-swiper', {
                        loop: true,
                        slidesPerView: 1,
                        autoHeight: false,
                        autoplay: {
                            delay: 5000,
                            disableOnInteraction: false,
                            pauseOnMouseEnter: true
                        },
                        speed: 800,
                        grabCursor: true,
                        keyboard: {
                            enabled: true,
                            onlyInViewport: true
                        },
                        pagination: {
                            el: '.hero-swiper-pagination',
                            clickable: true
                        },
                        navigation: {
                            nextEl: '.hero-swiper-next',
                            prevEl: '.hero-swiper-prev'
                        },
                        // ffect: 'ffade,

                        effect: 'slide',
                        // effect: 'cube', cubeEffect: { shadow: true, slideShadows: true, shadowOffset: 20, shadowScale: 0.94 },                    fadeEffect: { crossFade: true },
                        a11y: true
                    });
                    // small debug: uncomment if bullets missing
                    // console.log('Hero swiper initialized, pagination children:', document.querySelector('.hero-swiper-pagination')?.children.length);
                } else {
                    console.warn('Swiper not found — ensure Swiper JS/CSS are loaded in layout.');
                }
            });
        </script>
    @endpush

    <!--Hero section ends-->

    <!-- Add banner Section -->
    @if (get_web_banner('home_top') != '')
        <div class="add_banner_section pb-0 mb-20">
            <div class="container">
                <div class="row">
                    <div class="col-md-12">
                        {!! stripslashes(get_web_banner('home_top')) !!}
                    </div>
                </div>
            </div>
        </div>
    @endif
    <!-- Add banner Section -->

    {{-- Property search section Start --}}
    <div class="vfx-team-section-area bg-cb-gra pb-20 pt-20">
        <div class="container">
            <div class="row">
                <div class="col-md-12">

                    {{ html()->form('GET', url('/properties/search'))->attributes(['class' => 'vfx_hero_form_area vfx2 filter listing-filter bg-cb', 'id' => 'search', 'role' => 'form'])->open() }}

                    <div class="row">
                        <div class="col-xl-4 col-lg-3 col-sm-12 pr-lg-0">
                            <div class="input-search">
                                <input type="text" name="search_text" id="search_text"
                                    placeholder="{{ trans('words.search_by_title') }}">
                            </div>
                        </div>
                        <div class="col-xl-2 col-lg-3 col-sm-12 pr-lg-0">
                            <select name="purpose" class="vfx_hero_form_area_input vfx-custom-select-area">
                                <option value="">{{ trans('words.purpose') }}</option>

                                <option value="{{ trans('words.sale') }}">{{ trans('words.sale') }}</option>
                                <option value="{{ trans('words.rent') }}">{{ trans('words.rent') }}</option>
                            </select>
                        </div>
                        <div class="col-xl-2 col-lg-3 col-sm-12 pr-lg-0">
                            <select name="type_id" class="vfx_hero_form_area_input vfx-custom-select-area">
                                <option value="">{{ trans('words.property_type') }}</option>
                                @foreach (\App\Type::where('status', 1)->orderby('type_name')->get() as $type_data)
                                    <option value="{{ $type_data->id }}">{{ $type_data->type_name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-xl-2 col-lg-3 col-sm-12 pr-lg-0">
                            <select name="location_id" class="vfx_hero_form_area_input vfx-custom-select-area">
                                <option value="">{{ trans('words.location') }}</option>
                                @foreach (\App\Location::where('status', 1)->orderby('name')->get() as $location_data)
                                    <option value="{{ $location_data->id }}">{{ $location_data->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-xl-2 col-lg-3 col-sm-12">
                            <div class="submit_btn">
                                <button class="btn vfx3" type="submit">{{ trans('words.search_text') }}</button>
                            </div>
                        </div>
                    </div>
                    {{ html()->form()->close() }}
                </div>
            </div>
        </div>
    </div>
    {{-- Property search section End --}}

    <!--Category section starts-->
    {{-- <div class="vfx-team-section-area bg-cb-gra pb-20 pt-20">
    <div class="container">
      <div class="row">
        <div class="col-md-12">
          <div class="section-title vid-item-section mb-15">
            <h2>{{trans('words.property_type')}}</h2>
			<span class="view-more">
			   <a href="{{ URL::to('types') }}" title="types">{{trans('words.view_all')}}<svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 512 512" style="vertical-align: text-top"><path fill="none" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round" stroke-width="60" d="m184 112l144 144l-144 144"></path></svg></a>
		    </span>
          </div>
        </div>
        <div class="col-md-12">
          <div class="vfx-team-wrapper swiper-container">
            <div class="swiper-wrapper">
              @foreach ($type_list as $type_data)
              <div class="swiper-slide">
                <div class="vfx-single-team-member vfx-cat-item vfx2"> <a href="{{ URL::to('types/'.$type_data->type_slug.'/'.$type_data->id) }}" title="{{$type_data->type_name}}"><img src="{{URL::to('/'.$type_data->type_image)}}" alt="{{$type_data->type_name}}" title="{{$type_data->type_name}}"></a>
                  <div class="vfx-single-team-info">
                    <h4><a href="{{ URL::to('types/'.$type_data->type_slug.'/'.$type_data->id) }}" title="{{$type_data->type_name}}">{{$type_data->type_name}}</a></h4>
                  </div>
                </div>
              </div>
              @endforeach

            </div>
            <div class="slider-btn vfx2 team_next"><i class="lnr lnr-arrow-right"></i></div>
            <div class="slider-btn vfx2 team_prev"><i class="lnr lnr-arrow-left"></i></div>
          </div>
        </div>
      </div>
    </div>
  </div> --}}
    <!--Category section starts-->

    <!--Latest Property Starts-->
    <div class="vfx-trending-places bg-cb pb-30 pt-20">
        <div class="container">
            <div class="row">
                <div class="col-md-12">
                    <div class="section-title vid-item-section mb-15">
                        <h2>{{ trans('words.latest_property') }}</h2>
                        <span class="view-more">
                            <a href="{{ URL::to('latest') }}" title="view all">{{ trans('words.view_all') }}<svg
                                    xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 512 512"
                                    style="vertical-align: text-top">
                                    <path fill="none" stroke="currentColor" stroke-linecap="round"
                                        stroke-linejoin="round" stroke-width="60" d="m184 112l144 144l-144 144"></path>
                                </svg></a>
                        </span>
                    </div>
                </div>
                <div class="swiper-container vfx-latest-property-wrap">
                    <div class="swiper-wrapper">

                        @foreach ($latest_list as $latest_data)
                            <div class="swiper-slide">
                                <div class="vfx-single-property-box-area">
                                    <div class="vfx-property-item"> <a class="vfx-property-img"
                                            href="{{ URL::to('properties/' . $latest_data->slug . '/' . $latest_data->id) }}"
                                            title="{{ stripslashes($latest_data->title) }}"><img
                                                src="{{ \URL::to('/' . $latest_data->image) }}" alt="image"
                                                title="image"> </a>
                                        <ul class="vfx-feature-text">
                                            @if ($latest_data->purpose == 'Rent')
                                                <li class="feature_cb"><span>{{ trans('words.rent') }}</span></li>
                                            @else
                                                <li class="feature_or"><span>{{ trans('words.sale') }}</span></li>
                                            @endif
                                            @if ($latest_data->verified == 'YES')
                                                <li class="feature_cb verified_item"><i class="fa fa-check 1"
                                                        data-toggle="tooltip" data-placement="top" title=""
                                                        data-original-title="{{ trans('words.verified') }}"></i></li>
                                            @endif
                                        </ul>
                                        <div class="vfx-property-author-wrap">
                                            <p class="text-tlt">{{ $latest_data->types->type_name }}</p>
                                            <ul class="vfx-save-btn">

                                                <li data-toggle="tooltip" data-placement="top" title=""
                                                    data-original-title="Set Favourite"
                                                    class="favourite_property favourite_title_id{{ $latest_data->id }}"
                                                    data-id="{{ $latest_data->id }}">
                                                    @if (check_favourite('Property', $latest_data->id, isset(Auth::user()->id) ? Auth::user()->id : ''))
                                                        <a href="Javascript:void(0);" title="fav"><i
                                                                class="fa fa-heart favourite_icon_id{{ $latest_data->id }}"></i></a>
                                                    @else
                                                        <a href="Javascript:void(0);" title="fav"><i
                                                                class="fa fa-heart-o favourite_icon_id{{ $latest_data->id }}"></i></a>
                                                    @endif
                                                </li>

                                            </ul>
                                        </div>
                                    </div>
                                    <div class="vfx-property-title-box-area">
                                        <h4><a href="{{ URL::to('properties/' . $latest_data->slug . '/' . $latest_data->id) }}"
                                                title="{{ stripslashes($latest_data->title) }}">{{ Str::limit(stripslashes($latest_data->title), 30) }}</a>
                                        </h4>
                                        <div class="vfx-property-location"> <i class="fa fa-map-marker"></i>
                                            <p>
                                                @if (isset($latest_data->locations->name) and $latest_data->locations->name != '')
                                                    {{ $latest_data->locations->name }}
                                                @else
                                                    {{ Str::limit(stripslashes($latest_data->address), 40) }}
                                                @endif
                                            </p>
                                        </div>
                                        <div class="trending-bottom">
                                            <div class="trend-left float-left">
                                                <div class="vfx-property-author-wrap">
                                                    <a href="{{ URL::to('properties/owner/' . $latest_data->user_id) }}"
                                                        class="property-author" title="user profile">

                                                        @if ($latest_data->users->user_image)
                                                            <img src="{{ \URL::to('upload/' . $latest_data->users->user_image) }}"
                                                                alt="user_image"
                                                                title="{{ stripslashes($latest_data->title) }}">
                                                        @else
                                                            <img src="{{ \URL::to('site_assets/images/user-default.jpg') }}"
                                                                alt="user" title="title">
                                                        @endif

                                                        <span>{{ $latest_data->users->name }}</span>
                                                    </a>
                                                </div>
                                            </div>
                                            <a href="{{ URL::to('properties/' . $latest_data->slug . '/' . $latest_data->id) }}"
                                                class="vfx-trend-right float-right"
                                                title="{{ stripslashes($latest_data->title) }}">
                                                <div class="vfx-trend-open-price">
                                                    {{ html_entity_decode(getCurrencySymbols(getcong('currency_code'))) }}{{ number_format($latest_data->price) }}
                                                </div>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endforeach


                    </div>
                </div>
                <div class="vfx-latest-property-pagination"></div>
            </div>
        </div>
    </div>
    <!--Latest Property Ends-->

    @if (count($trending_list) > 0)
        <!--Popular Property Starts-->
        <div class="vfx-trending-places our-story-bg-2 pb-30 mt-20">
            <div class="container">
                <div class="row">
                    <div class="col-md-12">
                        <div class="section-title vid-item-section mb-15">
                            <h2>{{ trans('words.trending_now') }}</h2>
                            <span class="view-more">
                                <a href="{{ URL::to('popular') }}" title="popular">{{ trans('words.view_all') }}<svg
                                        xmlns="http://www.w3.org/2000/svg" width="18" height="18"
                                        viewBox="0 0 512 512" style="vertical-align: text-top">
                                        <path fill="none" stroke="currentColor" stroke-linecap="round"
                                            stroke-linejoin="round" stroke-width="60" d="m184 112l144 144l-144 144">
                                        </path>
                                    </svg></a>
                            </span>
                        </div>
                    </div>
                    <div class="swiper-container vfx-popular-property-wrap">
                        <div class="swiper-wrapper">

                            @foreach ($trending_list as $trending_data)
                                @php
                                    $property_info = \App\Property::find($trending_data->post_id);
                                @endphp
                                <div class="swiper-slide">
                                    <div class="vfx-single-property-box-area">
                                        <div class="vfx-property-item"> <a class="vfx-property-img"
                                                href="{{ URL::to('properties/' . $property_info->slug . '/' . $property_info->id) }}"
                                                title="{{ stripslashes($property_info->title) }}"><img
                                                    src="{{ \URL::to('/' . $property_info->image) }}" alt="image"
                                                    title="image"> </a>
                                            <ul class="vfx-feature-text">
                                                @if ($property_info->purpose == 'Rent')
                                                    <li class="feature_cb"><span>{{ trans('words.rent') }}</span></li>
                                                @else
                                                    <li class="feature_or"><span>{{ trans('words.sale') }}</span></li>
                                                @endif

                                                @if ($property_info->verified == 'YES')
                                                    <li class="feature_cb verified_item"><i class="fa fa-check 1"
                                                            data-toggle="tooltip" data-placement="top" title=""
                                                            data-original-title="{{ trans('words.verified') }}"></i></li>
                                                @endif
                                            </ul>
                                            <div class="vfx-property-author-wrap">
                                                <p class="text-tlt">{{ $property_info->types->type_name }}</p>
                                                <ul class="vfx-save-btn">

                                                    <li data-toggle="tooltip" data-placement="top" title=""
                                                        data-original-title="Set Favourite"
                                                        class="favourite_property favourite_title_id{{ $property_info->id }}"
                                                        data-id="{{ $property_info->id }}">
                                                        @if (check_favourite('Property', $property_info->id, isset(Auth::user()->id) ? Auth::user()->id : ''))
                                                            <a href="Javascript:void(0);" title="view"><i
                                                                    class="fa fa-heart favourite_icon_id{{ $property_info->id }}"></i></a>
                                                        @else
                                                            <a href="Javascript:void(0);" title="view"><i
                                                                    class="fa fa-heart-o favourite_icon_id{{ $property_info->id }}"></i></a>
                                                        @endif
                                                    </li>

                                                </ul>
                                            </div>
                                        </div>
                                        <div class="vfx-property-title-box-area">
                                            <h4><a href="{{ URL::to('properties/' . $property_info->slug . '/' . $property_info->id) }}"
                                                    title="{{ stripslashes($property_info->title) }}">{{ Str::limit(stripslashes($property_info->title), 30) }}</a>
                                            </h4>
                                            <div class="vfx-property-location"> <i class="fa fa-map-marker"></i>
                                                <p>
                                                    @if (isset($property_info->locations->name) and $property_info->locations->name != '')
                                                        {{ $property_info->locations->name }}
                                                    @else
                                                        {{ Str::limit(stripslashes($property_info->address), 40) }}
                                                    @endif
                                                </p>
                                            </div>
                                            <div class="trending-bottom">
                                                <div class="trend-left float-left">
                                                    <div class="vfx-property-author-wrap">
                                                        <a href="{{ URL::to('properties/owner/' . $property_info->user_id) }}"
                                                            class="property-author">

                                                            @if ($property_info->users->user_image)
                                                                <img src="{{ \URL::to('upload/' . $property_info->users->user_image) }}"
                                                                    alt="user_image"
                                                                    title="{{ stripslashes($property_info->title) }}">
                                                            @else
                                                                <img src="{{ \URL::to('site_assets/images/user-default.jpg') }}"
                                                                    alt="user_image"
                                                                    title="{{ stripslashes($property_info->title) }}">
                                                            @endif

                                                            <span>{{ $property_info->users->name }}</span>
                                                        </a>
                                                    </div>
                                                </div>
                                                <a href="{{ URL::to('properties/' . $property_info->slug . '/' . $property_info->id) }}"
                                                    class="vfx-trend-right float-right"
                                                    title="{{ stripslashes($property_info->title) }}">
                                                    <div class="vfx-trend-open-price">
                                                        {{ html_entity_decode(getCurrencySymbols(getcong('currency_code'))) }}{{ number_format($property_info->price) }}
                                                    </div>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            @endforeach


                        </div>
                    </div>
                    <div class="vfx-popular-property-pagination"></div>
                </div>
            </div>
        </div>
        <!--Popular Property Ends-->
    @endif

    <!-- Add banner Section -->
    @if (get_web_banner('home_bottom') != '')
        <div class="add_banner_section pt-0">
            <div class="container">
                <div class="row">
                    <div class="col-md-12">
                        {!! stripslashes(get_web_banner('home_bottom')) !!}
                    </div>
                </div>
            </div>
        </div>
    @endif

    <span class="vfx-scroll-top-btn"><i class="lnr lnr-arrow-up"></i></span>


    <!--Page Wrapper ends-->
@endsection
